/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.sales.Customer;
import ordermate.gui.autosuggestor.StringSearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.SuggestDialog;
import waitermate.gui.screens.customer.search.CustomerSearch;
import waitermate.gui.screens.debtor.SelectDebtorNavBar;
import waitermate.gui.screens.debtor.components.DebtorSnapShotSideBar;
import waitermate.gui.screens.debtor.components.SelectDebtorButtonRenderer;

public class DebtorSelectionPanel
extends JPanel {
    private DebtorSnapShotSideBar sideBar = new DebtorSnapShotSideBar();
    private SelectDebtorButtonRenderer renderer = new SelectDebtorButtonRenderer();
    private RendererScrollPaneModel<AbstractDebtor> scrollModel = this.createScrollModel();
    private CustomScrollPane debtorListPane = new CustomScrollPane(this.scrollModel);
    private String debtorNameSearch = "";
    private Customer customerSearchField = null;
    private List selectedDebtorGroups = new ArrayList();
    private List<AbstractDebtor> debtors = new ArrayList<AbstractDebtor>();
    private List<Class> debtorTypeFilter = new ArrayList<Class>();
    private List<String> paymentStatusFilter = new ArrayList<String>();
    public final Signal<AbstractDebtor, ?, ?, ?, ?> debtorSelectedSignal = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    public final Signal<Boolean, ?, ?, ?, ?> hasFilter = Signals.createSignal(Boolean.class, (String)"hasSignal");
    public final Signal back = Signals.createSignal();
    private CustomerSearch customerSearch;
    private SelectDebtorNavBar nav;
    private boolean setup = false;

    public DebtorSelectionPanel(SelectDebtorNavBar nav) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(4, 1), 0, 0));
        this.sideBar.getInfoPanel().customerSignal.connect((Object)this, "gotCustomerSearch");
        this.sideBar.getInfoPanel().debtorSignal.connect((Object)this, "gotDebtorSearch");
        this.sideBar.getInfoPanel().dateChangedSignal.connect((Object)this, "gotDateFilterChanged");
        this.sideBar.getInfoPanel().roomNumChangedSignal.connect((Object)this, "gotRoomNumFilterChanged");
        this.renderer.debtorSelectedSignal.connect((Object)this, "gotDebtor");
        this.add((Component)this.sideBar, new Rectangle(0, 0, 1, 1));
        this.add((Component)this.debtorListPane, new Rectangle(1, 0, 3, 1));
        this.gotTerminalChanged();
        CustomerSearch.terminalSetupChanged.connect((Object)this, "gotTerminalChanged");
        nav.groupsFilterSignal.connect((Object)this, "gotDebtorGroupFilter");
        nav.statusFilterSignal.connect((Object)this, "gotPaymentStatusFilter");
        nav.clear.connect((Object)this, "clearSearch");
        this.hasFilter.connect((Object)nav, "setHasExternalFilters");
        this.nav = nav;
        this.setup = true;
    }

    private void gotTerminalChanged() {
        if (this.customerSearch != null) {
            this.customerSearch.back.disconnect((Object)this);
            this.customerSearch.selected.disconnect((Object)this);
            this.customerSearch.edit.disconnect((Object)this);
            this.customerSearch = null;
        }
        this.customerSearch = new CustomerSearch(null, true, false);
        this.customerSearch.setAddButtonVisible(false);
        this.customerSearch.back.connect((Object)this, "gotBack");
        this.customerSearch.selected.connect((Object)this, "gotCustomer");
        this.customerSearch.edit.connect((Object)this, "gotEditCustomer");
    }

    private RendererScrollPaneModel<AbstractDebtor> createScrollModel() {
        int columns = GuiConfigManager.getIntegerProperty((GuiConfigSet)LoginManager.getEventContext().getTerminal().getScreenLayoutSet(), (GuiConfigManager.CompStrings)GuiConfigManager.CompStrings.DEBTORS, (GuiConfigManager.PropStrings)GuiConfigManager.PropStrings.COLUMNS);
        int rows = GuiConfigManager.getIntegerProperty((GuiConfigSet)LoginManager.getEventContext().getTerminal().getScreenLayoutSet(), (GuiConfigManager.CompStrings)GuiConfigManager.CompStrings.DEBTORS, (GuiConfigManager.PropStrings)GuiConfigManager.PropStrings.ROWS);
        return new RendererScrollPaneModel((Renderer)this.renderer, columns < 1 ? 3 : columns, rows < 1 ? 6 : rows);
    }

    public void setSetUp(boolean value) {
        ExperimentalFeature honourSetup = ExperimentalFeature.find((String)"Debtor Refresh Fix");
        if (honourSetup != null && Boolean.TRUE.equals(honourSetup.getBooleanValue(Boolean.FALSE))) {
            this.setup = value;
        }
    }

    public void updateModel() {
        if (!this.setup) {
            return;
        }
        this.debtors = DebtorQueries.getFilteredDebtorList((String)this.debtorNameSearch, (Customer)this.customerSearchField, (List)this.selectedDebtorGroups, this.paymentStatusFilter, this.debtorTypeFilter, (Date)this.sideBar.getStartDateFilter(), (String)this.sideBar.getRoomNumberFilter());
        this.scrollModel.setObjects(this.debtors);
        this.sideBar.setDebtors(this.debtors);
        this.sideBar.getInfoPanel().setCustomerData(this.customerSearchField);
        this.nav.setFilters(this.paymentStatusFilter);
        this.doFilteredSignal();
    }

    private void clearModel() {
        this.scrollModel.setObjects(new ArrayList());
        this.sideBar.setDebtors(new ArrayList());
    }

    public void gotCustomerSearch() {
        this.customerSearch.reset();
        this.customerSearch.display();
    }

    public void gotDebtorSearch(AbstractDebtor debtor) {
        StringSearcherSuggestor suggestor = new StringSearcherSuggestor(AbstractDebtor.Properties.LABEL);
        suggestor.setActiveRestriction(AbstractDebtor.class);
        boolean useNumericKeyPad = false;
        String str = (String)SuggestDialog.getSuggestion("Account Name", debtor.getLabel(), "Account Name", (Suggestor)suggestor, useNumericKeyPad, true);
        this.sideBar.getInfoPanel().setDebtor(null);
        if (str != "\u0000") {
            this.debtorNameSearch = str;
            this.sideBar.getInfoPanel().setAccountName(str);
        } else {
            this.debtorNameSearch = "";
            this.sideBar.getInfoPanel().setAccountName("");
        }
        this.doFilteredSignal();
        this.updateModel();
    }

    private void doFilteredSignal() {
        boolean isFiltered = false;
        if (this.debtorNameSearch != "") {
            isFiltered = true;
        } else if (this.customerSearchField != null) {
            isFiltered = true;
        }
        this.hasFilter.emit((Object)isFiltered);
    }

    public void gotCustomer(Customer customer) {
        this.back.emit();
        this.setCustomer(customer);
        this.updateModel();
    }

    public void setCustomer(Customer customer) {
        this.customerSearchField = customer;
        this.updateModel();
    }

    public void gotDebtor(AbstractDebtor debtor) {
        this.debtorSelectedSignal.emit((Object)debtor);
    }

    public void gotBack() {
        this.back.emit();
        this.clearModel();
    }

    public void gotDebtorGroupFilter(List debtorGroups) {
        this.selectedDebtorGroups = debtorGroups;
        this.updateModel();
    }

    public void clearTypeFilter() {
        this.debtorTypeFilter.clear();
        this.updateModel();
    }

    public void setTypeFilter(Class type) {
        this.debtorTypeFilter.clear();
        if (type != null) {
            this.debtorTypeFilter.add(type);
            if (type == CustomerDebtor.class) {
                this.debtorTypeFilter.add(SimpleDebtor.class);
            }
        }
        this.updateModel();
    }

    public void gotPaymentStatusFilter(String status) {
        if (!this.paymentStatusFilter.contains(status)) {
            this.paymentStatusFilter.add(status);
        } else {
            this.paymentStatusFilter.remove(status);
        }
        this.updateModel();
    }

    public void gotDateFilterChanged() {
        this.updateModel();
    }

    public void gotRoomNumFilterChanged() {
        this.updateModel();
    }

    public void clearSearch() {
        this.sideBar.clearFilters();
        this.debtorNameSearch = "";
        this.customerSearchField = null;
        this.selectedDebtorGroups = new ArrayList();
        this.paymentStatusFilter.clear();
        this.doFilteredSignal();
        this.updateModel();
    }

    public List<AbstractDebtor> getDebtors() {
        return this.debtors;
    }

    public void gotEditCustomer(Customer toEdit) {
    }
}

