/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import waitermate.gui.screens.debtor.components.AbstractDebtorInfoPanel;
import waitermate.gui.screens.debtor.components.DebtorInfoPanel;
import waitermate.gui.screens.debtor.components.DebtorSearchPanel;
import waitermate.gui.screens.debtor.components.DebtorSummaryPanel;

public class DebtorSnapShotSideBar
extends JPanel {
    AbstractDebtorInfoPanel infoPanel;
    DebtorSummaryPanel summaryPanel;
    boolean isSearch = false;
    private Date initialDate;

    public DebtorSnapShotSideBar() {
        this(true, null);
    }

    private DebtorSnapShotSideBar(boolean isSearchPanel, AbstractDebtor debtor) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(1, 3), 0, 0));
        this.isSearch = isSearchPanel;
        AbstractDebtor thisDebtor = debtor;
        if (thisDebtor == null) {
            thisDebtor = new SimpleDebtor();
        }
        String infoTitle = "";
        if (isSearchPanel) {
            this.infoPanel = new DebtorSearchPanel(thisDebtor);
            infoTitle = "Debtor Search";
        } else {
            this.infoPanel = new DebtorInfoPanel(thisDebtor);
            infoTitle = "Debtor Info";
        }
        this.summaryPanel = new DebtorSummaryPanel();
        this.setupGui();
    }

    public DebtorSnapShotSideBar(AbstractDebtor debtor) {
        this(false, debtor);
    }

    public void setDebtor(AbstractDebtor debtor) {
        this.infoPanel.setDebtor(debtor);
        this.summaryPanel.summarize(debtor);
    }

    public void setDebtors(List newDebtors) {
        this.summaryPanel.summarize(newDebtors);
    }

    private void setupGui() {
        this.add((Component)this.infoPanel, new Rectangle(0, 0, 1, 2));
        this.add((Component)this.summaryPanel, new Rectangle(0, 2, 1, 1));
        this.setBorder(new EtchedBorder());
    }

    public AbstractDebtorInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public void clearFilters() {
        if (this.isSearch) {
            this.infoPanel.clearFilters(this.initialDate);
        } else {
            this.infoPanel.resetDateFilter(this.initialDate);
        }
    }

    public Date getStartDateFilter() {
        return this.infoPanel.getStartDateFilter();
    }

    public String getRoomNumberFilter() {
        return this.infoPanel.getRoomNumberFilter();
    }

    public void setInitialDate(Date value) {
        this.initialDate = value;
        this.infoPanel.resetDateFilter(this.initialDate);
    }
}

