/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.persistence.Displayable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ordermate.gui.DisplayableString;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.components.DefaultSelectableDrawerPanel;

public class PaymentStatusDrawPanel
extends DefaultSelectableDrawerPanel {
    private static final DisplayableString OVERDUE = new DisplayableString("Overdue", null, Displayable.OVERDUE_COLOR, null);
    private static final DisplayableString OUTSTANDING = new DisplayableString("Outstanding", null, Displayable.PRINTED_COLOR, null);
    private static final DisplayableString PAID = new DisplayableString("Paid", null, Displayable.PAID_COLOR, null);
    private static final DisplayableString ZERO = new DisplayableString("Zero", null, null, null);
    private static final DisplayableString ALL = new DisplayableString("All", null, null, null);
    public static final DisplayableString DEFAULT = new DisplayableString("DEFAULT");
    private static final DisplayableString[] PAYMENTS_STATUS = new DisplayableString[]{ZERO, PAID, OUTSTANDING, OVERDUE};
    private DisplayableString selectedString = DEFAULT;

    public PaymentStatusDrawPanel() {
        super(Arrays.asList(PAYMENTS_STATUS), Displayable.class);
        this.setTitle("Select the payment status");
        this.selected.connect((Object)this, "gotSelected");
        this.init(Displayable.class);
    }

    public void gotSelected(Displayable displayable) {
        this.selectedString = (DisplayableString)displayable;
        if (this.selectedString.getBackgroundColor() == null || this.selectedString.getBackgroundColor().getRGB() != Color.GREEN.getRGB()) {
            this.selectedString.setBackgroundColor(Color.GREEN);
        } else {
            this.deSelect(this.selectedString);
        }
        this.changed.emit();
    }

    private Color findBackgroundColor(DisplayableString incomingSelectedString) {
        Color toReturn = null;
        if (OVERDUE.equals((Object)incomingSelectedString)) {
            toReturn = Displayable.OVERDUE_COLOR;
        } else if (OUTSTANDING.equals((Object)incomingSelectedString)) {
            toReturn = Displayable.PRINTED_COLOR;
        } else if (PAID.equals((Object)incomingSelectedString)) {
            toReturn = Displayable.PAID_COLOR;
        }
        return toReturn;
    }

    public String getSelectedPaymentStatus() {
        return this.selectedString.toString();
    }

    public void setToggledPaymentStatusButtons(List<String> toToggle) {
    }

    public void setSelectAll() {
        this.selectedString = ALL;
    }

    public void reset() {
        this.selectedString = DEFAULT;
        for (DisplayableString string : PAYMENTS_STATUS) {
            this.deSelect(string);
        }
    }

    private void deSelect(DisplayableString string) {
        string.setBackgroundColor(this.findBackgroundColor(string));
        CustomToggleButton button = (CustomToggleButton)this.getModel().getComponent((Displayable)string);
        if (button != null) {
            button.setBackground(string.getBackgroundColor());
            button.setSelected(false);
        }
    }

    public void setToggledStatuses(List<String> statuses) {
        ArrayList<DisplayableString> releventStatuses = new ArrayList<DisplayableString>();
        for (String string : statuses) {
            for (DisplayableString y : Arrays.asList(PAYMENTS_STATUS)) {
                if (!string.equalsIgnoreCase(y.getLabel())) continue;
                releventStatuses.add(y);
            }
        }
        for (Displayable displayable : releventStatuses) {
            CustomToggleButton button = (CustomToggleButton)this.getModel().getComponent(displayable);
            button.setSelected(true);
        }
    }

    protected Renderer constructRenderer() {
        ToggleDisplayableRenderer displayableRenderer = new ToggleDisplayableRenderer();
        displayableRenderer.selected.connect((Object)this, "gotSelected");
        return displayableRenderer;
    }

    private static class ToggleDisplayableRenderer
    implements Renderer,
    ActionListener {
        public final Signal<Displayable, ?, ?, ?, ?> selected = Signals.createSignal(Displayable.class, (String)"selection");

        private ToggleDisplayableRenderer() {
        }

        public CustomToggleButton createComponent() {
            CustomToggleButton button = new CustomToggleButton();
            button.addActionListener((ActionListener)this);
            return button;
        }

        public void setupComponent(Component component, Object object, int index) {
            Displayable displayable = (Displayable)object;
            if (!(component instanceof CustomToggleButton)) {
                throw new IllegalArgumentException("Component is not a custom button or custom toggle button.");
            }
            CustomToggleButton button = (CustomToggleButton)component;
            button.setData(displayable);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CustomToggleButton button = (CustomToggleButton)event.getSource();
            this.selected.emit((Object)button.getData());
        }
    }
}

