/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;

public class SelectDebtorButtonRenderer
implements Renderer {
    public final Signal debtorSelectedSignal = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    private static final Map<Class<? extends AbstractDebtor>, TextRenderer> rendererMap;
    private static final TextRenderer defaultRenderer;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomButton button = (CustomButton)e.getSource();
            SelectDebtorButtonRenderer.this.debtorSelectedSignal.emit((Object)button.getData());
        }
    };

    public Component createComponent() {
        CustomButton button = new CustomButton();
        button.addActionListener(this.listener);
        return button;
    }

    public void setupComponent(Component component, Object object, int index) {
        CustomButton button = (CustomButton)component;
        AbstractDebtor debtor = (AbstractDebtor)object;
        button.setData((Displayable)debtor);
        if (debtor == null || debtor.getIcon().equalsIgnoreCase("")) {
            button.setIcon(null);
        }
        if (debtor != null) {
            this.getRendererForDebtor(debtor).setupText(debtor, button);
        }
    }

    private TextRenderer getRendererForDebtor(AbstractDebtor debtor) {
        TextRenderer renderer = rendererMap.get(debtor.getClass());
        if (renderer == null) {
            return defaultRenderer;
        }
        return renderer;
    }

    static {
        HashMap<Class<RoomAccount>, RoomAccountRenderer> map = new HashMap<Class<RoomAccount>, RoomAccountRenderer>();
        map.put(RoomAccount.class, new RoomAccountRenderer());
        rendererMap = Collections.unmodifiableMap(map);
        defaultRenderer = new DefaultRenderer();
    }

    private static class DefaultRenderer
    implements TextRenderer {
        private DefaultRenderer() {
        }

        @Override
        public void setupText(AbstractDebtor debtor, CustomButton button) {
            if (debtor == null || debtor.getLabel() == null || debtor.getLabel().equalsIgnoreCase("")) {
                button.setText("");
                return;
            }
            StringBuilder HTMLText = new StringBuilder();
            HTMLText.append("<HTML><B>" + debtor.getLabel() + "</B> : ");
            HTMLText.append(debtor.getAmountOutstanding());
            HTMLText.append("<FONT COLOR=GRAY>");
            if (debtor.hasOutstanding() && debtor.getEarliestDueDate() != null) {
                HTMLText.append("<BR>Due: " + DateTimeUtils.getMediumDateFormat().format(debtor.getEarliestDueDate()));
            }
            User loggedInUser = LoginManager.getInstance().getUser();
            if (!debtor.getCreditLimit().equals((Object)Price.ZERO) && loggedInUser != null && !loggedInUser.getPermissionAccessLevel(AllPermissions.CHANGE_CREDIT_LIMIT).equals("HIDDEN")) {
                HTMLText.append(" Limit:&nbsp;" + debtor.getCreditLimit() + "&nbsp;&nbsp;&nbsp;");
            }
            if (debtor.getTermsValue().getDays() != 0) {
                HTMLText.append("Terms : " + debtor.getTermsValue().toString());
            }
            HTMLText.append("</FONT>");
            HTMLText.append("<BR><B>" + debtor.getGroup() + "</B>");
            HTMLText.append("</HTML>");
            button.setText(HTMLText.toString());
        }
    }

    private static class RoomAccountRenderer
    implements TextRenderer {
        private RoomAccountRenderer() {
        }

        @Override
        public void setupText(AbstractDebtor debtor, CustomButton button) {
            if (debtor == null) {
                button.setText("");
                return;
            }
            String HTMLText = "<HTML><B>" + debtor.getLabel() + "</B>  ";
            if (debtor.getGroup() != null) {
                HTMLText = HTMLText + debtor.getGroup().getLabel();
            }
            HTMLText = HTMLText + "<FONT COLOR=GRAY>";
            if (debtor instanceof RoomAccount) {
                RoomAccount roomAccount = (RoomAccount)debtor;
                HTMLText = HTMLText + "<BR> Room #: " + roomAccount.getRoomNumber();
            }
            if (debtor.hasOutstanding() && debtor.getEarliestDueDate() != null) {
                HTMLText = HTMLText + "<BR>" + debtor.getAmountOutstanding();
            }
            HTMLText = HTMLText + "<BR>";
            if (!debtor.getCreditLimit().equals((Object)Price.ZERO_DOLLAR)) {
                HTMLText = HTMLText + "Limit: " + debtor.getCreditLimit() + "&nbsp;&nbsp;&nbsp;";
            }
            HTMLText = HTMLText + "</FONT></HTML>";
            button.setText(HTMLText);
        }
    }

    static interface TextRenderer {
        public void setupText(AbstractDebtor var1, CustomButton var2);
    }
}

