/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.SingleSelectable;
import waitermate.LoginManager;
import waitermate.gui.screens.debtor.debtortransactions.DebtorHistoryRenderer;

public class DebtorHistoryModel
extends RendererScrollPaneModel {
    private DebtorHistoryRenderer renderer;
    private List<DebtorSale> debtorSales = new ArrayList<DebtorSale>();
    private List<DebtorPayment> debtorPayments = new ArrayList<DebtorPayment>();
    private List<Price> outstanding = new ArrayList<Price>();
    private static final int[] COLUMN_WIDTHS = new int[]{45, 40, 15};
    private static final int ROWS_PER_PAGE;

    public DebtorHistoryModel(DebtorHistoryRenderer theRenderer) {
        super((Renderer)theRenderer, COLUMN_WIDTHS, ROWS_PER_PAGE);
        this.renderer = theRenderer;
        this.renderer.refresh.connect((Object)this, "refresh");
    }

    public Component getComponent(int compIndex) {
        int index = compIndex;
        if (index < 0 || index >= this.getSize()) {
            String s = index + " is < 0 or >= " + this.getSize();
            throw new ArrayIndexOutOfBoundsException(s);
        }
        Object obj = this.objects.get(index);
        Object nextObj = null;
        if (index != this.objects.size() - 1) {
            nextObj = this.objects.get(index + 1);
        }
        if (this.components[index %= this.getRowsPerPage() * this.getColumns()] == null) {
            this.components[index] = this.renderer.createComponent(index);
            if (this.components[index] instanceof SingleSelectable) {
                SingleSelectable ss = (SingleSelectable)this.components[index];
                this.getSelectionGroup().add(ss.getSingleSelectableButton());
                this.compMap.put(ss.getSingleSelectableButton(), index);
            }
        }
        try {
            this.renderer.setupComponent(this.components[index], obj, index);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error rendering object in render scroll pane", (Throwable)e);
            this.components[index] = this.renderer.createComponent(index);
        }
        return this.components[index];
    }

    public void setData(List<DebtorSale> newDebtorSales, List<DebtorPayment> unmatchedPayments, Price newOpeningBalance) {
        this.renderer.refresh();
        this.debtorSales.clear();
        this.debtorSales.addAll(newDebtorSales);
        this.outstanding.clear();
        this.debtorPayments.clear();
        double amountOutstanding = newOpeningBalance.doubleValue();
        for (int salesIndex = 0; salesIndex < this.debtorSales.size(); ++salesIndex) {
            DebtorSale currentSale = this.debtorSales.get(salesIndex);
            amountOutstanding += currentSale.getAmount().doubleValue();
            List salePayments = currentSale.getPayments();
            for (DebtorPayment payment : salePayments) {
                amountOutstanding -= payment.getAmount().doubleValue();
                salesIndex = this.addPayment(salesIndex, payment);
            }
            int currentSalesListSize = salesIndex + 1;
            while (this.debtorPayments.size() < currentSalesListSize) {
                this.debtorPayments.add(null);
            }
            while (this.debtorPayments.size() > currentSalesListSize) {
                this.debtorSales.add(salesIndex + 1, null);
                currentSalesListSize = ++salesIndex + 1;
                this.outstanding.add(new Price(amountOutstanding, 0.0));
            }
            this.outstanding.add(new Price(amountOutstanding, 0.0));
        }
        while (this.debtorPayments.size() < this.debtorSales.size()) {
            this.debtorPayments.add(null);
        }
        Assert.isTrue((this.debtorPayments.size() == this.debtorSales.size() ? 1 : 0) != 0, (String)("List out of sync: " + this.debtorPayments.size() + "  :  " + this.debtorSales.size()));
        Assert.isTrue((this.outstanding.size() == this.debtorSales.size() ? 1 : 0) != 0, (String)("Outstanding List out of sync:" + this.outstanding.size() + "  " + this.debtorSales.size()));
        if (unmatchedPayments != null) {
            amountOutstanding = this.doUnmatchedPayments(unmatchedPayments, amountOutstanding);
        }
        if (this.outstanding.size() > 0) {
            this.outstanding.set(this.outstanding.size() - 1, new Price(amountOutstanding, 0.0));
        }
        Assert.isTrue((this.debtorPayments.size() == this.debtorSales.size() ? 1 : 0) != 0, (String)("List out of sync: " + this.debtorPayments.size() + "  :  " + this.debtorSales.size()));
        Assert.isTrue((this.outstanding.size() == this.debtorSales.size() ? 1 : 0) != 0, (String)("Outstanding List out of sync:" + this.outstanding.size() + "  " + this.debtorSales.size()));
        ArrayList<Object> theObjects = new ArrayList<Object>(this.debtorSales.size() * 3);
        for (int i = 0; i < this.debtorSales.size(); ++i) {
            theObjects.add(this.debtorSales.get(i));
            theObjects.add(this.debtorPayments.get(i));
            theObjects.add(this.outstanding.get(i));
        }
        this.setObjects(theObjects);
    }

    public void setObjects(List objectList) {
        this.preListChange();
        this.objects = new ArrayList(objectList);
        this.postListChange();
    }

    private int addPayment(int newIndex, DebtorPayment payment) {
        if (payment == null) {
            this.debtorPayments.add(newIndex, null);
        }
        int indexOf = -1;
        for (int i = 0; i < this.debtorPayments.size(); ++i) {
            if (this.debtorPayments.get(i) == null || !this.debtorPayments.get(i).getFinanceTransaction().equals((Object)payment.getFinanceTransaction())) continue;
            indexOf = i;
        }
        if (indexOf >= 0) {
            if (newIndex > indexOf) {
                while (newIndex > this.debtorPayments.size()) {
                    this.addPayment(this.debtorPayments.size(), null);
                }
                this.debtorPayments.set(indexOf, null);
                if (this.debtorPayments.size() > newIndex && this.debtorPayments.get(newIndex) == null) {
                    this.debtorPayments.set(newIndex, payment);
                } else {
                    this.debtorPayments.add(newIndex, payment);
                }
                if (this.debtorPayments.get(indexOf) == null && this.debtorSales.size() > indexOf && this.debtorSales.get(indexOf) == null) {
                    this.debtorSales.remove(indexOf);
                    this.debtorPayments.remove(indexOf);
                    this.outstanding.remove(indexOf);
                    return newIndex - 1;
                }
            }
        } else if (newIndex >= this.debtorPayments.size() || this.debtorPayments.get(newIndex) != null) {
            this.debtorPayments.add(payment);
        } else {
            this.debtorPayments.set(newIndex, payment);
        }
        return newIndex;
    }

    private double doUnmatchedPayments(List unmatchedPayments, double newAmountOutstanding) {
        double amountOutstanding = newAmountOutstanding;
        for (DebtorPayment currentPayment : unmatchedPayments) {
            amountOutstanding -= currentPayment.getAmount().doubleValue();
            this.addPayment(this.debtorPayments.size(), currentPayment);
        }
        while (this.debtorPayments.size() > this.debtorSales.size()) {
            this.debtorSales.add(null);
            this.outstanding.add(new Price(amountOutstanding, 0.0));
        }
        return amountOutstanding;
    }

    public void selectAllSales(boolean select) {
        ArrayList<DebtorSale> notNullSales = new ArrayList<DebtorSale>(this.debtorSales.size());
        for (DebtorSale sale : this.debtorSales) {
            if (sale == null) continue;
            notNullSales.add(sale);
        }
        this.renderer.selectAllSales(notNullSales, select);
    }

    public void selectAllPayments(boolean select) {
        ArrayList<DebtorPayment> notNullPayments = new ArrayList<DebtorPayment>(this.debtorPayments.size());
        for (DebtorPayment nextPayment : this.debtorPayments) {
            if (nextPayment == null || nextPayment.getFinanceTransaction() == null) continue;
            notNullPayments.add(nextPayment);
        }
        this.renderer.selectAllPayments(notNullPayments, select);
    }

    static {
        int rows = GuiConfigManager.getIntegerProperty((GuiConfigSet)LoginManager.getEventContext().getTerminal().getScreenLayoutSet(), (GuiConfigManager.CompStrings)GuiConfigManager.CompStrings.DEBTOR_TRANSACTIONS, (GuiConfigManager.PropStrings)GuiConfigManager.PropStrings.ROWS);
        ROWS_PER_PAGE = rows < 1 ? 8 : rows;
    }
}

