/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.gui.screens.debtor.DebtorPaymentRenderer;

public class DebtorHistoryRenderer
implements Renderer {
    private List<DebtorSale> selectedSales = new ArrayList<DebtorSale>();
    private List<DebtorPayment> selectedPayments = new ArrayList<DebtorPayment>();
    public final Signal refresh = Signals.createSignal();
    private static final int SALE = 0;
    private static final int TRANSACTION = 1;
    private static final int TOTAL = 2;

    public Component createComponent() {
        return null;
    }

    public void refresh() {
        this.selectedSales = new ArrayList<DebtorSale>();
        this.selectedPayments = new ArrayList<DebtorPayment>();
    }

    public Component createComponent(int index) {
        int col = index % 3;
        switch (col) {
            case 0: {
                return this.createToggleButton();
            }
            case 1: {
                return this.createToggleButton();
            }
            case 2: {
                JLabel outstandingLabel = new JLabel();
                outstandingLabel.setAlignmentX(0.5f);
                return outstandingLabel;
            }
        }
        throw new RuntimeException("Someone changed the laws of mathematics on me. Col was " + col);
    }

    private CustomButton createToggleButton() {
        CustomButton tb = new CustomButton();
        tb.setAction((Action)new ButtonAction());
        return tb;
    }

    public void setupComponent(Component component, Object object, int index) {
        component.setVisible(true);
        if (object instanceof DebtorSale) {
            Displayable data = (Displayable)object;
            ((CustomButton)component).setData(data);
            if (this.selectedSales.contains(data)) {
                OrderMateTheme.setupToggledButton((AbstractButton)((CustomButton)component));
            } else {
                OrderMateTheme.setupUntoggledButton((AbstractButton)((CustomButton)component));
            }
        } else if (object instanceof DebtorPayment) {
            DebtorPayment data = (DebtorPayment)object;
            ((CustomButton)component).setData((Displayable)new DebtorPaymentRenderer(data));
            if (this.selectedPayments.contains(data)) {
                OrderMateTheme.setupToggledButton((AbstractButton)((CustomButton)component));
            } else {
                OrderMateTheme.setupUntoggledButton((AbstractButton)((CustomButton)component));
            }
        } else if (object instanceof Price) {
            ((JLabel)component).setText(object.toString());
        } else if (object == null) {
            component.setVisible(false);
            if (component instanceof JLabel) {
                ((JLabel)component).setText(null);
            } else if (component instanceof CustomButton) {
                ((CustomButton)component).setData(null);
            }
        } else {
            throw new IllegalStateException("Unknown object " + object.getClass().toString());
        }
    }

    public List<DebtorSale> getSelectedSales() {
        return this.selectedSales;
    }

    public List<DebtorPayment> getSelectedPayments() {
        return this.selectedPayments;
    }

    public void selectAllPayments(List<DebtorPayment> transactionObjects, boolean select) {
        this.selectedPayments.clear();
        if (select) {
            this.selectedPayments.addAll(transactionObjects);
            this.selectedSales.clear();
        }
        this.refresh.emit();
    }

    public void selectAllSales(List<DebtorSale> salesObjects, boolean select) {
        ArrayList<DebtorSale> safeList = new ArrayList<DebtorSale>(salesObjects);
        this.selectedSales.clear();
        if (safeList.contains(null)) {
            WaiterMate.LOG.warn("Selected debtors sales should not contain null");
            safeList.remove(null);
        }
        if (select) {
            this.selectedSales.addAll(salesObjects);
            this.selectedPayments.clear();
        }
        this.refresh.emit();
    }

    private class ButtonAction
    extends AbstractAction {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomButton source = (CustomButton)e.getSource();
            Displayable data = source.getData();
            if (data instanceof DebtorSale) {
                if (DebtorHistoryRenderer.this.selectedSales.contains(data)) {
                    DebtorHistoryRenderer.this.selectedSales.remove(data);
                    OrderMateTheme.setupUntoggledButton((AbstractButton)source);
                } else {
                    DebtorHistoryRenderer.this.selectedSales.add((DebtorSale)data);
                    OrderMateTheme.setupToggledButton((AbstractButton)source);
                    if (!DebtorHistoryRenderer.this.selectedPayments.isEmpty()) {
                        DebtorHistoryRenderer.this.selectedPayments.clear();
                        DebtorHistoryRenderer.this.refresh.emit();
                    }
                }
            } else if (data instanceof DebtorPayment) {
                DebtorPayment payment = (DebtorPayment)data;
                if (DebtorHistoryRenderer.this.selectedPayments.contains(payment)) {
                    DebtorHistoryRenderer.this.selectedPayments.remove(payment);
                    OrderMateTheme.setupUntoggledButton((AbstractButton)source);
                } else {
                    DebtorHistoryRenderer.this.selectedPayments.add(payment);
                    OrderMateTheme.setupToggledButton((AbstractButton)source);
                    if (!DebtorHistoryRenderer.this.selectedSales.isEmpty()) {
                        DebtorHistoryRenderer.this.selectedSales.clear();
                        DebtorHistoryRenderer.this.refresh.emit();
                    }
                }
            }
        }
    }
}

