/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtortransactions;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.debtor.components.PaymentStatusDrawPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DrawerToggleButton;

public class DebtorTransactionNav
extends NavBar {
    public Signal paySignal = Signals.createSignal();
    public Signal selectNoneSignal = Signals.createSignal();
    public Signal selectAllSignal = Signals.createSignal();
    public Signal viewDetailsSignal = Signals.createSignal();
    public Signal transferSignal = Signals.createSignal();
    public Signal printStmtSignal = Signals.createSignal();
    public Signal refundSignal = Signals.createSignal();
    public Signal printActStmtSignal = Signals.createSignal();
    public Signal printOutstandingItemsSignal = Signals.createSignal();
    public Signal viewReservationDetailSignal = Signals.createSignal();
    private StandardSecurityDecorator payButton;
    private JButton selectNoneButton;
    private JButton selectAllButton;
    private StandardSecurityDecorator viewDetailsButton;
    private StandardSecurityDecorator transferButton;
    private StandardSecurityDecorator printStmtButton;
    private StandardSecurityDecorator refundButton;
    private StandardSecurityDecorator printActStmtButton;
    private StandardSecurityDecorator printOutstandingItemsButton;
    private StandardSecurityDecorator viewReservationDetailButton;
    private DrawerToggleButton statusFilterButton;
    public final Signal paymentStatusFilter = Signals.createSignal();

    public DebtorTransactionNav() {
        this.payButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/pay.png"), "Pay", "Pay", this.paySignal), AllPermissions.DEBTOR_PAY);
        this.selectNoneButton = this.constructButton(IconLoader.get((String)"/waitermate/images/selectNone.png"), "<HTML><CENTER>Select<BR>None</CENTER></HTML>", "selectNone", this.selectNoneSignal);
        this.selectAllButton = this.constructButton(IconLoader.get((String)"/waitermate/images/selectAll.png"), "<HTML><CENTER>Select<BR>All</CENTER></HTML>", "selectAll", this.selectAllSignal);
        this.viewDetailsButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), "<HTML><CENTER>View Order<BR>Details</CENTER></HTML>", "viewDetails", this.viewDetailsSignal), AllPermissions.DEBTOR_ORDER_DETAILS);
        this.viewReservationDetailButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), "<HTML><CENTER>View Reservation<BR>Details</CENTER></HTML>", "viewReservationDetails", this.viewReservationDetailSignal), AllPermissions.DEBTOR_ORDER_DETAILS);
        this.transferButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/transfer.png"), "Transfer", "transfer", this.transferSignal), AllPermissions.DEBTOR_TRANSFER);
        this.printStmtButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/printOrder.png"), "<HTML><CENTER>Print<BR>Stmt</CENTER></HTML>", "printStatement", this.printStmtSignal), AllPermissions.DEBTOR_STATEMENT);
        this.printActStmtButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/printOrder.png"), "<HTML><CENTER>Print<BR>Act Stmt</CENTER></HTML>", "printActivityStatement", this.printActStmtSignal), AllPermissions.DEBTOR_STATEMENT);
        this.refundButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/money_down.png"), "Refund", "refund", this.refundSignal), AllPermissions.DEBTOR_REFUND);
        this.printOutstandingItemsButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/printOrder.png"), "<HTML><CENTER>Print<BR>Outstanding Items</CENTER></HTML>", "printOutstandingItemsButton", this.printOutstandingItemsSignal), AllPermissions.DEBTOR_STATEMENT);
        this.getClearButton().setText("<HTML><CENTER>Reset<BR>Filter</CENTER></HTML>");
        this.clear.connect((Object)this, "gotClearFilters");
        PaymentStatusDrawPanel panel = new PaymentStatusDrawPanel();
        this.statusFilterButton = this.constructDrawerToggleButton("Status");
        panel.changed.connect((Object)this, "gotStatusChanged");
        this.statusFilterButton.setDrawer((JComponent)((Object)panel));
        this.addRight((Component)this.refundButton);
        this.addRight((Component)this.printOutstandingItemsButton);
        this.addRight((Component)this.printActStmtButton);
        this.addRight((Component)this.printStmtButton);
        this.addRight((Component)this.transferButton);
        this.addRight((Component)this.viewDetailsButton);
        if (SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.PIGGY)) {
            this.addRight((Component)this.viewReservationDetailButton);
        }
        this.addRight(this.selectAllButton);
        this.addRight(this.selectNoneButton);
        this.addRight((Component)this.payButton);
        this.addLeft(this.getBackButton());
        this.addLeft((Component)this.statusFilterButton);
        this.addLeft(this.getClearButton());
    }

    public void enablePayButton(boolean isEnabled) {
        this.payButton.setEnabled(isEnabled);
    }

    public void setupPayButton(User theUser) {
        boolean canPay = Terminal.getLocalHost().getPayableCashDrawers(theUser).size() > 0;
        this.payButton.setVisible(canPay);
        this.refundButton.setVisible(canPay);
    }

    public void reset() {
        String status = ((PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer())).getSelectedPaymentStatus();
        if (!PaymentStatusDrawPanel.DEFAULT.toString().equals(status)) {
            ((PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer())).reset();
            this.getClearButton().setVisible(false);
            this.paymentStatusFilter.emit();
        }
    }

    public String getSelectedPaymentStatus() {
        PaymentStatusDrawPanel panel = (PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer());
        return panel.getSelectedPaymentStatus();
    }

    public void gotStatusChanged() {
        this.paymentStatusFilter.emit();
        this.getClearButton().setVisible(!this.getSelectedPaymentStatus().equalsIgnoreCase("DEFAULT"));
        this.statusFilterButton.closeDrawer();
    }

    public void gotClearFilters() {
        this.reset();
    }
}

