/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtorunallocatedpayments;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.debtor.debtorunallocatedpayments.DebtorPaymentUnallocatedButtonRenderer;

public class DebtorUnallocatedPaymentsRenderer
implements Renderer {
    private List<DebtorPayment> selectedPayments = new ArrayList<DebtorPayment>();
    public final Signal refresh = Signals.createSignal();

    public Component createComponent() {
        return this.createToggleButton();
    }

    private CustomButton createToggleButton() {
        CustomButton tb = new CustomButton();
        tb.setAction((Action)new ButtonAction());
        return tb;
    }

    public void setupComponent(Component component, Object object, int index) {
        component.setVisible(true);
        if (object != null) {
            DebtorPayment data = (DebtorPayment)object;
            ((CustomButton)component).setData((Displayable)new DebtorPaymentUnallocatedButtonRenderer(data));
            if (this.selectedPayments.contains(data)) {
                OrderMateTheme.setupToggledButton((AbstractButton)((CustomButton)component));
            } else {
                OrderMateTheme.setupUntoggledButton((AbstractButton)((CustomButton)component));
            }
        } else {
            component.setVisible(false);
            if (component instanceof JLabel) {
                ((JLabel)component).setText(null);
            } else if (component instanceof CustomButton) {
                ((CustomButton)component).setData(null);
            }
        }
    }

    public void refresh() {
        this.selectedPayments = new ArrayList<DebtorPayment>();
    }

    public void selectAllPayments(List<DebtorPayment> transactionObjects, boolean select) {
        this.selectedPayments.clear();
        if (select) {
            this.selectedPayments.addAll(transactionObjects);
        }
        this.refresh.emit();
    }

    public void clearSelectedTransactions() {
        this.selectedPayments.clear();
    }

    public List<DebtorPayment> getSelectedPayments() {
        return this.selectedPayments;
    }

    private class ButtonAction
    extends AbstractAction {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomButton source = (CustomButton)e.getSource();
            Displayable data = source.getData();
            if (data != null) {
                DebtorPayment tran = (DebtorPayment)data;
                if (DebtorUnallocatedPaymentsRenderer.this.selectedPayments.contains(tran)) {
                    DebtorUnallocatedPaymentsRenderer.this.selectedPayments.remove(tran);
                    OrderMateTheme.setupUntoggledButton((AbstractButton)source);
                } else {
                    DebtorUnallocatedPaymentsRenderer.this.selectedPayments.add(tran);
                    OrderMateTheme.setupToggledButton((AbstractButton)source);
                }
            }
        }
    }
}

