/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.debtorunallocatedpayments;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.gui.SaveAccount;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.debtor.debtorunallocatedpayments.DebtorUnallocatedPaymentsNav;
import waitermate.gui.screens.debtor.debtorunallocatedpayments.DebtorUnallocatedPaymentsRenderer;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.showitem.ShowItemsUtils;

public class DebtorUnallocatedPaymentsScreen
extends AbstractScreen {
    private AbstractDebtor debtor = null;
    private Signal debtorScreenCancelled;
    private Signal<List<DebtorPayment>, AbstractDebtor, ?, ?, ?> debtorScreenPay;
    private final JPanel gui = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(4, 11), 0, 0));
    private final DebtorUnallocatedPaymentsNav nav = new DebtorUnallocatedPaymentsNav();
    private CustomScrollPane scrollPane;
    private final RendererScrollPaneModel<DebtorPayment> model;
    private final DebtorUnallocatedPaymentsRenderer renderer = new DebtorUnallocatedPaymentsRenderer();

    public DebtorUnallocatedPaymentsScreen() {
        this.model = new RendererScrollPaneModel((Renderer)this.renderer);
        this.scrollPane = new CustomScrollPane(this.model);
        this.gui.add((Component)this.scrollPane, new Rectangle(0, 1, 4, 10));
        this.nav.viewDetailsSignal.connect((Object)this, "gotViewDetails");
        this.nav.selectNoneSignal.connect((Object)this, "gotSelectNone");
        this.nav.paySignal.connect((Object)this, "gotPay");
        this.nav.back.connect((Object)this, "gotBack");
    }

    public void start(AbstractDebtor newDebtor, Signal cancelled, Signal<List<DebtorPayment>, AbstractDebtor, ?, ?, ?> paymentSelected, DebtorTransactionManager manager) {
        this.renderer.clearSelectedTransactions();
        this.debtor = newDebtor;
        this.reaquireDebtor();
        Date from = new Date();
        from.setTime(0L);
        this.debtorScreenCancelled = cancelled;
        this.debtorScreenPay = paymentSelected;
        this.model.setObjects(this.getTransactions(manager));
        this.display();
    }

    private List<DebtorPayment> getTransactions(DebtorTransactionManager manager) {
        ArrayList<DebtorPayment> availablePayments = new ArrayList<DebtorPayment>();
        List payments = this.debtor.getUnsettledPayments();
        for (DebtorPayment deptPay : payments) {
            if (!this.canSnaffleTransaction(deptPay, manager)) continue;
            availablePayments.add(deptPay);
        }
        return availablePayments;
    }

    private boolean canSnaffleTransaction(DebtorPayment deptPay, DebtorTransactionManager manager) {
        return !deptPay.isRefunded() && "ACTIVE".equals(deptPay.getFinanceTransaction().getSystemState()) && deptPay.getFinanceTransaction().getPaid().greaterThan((Object)Price.ZERO_DOLLAR) && !deptPay.hasDebtorSale() && !manager.isTransferring(deptPay, deptPay.getDebtor());
    }

    public void setDebtor(AbstractDebtor newDebtor) {
        newDebtor.relock(LoginManager.getInstance().getUser());
        this.debtor = newDebtor;
        this.display();
    }

    protected AbstractDebtor getDebtor() {
        return this.debtor;
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotViewDetails() {
        List<DebtorPayment> selectedPayments = this.renderer.getSelectedPayments();
        if (selectedPayments.size() > 0) {
            new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showDebtorFinanceTransactions(this.getDebtor(), selectedPayments);
        }
    }

    public void gotPay() {
        List<DebtorPayment> selectedPayments = this.renderer.getSelectedPayments();
        if (!selectedPayments.isEmpty()) {
            selectedPayments = this.checkForSurcharge(selectedPayments);
            this.debtorScreenPay.emit(selectedPayments, (Object)this.debtor);
        } else {
            Dialogs.displayOkDialog((String)"At least one unassigned payment must be selected", (String)"No payment selected");
        }
    }

    public void gotSelectNone() {
        this.renderer.selectAllPayments(new ArrayList<DebtorPayment>(), false);
        this.model.clearSelection();
    }

    public void gotBack() {
        this.reaquireDebtor();
        this.debtor.unlock();
        this.display();
        this.debtorScreenCancelled.emit();
    }

    private void reaquireDebtor() {
        AbstractDebtor localDebtor = (AbstractDebtor)PersistenceManager.reacquire((PersistentObjectI)this.debtor);
        PersistenceManager.preloadFKListReferences((PersistentObject)localDebtor, (Class[])new Class[0]);
        this.setDebtor(localDebtor);
    }

    private List<DebtorPayment> checkForSurcharge(List<DebtorPayment> payments) {
        ArrayList<DebtorPayment> surchargeList = new ArrayList<DebtorPayment>(0);
        for (DebtorPayment payment : payments) {
            if (payment.getFinanceTransaction().getSurcharge().isZero()) continue;
            DebtorPayment surcharge = this.getSurcharge(payment.getFinanceTransaction().getSurcharge());
            if (surcharge != null) {
                surchargeList.add(surcharge);
                continue;
            }
            OrderMate.LOG.warn("Debtor Payment with Surcharge and No Surcharge matching found");
        }
        if (!surchargeList.isEmpty()) {
            payments.addAll(surchargeList);
        }
        return payments;
    }

    private DebtorPayment getSurcharge(Price surcharge) {
        DebtorPayment surchargePayment = null;
        List paymentList = this.debtor.getUnsettledPayments();
        for (DebtorPayment surchargeCheck : paymentList) {
            if (!(surchargeCheck.getFinanceTransaction() instanceof DebtorAdjustmentTransaction) || !surchargeCheck.getAmount().equals((Object)surcharge.negate())) continue;
            surchargePayment = surchargeCheck;
        }
        return surchargePayment;
    }
}

