/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

class LoginButton
extends JButton
implements TimingTarget {
    static final ImageIcon unlocked = IconLoader.get((String)"/waitermate/images/login_unlocked.png", (double)1.0, (Color)Color.green, (float)0.5f);
    static final ImageIcon locked = IconLoader.get((String)"/waitermate/images/login_locked.png", (double)1.0, (Color)Color.red, (float)0.5f);
    private static final int INSET = 2;
    private static final int ICON_PAD = 15;
    private static final Stroke STROKE = new BasicStroke(1.8f);
    private static final float ONLINE_ORDER_MULTIPLIER = 2.4f;
    private static final float REGULAR_MULTIPLIER = 1.4f;
    private static final int SWING_DURATION = 150;
    private boolean onlineOrderFlag = false;
    private float expansion = 0.0f;
    private Animator anim = new Animator(150, 8.0, Animator.RepeatBehavior.REVERSE, (TimingTarget)this);
    private volatile double iconRotation = 0.0;
    private volatile double rotationMultiplier = 1.0;

    LoginButton() {
        super(locked);
        this.anim.setAcceleration(0.5f);
        this.anim.setDeceleration(0.5f);
    }

    void setExpansion(float value) {
        this.expansion = value;
        this.setIcon(value == 0.0f ? locked : unlocked);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        int size = Math.min(this.getWidth() - 4, this.getHeight() - 4);
        int halfSize = size / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D rec = null;
        if (!StringUtils.isEmpty((String)this.getText())) {
            FontMetrics metrics = g2.getFontMetrics();
            if (this.getText().length() <= 6) {
                g2.setFont(g2.getFont().deriveFont(1, 20.0f));
                rec = metrics.getStringBounds(this.getText(), g2);
                g2.drawString(this.getText(), 15 + (int)((double)this.getWidth() - rec.getWidth()) / 2, (this.getHeight() + metrics.getAscent() - metrics.getDescent()) / 2);
            } else {
                g2.setFont(g2.getFont().deriveFont(1, 16.0f));
                int index = this.getText().indexOf("\r\n");
                String first = this.getText().substring(0, index);
                rec = metrics.getStringBounds(first, g2);
                g2.drawString(first, 15 + (int)((double)this.getWidth() - rec.getWidth()) / 2, (this.getHeight() - metrics.getDescent()) / 2);
                String second = this.getText().substring(index + 1, this.getText().length());
                rec = metrics.getStringBounds(second, g2);
                g2.drawString(second, 15 + (int)((double)this.getWidth() - rec.getWidth()) / 2, this.getHeight() / 2 + metrics.getAscent());
            }
        }
        g2.setColor(this.getForeground());
        g2.setStroke(STROKE);
        int halfWidth = this.getWidth() / 2;
        int inner = (int)(this.expansion * (float)(halfWidth - halfSize));
        g2.setClip(halfWidth - halfSize - inner, 0, halfSize, this.getHeight());
        g2.drawOval(halfWidth - halfSize - inner, 2, size, size);
        g2.setClip(halfWidth + inner, 0, size, this.getHeight());
        g2.drawOval(halfWidth + inner - halfSize, 2, size - 2, size);
        g2.setClip(0, 0, this.getWidth(), this.getHeight());
        g2.drawLine(halfWidth - inner, 2, halfWidth + inner, 2);
        g2.drawLine(halfWidth - inner, size + 2, halfWidth + inner, size + 2);
        float expMultiplier = this.onlineOrderFlag ? 2.4f : 1.4f;
        int xTopRight = (int)((float)((this.getWidth() - this.getIcon().getIconWidth()) / 2) - (float)this.getIcon().getIconWidth() * expMultiplier * this.expansion);
        int yTopRight = (this.getHeight() - this.getIcon().getIconHeight()) / 2;
        g2.rotate(this.iconRotation, 10 + xTopRight + (int)(this.expansion * 15.0f) / 2, yTopRight);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Image resizedImage = ((ImageIcon)this.getIcon()).getImage().getScaledInstance((int)((double)this.getIcon().getIconWidth() / 1.5), (int)((double)this.getIcon().getIconHeight() / 1.5), 4);
        new ImageIcon(resizedImage).paintIcon(this, g2, xTopRight + this.getIcon().getIconWidth() / 5, yTopRight + this.getIcon().getIconHeight() / 5);
    }

    float getExpansion() {
        return this.expansion;
    }

    public void startLockAnimation() {
        try {
            this.anim.start();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void initiateOnlineOrderMode(String text, Color foreground) {
        this.setText(text);
        this.onlineOrderFlag = true;
        this.setExpansion(1.0f);
        this.setForeground(foreground);
    }

    public void haltOnlineOrderMode(Color foreground) {
        this.setText("");
        this.onlineOrderFlag = false;
        this.setExpansion(0.0f);
        this.setForeground(foreground);
    }

    public boolean canAnimate() {
        return !this.onlineOrderFlag;
    }

    public void begin() {
    }

    public void end() {
        this.rotationMultiplier = 1.0;
        this.iconRotation = 0.0;
    }

    public void repeat() {
        this.rotationMultiplier *= 0.5;
    }

    public void timingEvent(float fraction) {
        this.iconRotation = this.rotationMultiplier * ((double)fraction - 0.5);
        this.repaint();
    }
}

