/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import ordermate.gui.ButtonStyler;

public class LoginButtonStyler
implements ButtonStyler {
    public static final Color NOPE = new Color(1, 1, 1);
    private static final Stroke STROKE = new BasicStroke(1.9f);
    private Font font = new Font("SansSerif", 0, 20);

    public void styleButton(AbstractButton button) {
        LoginButtonUI ui = new LoginButtonUI();
        ((ComponentUI)ui).installUI(button);
        button.setUI(ui);
        button.setForeground(new Color(220, 220, 220));
        button.setBackground(NOPE);
        button.setBorderPainted(false);
        button.setBorder(null);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.setFont(this.font);
        button.setRolloverEnabled(true);
    }

    class LoginButtonUI
    extends BasicButtonUI {
        private static final int PAD = 2;
        private static final int PAD_O = 3;
        private static final int INSET = 6;

        LoginButtonUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent component) {
            AbstractButton button = (AbstractButton)component;
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setFont(component.getFont());
            int size = Math.min(button.getWidth() - 12, button.getHeight() - 12);
            int xLoc = (button.getWidth() - size) / 2;
            int yLoc = (button.getHeight() - size) / 2;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (button.getBackground() != null && !NOPE.equals(button.getBackground())) {
                g2.setColor(button.getBackground());
                g2.fillOval(xLoc + 2, yLoc + 2, size - 3, size - 3);
            }
            if (button.getIcon() != null) {
                if (button.isSelected() && button.getSelectedIcon() != null) {
                    button.getSelectedIcon().paintIcon(button, g2, (button.getWidth() - button.getSelectedIcon().getIconWidth()) / 2, (button.getHeight() - button.getSelectedIcon().getIconHeight()) / 2);
                } else {
                    button.getIcon().paintIcon(button, g2, (button.getWidth() - button.getIcon().getIconWidth()) / 2, (button.getHeight() - button.getIcon().getIconHeight()) / 2);
                }
            }
            if (button.getText() != null && component.getForeground() != null && !NOPE.equals(component.getForeground())) {
                g2.setColor(component.getForeground());
                g2.setStroke(STROKE);
                g2.drawOval(xLoc, yLoc, size, size);
            }
            if (!StringUtils.isEmpty((String)button.getText())) {
                FontMetrics metrics = g2.getFontMetrics();
                Rectangle2D rec = metrics.getStringBounds(button.getText(), g2);
                g2.drawString(button.getText(), 1 + (int)((double)button.getWidth() - rec.getWidth()) / 2, (button.getHeight() + metrics.getAscent() - metrics.getDescent()) / 2);
            }
        }
    }
}

