/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.login.NetworkStatus;

public class NetworkStatusPanel
extends JPanel {
    private static final String OFFLINE_STRING = "Your internet is currently OFFLINE.\nThe OrderMate System will still run as normal.\nHowever, OrderMate will not be able\nto remotely access your system in\nthe event of an emergency.\n\nTo rectify this problem please check your modem.\nContact your ISP for further troubleshooting steps.";
    private static final String UNKNOWN_HOST = "There is a problem acquiring the Server.\n\nPlease contact OrderMate.";
    private static final String ALL_CLEAR = "Your connection appears to be fine.";
    private TextScrollPaneModel helperArea;
    private JLabel hostAddressLabel;
    private JLabel thisAddressLabel;
    private JLabel wanConnectedLabel;
    private JLabel externalLabel;
    private NetworkStatus networkStatus;

    public NetworkStatusPanel() {
        super(new BorderLayout());
        this.setupComponents();
        this.setSize(640, 480);
        this.networkStatus = NetworkStatus.getInstance();
        this.networkStatus.networkStatusChanged.connect((Object)this, "statusChanged");
    }

    private void setupComponents() {
        JPanel topPanel = new JPanel(new GridLayout(5, 2, 5, 5));
        JLabel tempLabel = new JLabel("This Address:");
        tempLabel.setFont(OrderMateTheme.getMediumFont());
        topPanel.add(tempLabel);
        this.thisAddressLabel = new JLabel("-");
        topPanel.add(this.thisAddressLabel);
        this.thisAddressLabel.setFont(OrderMateTheme.getMediumFont());
        tempLabel = new JLabel("ServerMate Address:");
        tempLabel.setFont(OrderMateTheme.getMediumFont());
        topPanel.add(tempLabel);
        this.hostAddressLabel = new JLabel("-");
        topPanel.add(this.hostAddressLabel);
        this.hostAddressLabel.setFont(OrderMateTheme.getMediumFont());
        tempLabel = new JLabel("Internet Connected?");
        tempLabel.setFont(OrderMateTheme.getMediumFont());
        topPanel.add(tempLabel);
        this.wanConnectedLabel = new JLabel("-");
        topPanel.add(this.wanConnectedLabel);
        this.wanConnectedLabel.setFont(OrderMateTheme.getMediumFont());
        tempLabel = new JLabel("External IP");
        tempLabel.setFont(OrderMateTheme.getMediumFont());
        topPanel.add(tempLabel);
        this.externalLabel = new JLabel("-");
        topPanel.add(this.externalLabel);
        this.externalLabel.setFont(OrderMateTheme.getMediumFont());
        this.add((Component)topPanel, "North");
        this.helperArea = new TextScrollPaneModel(10);
        CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)this.helperArea);
        scrolly.setPreferredSize(new Dimension(400, 200));
        this.helperArea.setFont(OrderMateTheme.getMediumFont());
        this.add((Component)scrolly, "Center");
    }

    public void statusChanged() {
        if (this.networkStatus.isUpdating()) {
            this.hostAddressLabel.setText("-");
            this.thisAddressLabel.setText("-");
            this.wanConnectedLabel.setText("-");
            this.externalLabel.setText("-");
        } else {
            this.hostAddressLabel.setText(this.networkStatus.getHostAddress());
            this.thisAddressLabel.setText(this.networkStatus.getThisAddress());
            if (this.networkStatus.isWanConnected()) {
                this.wanConnectedLabel.setText("Connected");
            } else {
                this.wanConnectedLabel.setText("Not Connected");
            }
        }
        this.adjustVisualHelpers();
    }

    public void setExternalIP(final String ip) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkStatusPanel.this.externalLabel.setText(ip);
                }
            });
        } else {
            this.externalLabel.setText(ip);
        }
    }

    private void adjustVisualHelpers() {
        Runnable guiUpdate = new Runnable(){

            @Override
            public void run() {
                NetworkStatusPanel.this.helperArea.clear();
                if (NetworkStatusPanel.this.networkStatus.isUpdating()) {
                    NetworkStatusPanel.this.setLabelColours(Color.GRAY);
                    NetworkStatusPanel.this.helperArea.addLine("Reacquiring network status, please wait...");
                } else if (NetworkStatusPanel.this.networkStatus.isWanConnected()) {
                    if (!NetworkStatusPanel.this.networkStatus.isHostResolved()) {
                        NetworkStatusPanel.this.setLabelColours(Color.ORANGE);
                        NetworkStatusPanel.this.helperArea.addLine(NetworkStatusPanel.UNKNOWN_HOST);
                    } else {
                        NetworkStatusPanel.this.helperArea.addLine(NetworkStatusPanel.ALL_CLEAR);
                        NetworkStatusPanel.this.setLabelColours(Color.BLUE);
                    }
                } else {
                    NetworkStatusPanel.this.wanConnectedLabel.setForeground(Color.ORANGE);
                    NetworkStatusPanel.this.externalLabel.setForeground(Color.ORANGE);
                    NetworkStatusPanel.this.helperArea.addLine(NetworkStatusPanel.OFFLINE_STRING);
                }
            }
        };
        SwingUtilities.invokeLater(guiUpdate);
    }

    private void setLabelColours(Color value) {
        this.hostAddressLabel.setForeground(value);
        this.thisAddressLabel.setForeground(value);
        this.wanConnectedLabel.setForeground(value);
        this.externalLabel.setForeground(value);
    }
}

