/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class OnlineOrderNotifier
extends JLabel
implements ActionListener {
    private static final int PAD = 2;
    private static final int PAD_O = 3;
    private static final int INSET = 2;
    private static final float DEFAULT_ACCELERATION = 0.5f;
    private static final int BELL_WIDTH = 32;
    private static final int BELL_HEIGHT = 35;
    private static final int JINGLE_DURATION = 150;
    private static final int JINGLE_WAIT = 3000;
    private static final int JINGLE_REPEATS = 6;
    private int numOrders;
    private volatile double iconSizeMultiplier = 1.0;
    private volatile double iconRotation = 0.0;
    private volatile double clapperMultiplier = 0.0;
    private ImageIcon clapper = IconLoader.get((String)"/waitermate/images/bell_clapper.png");
    private Animator jingleAnim;
    private Animator growAnim;
    private Timer timer = new Timer(3000, this);
    private BellResetTimer resetTarget = new BellResetTimer();
    private BellJingleTimer jingleTarget = new BellJingleTimer();
    private BellGrowTimer growTarget = new BellGrowTimer();

    OnlineOrderNotifier() {
        super(IconLoader.get((String)"/waitermate/images/bell.png"));
        this.resetAnimator();
    }

    private void resetAnimator() {
        if (this.growAnim != null) {
            this.growAnim.stop();
        }
        this.growAnim = new Animator(900, (TimingTarget)this.growTarget);
        this.growAnim.setAcceleration(0.5f);
        this.growAnim.setDeceleration(0.5f);
        this.growAnim.start();
        if (this.jingleAnim != null) {
            this.jingleAnim.stop();
        }
        this.jingleAnim = new Animator(150, 6.0, Animator.RepeatBehavior.REVERSE, (TimingTarget)this.jingleTarget);
        this.jingleAnim.setAcceleration(0.5f);
        this.jingleAnim.setDeceleration(0.5f);
        this.jingleAnim.start();
    }

    public void setNumOrders(int value) {
        this.numOrders = value;
        this.setVisible(this.numOrders > 0);
    }

    public int getNumOrders() {
        return this.numOrders;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        int size = Math.min(this.getWidth() - 4, this.getHeight() - 4);
        int xLoc = (this.getWidth() - size) / 2;
        int yLoc = (this.getHeight() - size) / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(10, 162, 64));
        g2.fillOval(xLoc + 2, yLoc + 2, size - 3, size - 3);
        FontMetrics metrics = g2.getFontMetrics();
        g2.setColor(Color.RED);
        int diameter = metrics.stringWidth("9+") * 2;
        g2.fillOval(xLoc + size - diameter, 0, diameter, diameter);
        g2.setColor(Color.WHITE);
        String toPrint = this.numOrders > 9 ? "9+" : "" + this.numOrders;
        Rectangle2D rec = metrics.getStringBounds(toPrint, g2);
        g2.drawString(toPrint, (int)((double)(xLoc + size) - (rec.getWidth() + (double)diameter) / 2.0), (int)(rec.getHeight() + (double)diameter) / 2 - metrics.getDescent());
        int xTopRight = (this.getWidth() - this.getIcon().getIconWidth()) / 2;
        int yTopRight = (this.getHeight() - this.getIcon().getIconHeight()) / 2;
        g2.rotate(this.iconRotation / 1.5, xTopRight + this.getIcon().getIconWidth() / 2, yTopRight);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Image resizedImage = ((ImageIcon)this.getIcon()).getImage().getScaledInstance((int)(32.0 * this.iconSizeMultiplier), (int)(35.0 * this.iconSizeMultiplier), 4);
        Image clapperResized = this.clapper.getImage().getScaledInstance((int)(32.0 * this.iconSizeMultiplier), (int)(35.0 * this.iconSizeMultiplier), 4);
        new ImageIcon(resizedImage).paintIcon(this, g2, xTopRight + (this.getIcon().getIconWidth() - 32) / 2, yTopRight + (this.getIcon().getIconHeight() - 35) / 2);
        new ImageIcon(clapperResized).paintIcon(this, g2, (int)((double)(xTopRight + (this.getIcon().getIconWidth() - 32) / 2) + this.clapperMultiplier), yTopRight + (this.getIcon().getIconHeight() - 35) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.jingleAnim.stop();
        this.resetAnimator();
    }

    private class BellGrowTimer
    implements TimingTarget {
        private BellGrowTimer() {
        }

        public void timingEvent(float fraction) {
            double maxGrowth = 1.125;
            double mutliplier = ((double)fraction - 0.5) * ((double)fraction - 0.5);
            OnlineOrderNotifier.this.iconSizeMultiplier = -0.5 * mutliplier + maxGrowth;
            OnlineOrderNotifier.this.repaint();
        }

        public void end() {
            OnlineOrderNotifier.this.iconSizeMultiplier = 1.0;
        }

        public void begin() {
        }

        public void repeat() {
        }
    }

    private class BellResetTimer
    implements TimingTarget {
        private BellResetTimer() {
        }

        public void timingEvent(float fraction) {
            if (OnlineOrderNotifier.this.iconRotation > 0.0) {
                OnlineOrderNotifier.this.clapperMultiplier = (fraction - 1.0f) / 2.0f * 15.0f;
                OnlineOrderNotifier.this.iconRotation = 0.5 - (double)(fraction / 2.0f);
            } else {
                OnlineOrderNotifier.this.clapperMultiplier = -(fraction - 1.0f) / 2.0f * 15.0f;
                OnlineOrderNotifier.this.iconRotation = -0.5 + (double)(fraction / 2.0f);
            }
            OnlineOrderNotifier.this.repaint();
        }

        public void end() {
            OnlineOrderNotifier.this.iconRotation = 0.0;
            OnlineOrderNotifier.this.timer.start();
        }

        public void begin() {
        }

        public void repeat() {
        }
    }

    private class BellJingleTimer
    implements TimingTarget {
        private BellJingleTimer() {
        }

        public void timingEvent(float fraction) {
            OnlineOrderNotifier.this.iconRotation = (double)fraction - 0.5;
            OnlineOrderNotifier.this.clapperMultiplier = -((double)fraction - 0.5) * 15.0;
            OnlineOrderNotifier.this.repaint();
        }

        public void end() {
            OnlineOrderNotifier.this.jingleAnim = new Animator(150, (TimingTarget)OnlineOrderNotifier.this.resetTarget);
            OnlineOrderNotifier.this.jingleAnim.setAcceleration(0.5f);
            OnlineOrderNotifier.this.jingleAnim.setDeceleration(0.5f);
            OnlineOrderNotifier.this.jingleAnim.start();
        }

        public void begin() {
        }

        public void repeat() {
        }
    }
}

