/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.login;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.connectivity.DesktopHelper;
import au.com.ordermate.util.image.FragmentedGif;
import au.com.ordermate.util.image.GifLoader;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.AnimatedResponsiveIcon;
import ordermate.gui.ButtonStyler;
import ordermate.gui.MultiLineLabel;
import ordermate.gui.StaticResponsiveIcon;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import waitermate.WaiterMate;
import waitermate.gui.notify.WhatsNew;
import waitermate.gui.screens.login.FlashAndDingListener;
import waitermate.gui.screens.login.LoginAdvertisingManager;
import waitermate.gui.screens.login.LoginButton;
import waitermate.gui.screens.login.LoginButtonStyler;
import waitermate.gui.screens.login.LoginPanelUI;
import waitermate.gui.screens.login.NetworkStatus;
import waitermate.gui.screens.login.OnlineOrderNotifier;
import waitermate.gui.screens.login.PasswordLabel;
import waitermate.guikit.animator.PathMapper;
import waitermate.guikit.animator.QuadraticPathMapper;
import waitermate.guikit.animator.SimpleSizeBoundsAnimator;

public class WaitermateLoginPanel
extends JPanel
implements ActionListener {
    private static final String EULA_URL = "https://www.ordermate.com.au/eula";
    private static final String ONLINE_ORDER_SOUND = "/waitermate/sounds/onlineOrderPending.wav";
    private static final String PLEASE_CLICK_TEXT = "Please click here to browse our ";
    private static final String KNOWLEDGEBASE_A_TAG = "<a href='http://help.ordermate.com.au/hc/en-us'>Knowledge Base</a>";
    private static final int FLASH_DELAY = 250;
    private static final int SHINE_DELAY = 86700;
    private static final int SHINE_TIME = 900;
    private static final int ANIMATION_TIME = 150;
    private static final int CLOSE_SUPPORT_TIME = 30000;
    private static final String PANEL_FONT = "/utils/fonts/OpenSans-Regular.ttf";
    private static final int ROWS = 102;
    private static final int COLS = 102;
    private static final int BUT_WIDE = 10;
    private static final int BUT_HIGH = 10;
    private final String EULA_A_TAG = "<a href='https://www.ordermate.com.au/eula'>" + Internationalization.getLiteralFor((String)"ORDERMATE_EULA") + "</a>";
    private final DateFormat timeFormatter = DateFormat.getTimeInstance(3);
    private final DateFormat dateFormatter = new SimpleDateFormat("d MMM yy");
    private final String WAITERMATE_VERSION = Internationalization.getLiteralFor((String)"WAITERMATE_VERSION") + " " + OrderMate.VERSION;
    private final Rectangle LOGO_REC = new Rectangle(4, 33, 50, 33);
    private final Rectangle PIN_REC = new Rectangle(71, 28, 28, 50);
    private final Rectangle PIN_LABEL_REC = new Rectangle(71, 20, 28, 5);
    private final Rectangle LOGIN_REC = new Rectangle(71, 84, 28, 8);
    private final Rectangle ONLINE_REC = new Rectangle(62, 86, 10, 10);
    private final Rectangle MOTD_BUT_REC = new Rectangle(0, 91, 10, 10);
    private final Rectangle MOTD_REC = new Rectangle(11, 89, 52, 13);
    private final Rectangle SUPPORT_BUT_REC = new Rectangle(94, 1, 10, 10);
    private final Rectangle SUPPORT_REC = new Rectangle(1, 1, 93, 16);
    private final Rectangle ADVERT_REC = new Rectangle(1, 1, 40, 26);
    private final Rectangle TIME_DATE_REC = new Rectangle(80, 3, 14, 10);
    final Signal<String, ?, ?, ?, ?> pinLogin = Signals.createSignal(String.class, (String)"pin");
    private boolean hasPinLogin;
    private ButtonStyler styler;
    private Keypad loginKeypad;
    private JButton netConfigButton;
    private JButton whatsNewButton;
    private LoginButton loginButton;
    private JToggleButton motdButton;
    private JToggleButton supportButton;
    private volatile JPanel motdHolder;
    private volatile JPanel supportPanel;
    private JPanel timeDatePanel;
    private JPanel versionPanel;
    private OnlineOrderNotifier onlineOrderNotifier;
    private JLabel timeLabel;
    private JLabel dateLabel;
    private MultiLineLabel motdLabel;
    private Shape flashClip;
    private Image overImage;
    private Image gradientImage;
    private volatile float gradientStage = 0.0f;
    private ImageIcon logo;
    private volatile JLabel logoHolder;
    private Timer paintSwingTimer;
    private Timer closeSupportPanelTimer;
    private Timer gradientTimer;
    private Timer onlineOrderPendingTimer;
    private Animator loginAnimator;
    private FlashAndDingListener onlineOrderListener;
    private final Color SECOND_COLOR = ComponentColors.DARK_GRADIENT_START;
    private final Color HIGHLIGHT_COLOR;
    private final Color GREENISH = new Color(10, 162, 64);
    private int[] polyX;
    private int[] polyY;
    private boolean isDarkScreen = false;
    private boolean animating = true;
    private Font keypadFont;
    private Font motdFont;
    private Font supportFont;
    private Font timeFont;
    private Font dateFont;
    private LoginAdvertisingManager adMan;
    private JComponent adPanel;
    private final GifLoader gifLoader;

    public WaitermateLoginPanel(boolean doPinLogin, GifLoader gifLoader) {
        Color backgroundColor;
        this.gifLoader = gifLoader;
        this.animating = Terminal.getLocalHost().isLoginAnimating();
        this.setLayout((LayoutManager)new GraphPaperLayout(102, 102));
        this.hasPinLogin = doPinLogin;
        this.adMan = new LoginAdvertisingManager();
        this.isDarkScreen = Terminal.getLocalHost().isDarkLogo();
        if (this.isDarkScreen) {
            backgroundColor = Color.BLACK;
            this.HIGHLIGHT_COLOR = new Color(51, 51, 51);
        } else {
            backgroundColor = OrderMateTheme.ORDERMATE_RED;
            this.HIGHLIGHT_COLOR = new Color(172, 10, 15);
        }
        try {
            this.keypadFont = Font.createFont(0, this.getClass().getResourceAsStream(PANEL_FONT));
            this.keypadFont = this.keypadFont.deriveFont(25.0f);
            this.motdFont = this.keypadFont.deriveFont(20.0f);
            this.supportFont = this.keypadFont.deriveFont(13.0f);
            this.timeFont = this.keypadFont.deriveFont(1, 16.0f);
            this.dateFont = this.keypadFont.deriveFont(1, 12.0f);
        }
        catch (Exception e) {
            WaiterMate.LOG.error("Couldn't get the font we needed for the login screen!", (Throwable)e);
            this.keypadFont = OrderMateTheme.getLargeFont();
            this.motdFont = OrderMateTheme.getMediumFont();
            this.supportFont = OrderMateTheme.getSmallFont();
            this.dateFont = OrderMateTheme.getMediumFont();
            this.timeFont = OrderMateTheme.getMediumFont();
        }
        this.setBackground(backgroundColor);
        this.styler = new LoginButtonStyler();
        this.makeLogo();
        if (this.hasPinLogin) {
            this.makeKeypadPanel();
        }
        this.makeMessageOfTheDay();
        this.makeSupportPanel();
        this.makeOnlineOrderLabel();
        this.makeGradient();
        this.makeAdvertising();
        this.makeTimeDateLabel();
    }

    private void makeLogo() {
        if (!this.animating) {
            this.logo = this.isDarkScreen ? IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png") : IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png");
            this.logoHolder = new StaticResponsiveIcon(this.logo, 4);
        } else {
            FragmentedGif fragGif = this.isDarkScreen ? this.gifLoader.loadGif("/waitermate/images/om_logo_2024_black_fade.gif") : this.gifLoader.loadGif("/waitermate/images/om_logo_2024_red_fade.gif");
            this.logo = fragGif.getImageIcon();
            this.logoHolder = new AnimatedResponsiveIcon(fragGif, 4);
        }
        this.add((Component)this.logoHolder, this.LOGO_REC);
    }

    private void versionPanel() {
        this.versionPanel = new JPanel();
        this.versionPanel.setOpaque(false);
        this.versionPanel.setLayout(new BoxLayout(this.versionPanel, 1));
        JLabel versionLabel = new JLabel(this.WAITERMATE_VERSION);
        versionLabel.setForeground(Color.WHITE);
        this.versionPanel.add(versionLabel);
        this.versionPanel.setFont(this.supportFont);
        this.versionPanel.setForeground(Color.WHITE);
        this.versionPanel.add(Box.createVerticalGlue());
    }

    private void makeTimeDateLabel() {
        this.timeDatePanel = new JPanel();
        this.timeDatePanel.setOpaque(false);
        this.timeDatePanel.setLayout(new BoxLayout(this.timeDatePanel, 1));
        this.timeLabel = new JLabel(this.timeFormatter.format(new Date()));
        this.timeLabel.setFont(this.timeFont);
        this.timeLabel.setForeground(Color.WHITE);
        this.timeLabel.setAlignmentX(1.0f);
        this.timeDatePanel.add(this.timeLabel);
        this.dateLabel = new JLabel(this.dateFormatter.format(new Date()));
        this.dateLabel.setFont(this.dateFont);
        this.dateLabel.setForeground(Color.WHITE);
        this.dateLabel.setAlignmentX(1.0f);
        this.timeDatePanel.add(this.dateLabel);
        this.timeDatePanel.setAlignmentX(1.0f);
        this.paintSwingTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitermateLoginPanel.this.timeLabel.setText(WaitermateLoginPanel.this.timeFormatter.format(new Date()));
                WaitermateLoginPanel.this.dateLabel.setText(WaitermateLoginPanel.this.dateFormatter.format(new Date()));
            }
        });
        this.paintSwingTimer.setInitialDelay(0);
        this.add((Component)this.timeDatePanel, this.TIME_DATE_REC);
    }

    private void makeGradient() {
        this.gradientTimer = new Timer(86700, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaitermateLoginPanel.this.animating) {
                    WaitermateLoginPanel.this.runGradient();
                }
            }
        });
        this.gradientTimer.setInitialDelay(10000);
        this.gradientTimer.start();
    }

    private void makeAdvertising() {
        this.adMan = new LoginAdvertisingManager();
        this.adPanel = this.adMan.getAdvertPanel();
        this.add((Component)this.adPanel, this.ADVERT_REC);
    }

    private void makeKeypadPanel() {
        Keypad.KeypadBuilder builder = new Keypad.KeypadBuilder();
        builder.setStyler(this.styler).setPadName("loginKeypad");
        PasswordLabel pLabel = new PasswordLabel();
        pLabel.setForeground(new Color(220, 220, 220));
        builder.setOutputLabel((JLabel)pLabel);
        this.loginKeypad = builder.build();
        this.loginKeypad.setOpaque(false);
        this.loginKeypad.setDecimalButtonVisible(false);
        ImageIcon backIcon = IconLoader.get((String)"/waitermate/images/back-arrow.png");
        backIcon.setImage(backIcon.getImage().getScaledInstance(20, 20, 4));
        this.loginKeypad.setBackIcon(backIcon);
        this.loginKeypad.setMaximumValue(12);
        this.loginKeypad.setButtonFont(this.keypadFont);
        this.loginButton = new LoginButton();
        this.loginButton.setName("loginBut");
        this.styler.styleButton((AbstractButton)this.loginButton);
        this.loginButton.setText("");
        this.loginButton.setForeground(Color.RED);
        this.loginButton.addActionListener(this);
        this.loginButton.setPreferredSize(new Dimension(190, 190));
        this.add((Component)pLabel, this.PIN_LABEL_REC);
        this.add((Component)this.loginKeypad, this.PIN_REC);
        this.add((Component)this.loginButton, this.LOGIN_REC);
        this.loginKeypad.updated.connect((Object)this, "gotPinUpdated");
    }

    private void makeMessageOfTheDay() {
        this.motdHolder = new JPanel();
        this.motdHolder.setOpaque(false);
        this.motdHolder.setLayout(new BorderLayout());
        this.motdHolder.setVisible(false);
        this.motdButton = new JToggleButton(IconLoader.get((String)"/waitermate/images/paper-plane.png"));
        this.motdButton.setSelectedIcon(IconLoader.get((String)"/waitermate/images/close.png"));
        this.motdButton.addActionListener(this);
        this.setupIconButton(this.motdButton);
        this.styler.styleButton((AbstractButton)this.motdButton);
        this.motdButton.setBackground(this.HIGHLIGHT_COLOR);
        this.motdButton.setForeground(LoginButtonStyler.NOPE);
        this.motdLabel = new MultiLineLabel();
        this.motdLabel.setText("This is the message of the day");
        this.motdLabel.setLeftIndex(10);
        this.motdLabel.setBorder(null);
        this.motdLabel.setForeground(Color.WHITE);
        this.motdLabel.setFont(this.motdFont);
        this.motdLabel.setVerticalTextPosition(1);
        this.motdHolder.add((Component)this.motdLabel);
        this.motdHolder.setBackground(this.SECOND_COLOR.brighter());
        this.motdHolder.setUI(new LoginPanelUI());
        this.add((Component)this.motdButton, this.MOTD_BUT_REC);
        this.add((Component)this.motdHolder, this.MOTD_REC);
    }

    private void makeSupportPanel() {
        int PAD = 15;
        this.supportPanel = new JPanel();
        this.supportPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.supportPanel.setOpaque(false);
        this.supportPanel.setBackground(this.SECOND_COLOR.brighter());
        this.supportPanel.setLayout(new GridLayout(1, 3));
        this.versionPanel();
        this.netConfigButton = new JButton("Network", IconLoader.get((String)"/waitermate/images/cloud.png"));
        this.netConfigButton.setForeground(Color.WHITE);
        this.setupIconButton(this.netConfigButton);
        this.netConfigButton.addActionListener(this);
        this.netConfigButton.setVerticalTextPosition(3);
        this.netConfigButton.setHorizontalTextPosition(0);
        this.whatsNewButton = new JButton("What's New", IconLoader.get((String)"/ordermate/images/info.png"));
        this.whatsNewButton.setForeground(Color.WHITE);
        this.setupIconButton(this.whatsNewButton);
        this.whatsNewButton.addActionListener(this);
        this.whatsNewButton.setVerticalTextPosition(3);
        this.whatsNewButton.setHorizontalTextPosition(0);
        NetworkStatus.getInstance().networkStatusChanged.connect((Object)this, "gotNetworkStatusChanged");
        String supportText = SystemProperty.getInstance().getSupportMessage1() + HtmlUtils.newline((int)1) + SystemProperty.getInstance().getSupportMessage2() + HtmlUtils.newline((int)1) + PLEASE_CLICK_TEXT + KNOWLEDGEBASE_A_TAG;
        this.supportPanel.setVisible(false);
        JEditorPane support = new JEditorPane();
        support.setContentType("text/html");
        support.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        support.setEditable(false);
        support.setOpaque(false);
        support.setText(supportText);
        support.setFont(this.supportFont);
        support.setForeground(Color.WHITE);
        support.setAlignmentX(2.0f);
        support.setBorder(BorderFactory.createEmptyBorder());
        support.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String link = hle.getDescription();
                    DesktopHelper.getInstance().browseUrl(link);
                }
            }
        });
        String text = support.getText();
        text = text.replaceAll("<a href", "<a style=\"color:#56f3ff\" href");
        support.setText(text);
        String eulaText = Internationalization.getLiteralFor((String)"ACCEPT_TERMS") + " " + this.EULA_A_TAG;
        JEditorPane eulaPanel = new JEditorPane();
        eulaPanel.setContentType("text/html");
        eulaPanel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        eulaPanel.setEditable(false);
        eulaPanel.setOpaque(false);
        eulaPanel.setText(eulaText);
        eulaPanel.setFont(this.supportFont);
        eulaPanel.setForeground(Color.WHITE);
        eulaPanel.setAlignmentX(2.0f);
        eulaPanel.setBorder(BorderFactory.createEmptyBorder());
        eulaPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    String link = hle.getDescription();
                    DesktopHelper.getInstance().browseUrl(link);
                }
            }
        });
        text = eulaPanel.getText();
        text = text.replaceAll("<a href", "<a style=\"color:#56f3ff\" href");
        eulaPanel.setText(text);
        JPanel buttonAndTimePanel = new JPanel(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        buttonsPanel.setOpaque(false);
        buttonsPanel.add(this.netConfigButton);
        if (new WhatsNew().hasWhatsNew()) {
            buttonsPanel.add(this.whatsNewButton);
        }
        buttonAndTimePanel.setOpaque(false);
        buttonAndTimePanel.add((Component)buttonsPanel, "North");
        buttonAndTimePanel.add((Component)this.versionPanel, "Center");
        this.supportPanel.add(buttonAndTimePanel);
        this.supportPanel.add((Component)support, "Center");
        this.supportPanel.add((Component)eulaPanel, "East");
        this.supportPanel.setUI(new LoginPanelUI());
        this.add((Component)this.supportPanel, this.SUPPORT_REC);
        this.supportButton = new JToggleButton(IconLoader.get((String)"/waitermate/images/info.png"));
        this.setupIconButton(this.supportButton);
        this.supportButton.addActionListener(this);
        this.supportButton.setSelectedIcon(IconLoader.get((String)"/waitermate/images/close.png"));
        this.styler.styleButton((AbstractButton)this.supportButton);
        this.supportButton.setForeground(LoginButtonStyler.NOPE);
        this.closeSupportPanelTimer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitermateLoginPanel.this.supportButton.setSelected(false);
                new LoginPanelAnimator(WaitermateLoginPanel.this.supportPanel, WaitermateLoginPanel.this.SUPPORT_REC).start(true);
            }
        });
        this.closeSupportPanelTimer.setRepeats(false);
        this.closeSupportPanelTimer.setInitialDelay(30000);
        this.add((Component)this.supportButton, this.SUPPORT_BUT_REC);
    }

    private void setupIconButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
    }

    private void makeOnlineOrderLabel() {
        this.onlineOrderNotifier = new OnlineOrderNotifier();
        this.onlineOrderNotifier.setName("onlineOrderNotification");
        this.onlineOrderNotifier.setBackground(this.GREENISH);
        this.add((Component)this.onlineOrderNotifier, this.ONLINE_REC);
    }

    public final void gotPinUpdated(String value) {
        if (!this.loginButton.canAnimate()) {
            return;
        }
        if (value == null || value.isEmpty()) {
            if ((this.loginAnimator != null && !this.loginAnimator.isRunning() || this.loginAnimator == null) && this.loginButton.getExpansion() != 0.0f) {
                this.loginAnimator = new Animator(150, new TimingTarget(){

                    public void begin() {
                        WaitermateLoginPanel.this.loginButton.setText(null);
                        WaitermateLoginPanel.this.loginButton.startLockAnimation();
                    }

                    public void end() {
                        WaitermateLoginPanel.this.loginButton.setExpansion(0.0f);
                        WaitermateLoginPanel.this.loginButton.setForeground(Color.RED);
                    }

                    public void repeat() {
                    }

                    public void timingEvent(float arg0) {
                        WaitermateLoginPanel.this.loginButton.setExpansion(1.0f - arg0);
                        WaitermateLoginPanel.this.loginButton.repaint();
                    }
                });
                this.loginAnimator.setAcceleration(0.5f);
                this.loginAnimator.setDeceleration(0.5f);
                this.loginAnimator.start();
            }
        } else if (this.loginButton.getExpansion() == 0.0f) {
            this.loginAnimator = new Animator(150, new TimingTarget(){

                public void begin() {
                    WaitermateLoginPanel.this.loginButton.setExpansion(0.0f);
                    WaitermateLoginPanel.this.loginButton.startLockAnimation();
                }

                public void end() {
                    WaitermateLoginPanel.this.loginButton.setExpansion(1.0f);
                    if (WaitermateLoginPanel.this.onlineOrderNotifier.getNumOrders() > 0) {
                        WaitermateLoginPanel.this.loginButton.setText("Login for\r\nOnline Orders");
                    } else {
                        WaitermateLoginPanel.this.loginButton.setText("Login");
                    }
                }

                public void repeat() {
                }

                public void timingEvent(float arg0) {
                    WaitermateLoginPanel.this.loginButton.setExpansion(arg0);
                    WaitermateLoginPanel.this.loginButton.repaint();
                }
            });
            this.loginButton.setForeground(this.GREENISH);
            this.loginAnimator.setAcceleration(0.5f);
            this.loginAnimator.setDeceleration(0.5f);
            this.loginAnimator.start();
        }
    }

    private void gotPin() {
        String pin = this.loginKeypad.getValueAsString();
        this.loginKeypad.setValue("");
        this.pinLogin.emit((Object)pin);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resample;
        boolean bl = resample = this.getWidth() != width || this.getHeight() != height;
        if (resample) {
            int overWidth = (int)((double)width / 2.1);
            this.polyX = new int[]{(int)((double)overWidth * 0.4), overWidth, overWidth, 0};
            this.polyY = new int[]{0, 0, height, height};
            Polygon gradedArea = new Polygon(this.polyX, this.polyY, 4);
            BufferedImage BI = new BufferedImage(overWidth, height, 2);
            Graphics2D g2 = (Graphics2D)BI.getGraphics();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.SECOND_COLOR, 0.0f, height, ComponentColors.DARK_GRADIENT_END);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(gradient);
            g2.fill(gradedArea);
            this.overImage = BI;
            this.flashClip = new Polygon(new int[]{0, width - (overWidth - this.polyX[0]), width - overWidth, 0}, new int[]{0, 0, height, height}, 4);
            BI = new BufferedImage(width, height, 2);
            g2 = (Graphics2D)BI.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double theta = Math.atan((double)BI.getWidth() * 0.5 / (double)height);
            double centre = Math.cos(theta) * (double)BI.getWidth() / 4.0;
            double xpoint = centre * Math.cos(theta);
            double ypoint = centre * Math.sin(theta);
            Point a = new Point(BI.getWidth() / 2, 0);
            Point b = new Point(a.x + (int)xpoint, a.y + (int)ypoint);
            LinearGradientPaint flash = new LinearGradientPaint(a, b, new float[]{0.1f, 0.9f}, new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 70)}, MultipleGradientPaint.CycleMethod.REFLECT);
            g2.setPaint(new Color(255, 255, 255, 0));
            g2.fillRect(0, 0, BI.getWidth(), BI.getHeight());
            g2.setPaint(flash);
            g2.fillPolygon(new Polygon(new int[]{0, BI.getWidth() / 2, BI.getWidth(), BI.getWidth() / 2}, new int[]{BI.getHeight(), BI.getHeight(), 0, 0}, 4));
            this.gradientImage = BI;
            this.adMan.flipBanner();
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.drawImage(this.overImage, this.getWidth() - this.overImage.getWidth(null), 0, null);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.gradientStage > 0.0f && this.animating) {
            g.setClip(this.flashClip);
            g.drawImage(this.gradientImage, (int)((double)(this.gradientStage * (float)this.getWidth()) * 1.5 - (double)this.getWidth()), 0, null);
        }
    }

    public void gotNetworkStatusChanged() {
        NetworkStatus status = NetworkStatus.getInstance();
        if (!status.isUpdating()) {
            ImageIcon newIcon = !status.isWanConnected() ? IconLoader.get((String)"/waitermate/images/badcloud.png") : IconLoader.get((String)"/waitermate/images/cloud.png");
            this.netConfigButton.setIcon(newIcon);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.netConfigButton) {
            NetworkStatus.getInstance().showDialog();
        } else if (source == this.whatsNewButton) {
            WhatsNew whatsNew = new WhatsNew();
            whatsNew.showWhatsNew();
        } else if (source == this.motdButton) {
            new LoginPanelAnimator(this.motdHolder, this.MOTD_REC).start(!this.motdButton.isSelected());
        } else if (source == this.supportButton) {
            new LoginPanelAnimator(this.supportPanel, this.SUPPORT_REC).start(!this.supportButton.isSelected());
            if (this.supportButton.isSelected()) {
                this.closeSupportPanelTimer.start();
            } else {
                this.closeSupportPanelTimer.stop();
            }
        } else if (source == this.loginButton) {
            this.gotPin();
        }
    }

    public void startPaintTimer() {
        this.paintSwingTimer.start();
        this.gradientTimer.start();
        this.adMan.start();
    }

    public void stopPaintTimer() {
        this.paintSwingTimer.stop();
        this.gradientTimer.stop();
        if (this.onlineOrderPendingTimer != null) {
            this.onlineOrderPendingTimer.stop();
        }
        this.adMan.stop();
    }

    public void updateMessageOfTheDay() {
        if (SystemProperty.getInstance().getMessageOfTheDay() != null && SystemProperty.getInstance().getMessageOfTheDay().trim().length() > 0) {
            this.motdLabel.setText(SystemProperty.getInstance().getMessageOfTheDay());
            this.motdButton.setVisible(true);
        } else {
            this.motdButton.setVisible(false);
            this.motdLabel.setText("");
        }
    }

    void startOnlineOrderPending(Long numNewOrders) {
        if (numNewOrders == null) {
            return;
        }
        if (this.onlineOrderPendingTimer == null) {
            String sound = null;
            if (OnlineIntegrationConfig.getDefaultInstance().isPlaySound()) {
                sound = ONLINE_ORDER_SOUND;
            }
            this.onlineOrderListener = new FlashAndDingListener(this.onlineOrderNotifier, sound, this.SECOND_COLOR, this.HIGHLIGHT_COLOR, 240);
            this.onlineOrderPendingTimer = new Timer(0, this.onlineOrderListener);
            this.onlineOrderPendingTimer.setDelay(250);
            this.onlineOrderPendingTimer.setCoalesce(true);
        }
        this.onlineOrderNotifier.setNumOrders(numNewOrders.intValue());
        this.onlineOrderNotifier.setVisible(true);
        this.onlineOrderPendingTimer.start();
        if (this.hasPinLogin) {
            this.loginButton.initiateOnlineOrderMode("Login for\r\nOnline Orders", this.GREENISH);
        }
    }

    void stopOnlineOrderPending() {
        if (this.onlineOrderPendingTimer != null) {
            this.onlineOrderPendingTimer.stop();
            this.onlineOrderPendingTimer = null;
            this.onlineOrderListener.clear();
        }
        this.onlineOrderNotifier.setNumOrders(0);
        this.onlineOrderNotifier.setVisible(false);
        if (this.hasPinLogin) {
            this.loginButton.haltOnlineOrderMode(Color.RED);
        }
    }

    public void clearPin() {
        if (this.loginKeypad != null) {
            this.loginKeypad.setValue("");
            this.gotPinUpdated(null);
        }
    }

    private void runGradient() {
        this.gradientStage = 0.0f;
        Animator animator = new Animator(900, new TimingTarget(){

            public void begin() {
            }

            public void end() {
                WaitermateLoginPanel.this.gradientStage = 0.0f;
            }

            public void repeat() {
            }

            public void timingEvent(float fraction) {
                WaitermateLoginPanel.this.gradientStage = fraction;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WaitermateLoginPanel.this.repaint();
                    }
                });
            }
        });
        animator.setAcceleration(0.5f);
        animator.setDeceleration(0.5f);
        animator.start();
    }

    class LoginPanelAnimator {
        private JComponent toAnimate;
        private Rectangle refBounds;

        public LoginPanelAnimator(JComponent animateThis, Rectangle reference) {
            this.toAnimate = animateThis;
            this.refBounds = reference;
        }

        public void start(boolean openIt) {
            SimpleSizeBoundsAnimator bounds;
            int height = this.ratio(this.refBounds.height, 102, WaitermateLoginPanel.this.getHeight());
            Rectangle closed = new Rectangle(this.toAnimate.getX(), this.toAnimate.getY(), 0, height);
            Rectangle open = new Rectangle(this.toAnimate.getX(), this.toAnimate.getY(), this.ratio(this.refBounds.width, 102, WaitermateLoginPanel.this.getWidth()), height);
            if (openIt) {
                bounds = new SimpleSizeBoundsAnimator((Component)this.toAnimate, open, closed);
                this.toAnimate.setBounds(open);
                this.toAnimate.setVisible(false);
            } else {
                bounds = new SimpleSizeBoundsAnimator((Component)this.toAnimate, closed, open);
                this.toAnimate.setBounds(closed);
                this.toAnimate.setVisible(true);
            }
            bounds.setPathMapperWidth((PathMapper)QuadraticPathMapper.getInstance((boolean)false));
            Animator animator = new Animator(150, (TimingTarget)bounds);
            animator.setAcceleration(0.1f);
            animator.setDeceleration(0.9f);
            animator.start();
        }

        private int ratio(int divisions, int total, int measure) {
            return (int)((double)divisions / (double)total * (double)measure);
        }
    }
}

