/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering;

import au.com.ordermate.gui.GuiHandler;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.coupon.CouponHandlerFactory;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.CustomerCard;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.TableAccount;
import ordermate.database.stock.StockUtilities;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.integration.reservations.ReservationNotifier;
import ordermate.internationalization.Internationalization;
import ordermate.misc.logging.ErrorTrackingManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.failover.WaitermateFailover;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.ChooseAccount;
import waitermate.gui.screens.ordering.accountadmin.AccountAdmin;
import waitermate.gui.screens.ordering.accountitems.AccountItems;
import waitermate.gui.screens.ordering.accountitems.AccountItemsNav;
import waitermate.gui.screens.ordering.additems.AddItems;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateCouponHandlerFactory;
import waitermate.gui.screens.ordering.modifyitem.ModifyItem;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.Payments;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public class Ordering {
    private Account currentAccount = null;
    private ChooseAccount chooseAccount;
    private AccountItems accountItemsState;
    private AddItems addItemState;
    private WaiterMateCouponHandlerFactory couponHandlerFactory;
    public Signal done = Signals.createSignal();
    public Signal logout = Signals.createSignal();
    public Signal doneOverride;
    private final Signal paymentDone = Signals.createSignal();
    private final Signal paymentBack = Signals.createSignal();
    private final Signal modifyDone = Signals.createSignal();
    private final Signal adminDone = Signals.createSignal();
    private final Signal adminBack = Signals.createSignal();
    private final Signal topupVoucherDone = Signals.createSignal();
    private final Signal<Account, InventoryItem, ?, ?, ?> itemFound = Signals.createSignal(Account.class, (String)"currentAccount", InventoryItem.class, (String)"foundItem");
    private boolean itemOrderedFromSearch = false;
    private static Ordering instance;

    public static Ordering getInstance() {
        if (instance == null) {
            instance = new Ordering();
        }
        return instance;
    }

    private Ordering() {
        this.accountItemsState = new AccountItems();
        this.addItemState = new AddItems(false);
        this.couponHandlerFactory = new WaiterMateCouponHandlerFactory(this.addItemState);
        this.topupVoucherDone.connect((Object)this.accountItemsState, "selectItems");
        this.accountItemsState.cancel.connect((Object)this, "gotDone");
        this.accountItemsState.ok.connect((Object)this, "gotDone");
        this.accountItemsState.groupSelected.connect((Object)this.addItemState, "startAddingItem");
        this.accountItemsState.newItemSelected.connect((Object)this.addItemState, "gotStartAddingItem");
        this.accountItemsState.newComboSelected.connect((Object)this.addItemState, "gotStartAddingCombo");
        this.accountItemsState.newItemUnitSelected.connect((Object)this.addItemState, "gotStartAddingItem");
        this.accountItemsState.existingItemChanged.connect((Object)this.addItemState, "doAutoCombos");
        this.accountItemsState.sellableSelected.connect((Object)this, "startModify");
        this.accountItemsState.connectToUpsell();
        this.itemFound.connect((Object)this, "gotItemFound");
        this.modifyDone.connect((Object)this.accountItemsState, "gotEditItemDone");
        this.addItemState.done.connect((Object)this, "gotAddItemDone");
        this.addItemState.orderingComplete.connect((Object)this, "gotAddItemComplete");
        this.accountItemsState.paySelected.connect((Object)this, "gotPayStart");
        this.paymentBack.connect((Object)this.accountItemsState, "selectItems");
        this.paymentDone.connect((Object)this, "gotPayDone");
        this.accountItemsState.adminSelected.connect((Object)this, "startAdmin");
        this.adminBack.connect((Object)this.accountItemsState, "selectItems");
        this.adminDone.connect((Object)this, "gotDone");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
        ((AccountItemsNav)this.accountItemsState.getNavBar()).printAllBills.connect((Object)this, "gotPrintAllBills");
    }

    public void startModify(Sellable orderItem, Account account) {
        if (orderItem instanceof SalesLineItemWrapper) {
            ModifyItem.getInstance().startModify((SalesLineItem)orderItem.getSellingObject(), account, this.modifyDone);
        }
    }

    public void startAccountOrdering(Account newAccount) {
        this.startMultiAccountOrdering(Collections.singletonList(newAccount), newAccount);
    }

    public void startMultiAccountOrdering(List<Account> accounts, Account startingAccount) {
        if (accounts == null || accounts.isEmpty()) {
            throw new IllegalArgumentException("Cannot start ordering with null account");
        }
        if (this.chooseAccount == null) {
            this.chooseAccount = new ChooseAccount();
            this.chooseAccount.accountSelected.connect((Object)this, "gotAccountSelected");
            this.accountItemsState.setExtraComponent(this.chooseAccount, "East");
        }
        this.chooseAccount.setAccounts(accounts, startingAccount);
        this.chooseAccount.setVisible(accounts.size() > 1);
        ((AccountItemsNav)this.accountItemsState.getNavBar()).enablePrintAllBills(accounts.size() > 1);
        Account toStartWith = startingAccount;
        if (toStartWith == null) {
            toStartWith = accounts.get(0);
        }
        if (WaitermateFailover.isActive() && !WaitermateFailover.getInstance().allowedAccountType(toStartWith.getAccountType())) {
            return;
        }
        this.currentAccount = toStartWith;
        CouponAdministratorRemote.getInstance().setHandlerFactory((CouponHandlerFactory)this.couponHandlerFactory);
        this.doOrderAccountItems();
    }

    public void gotPrintAllBills() {
        for (Account account : this.chooseAccount.getAccounts()) {
            if (account.equals((Object)this.currentAccount)) {
                if (!WaitermateSaveAccount.getInstance().addInfo(account)) continue;
                WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)account);
                continue;
            }
            if (!account.isLocked()) {
                WaitermateSaveAccount.getInstance().lockAccount((Lockable)account);
                if (WaitermateSaveAccount.getInstance().addInfo(account)) {
                    WaitermateSaveAccount.getInstance().printReceiptDockets((ItemGroup)account);
                }
                account.unlock();
                continue;
            }
            Dialogs.displayOkDialog((String)(account.toString() + " " + Internationalization.getLiteralFor((String)"IS_LOCKED_AND_CANNOT_BE_PRINTED")), (String)Internationalization.getLiteralFor((String)"PRINT_JOB_CANCELLED"));
        }
    }

    private void doOrderAccountItems() {
        StockUtilities.clearPermittedOversellItems();
        if (WaitermateSaveAccount.getInstance().ensureValidCustomer(this.currentAccount)) {
            this.accountItemsState.startSelectItems(this.currentAccount);
        } else {
            this.currentAccount.unlock();
            ErrorTrackingManager.GET.captureEvent("Unlocking account from Ordering.doOrderAccountItems() - this is questionable behaviour if followed by an IllegalStateException from Account.save()!", this.currentAccount.toString() + "\r\n" + new Throwable().getStackTrace());
        }
    }

    public void startAdmin(Account account) {
        this.accountItemsState.setOldCustomer(account.getCustomer());
        AccountAdmin.getInstance().startAdmin(account, this.adminDone, this.adminBack, this.itemFound, this.topupVoucherDone);
    }

    void gotNewUser(User newUser) {
        if (this.currentAccount != null) {
            this.currentAccount.relock(newUser);
        }
        if (this.accountItemsState.isDisplaying()) {
            this.accountItemsState.refreshGroups();
        }
        this.addItemState.refreshItems();
    }

    void gotPayStart() {
        if (this.currentAccount == null) {
            throw new IllegalStateException("gotPayStart when currentAccount is null");
        }
        if (WaitermateSaveAccount.getInstance().addInfo(this.currentAccount)) {
            Payments.getInstance().startPayment(this.currentAccount, this.paymentBack, this.paymentDone, false);
        }
    }

    void gotPayDone() {
        if (this.currentAccount == null) {
            throw new IllegalStateException("gotPayDone() when current account is null");
        }
        if (StockUtilities.checkAccountOversell((Account)this.currentAccount) && this.currentAccount.isOpen()) {
            if (this.currentAccount.isOnHold()) {
                WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
                this.gotDone();
            } else if (!WaitermateSaveAccount.getInstance().shouldKeepOpen(this.currentAccount)) {
                if (this.currentAccount instanceof OnlineAccount && ((OnlineAccount)this.currentAccount).getLogicalTable() != null) {
                    WaitermateSaveAccount.getInstance().transferOnlineAccountToTable((OnlineAccount)this.currentAccount);
                }
                this.saveWithCloseAccount(true);
                this.gotDone();
            } else if (this.currentAccount instanceof TableAccount && Terminal.getLocalHost().isBistroMode()) {
                this.doOrderAccountItems();
            } else {
                this.saveWithCloseAccount(false);
                this.gotDone();
            }
        } else if (StockUtilities.checkAccountOversell((Account)this.currentAccount) && !this.currentAccount.isOpen()) {
            ExperimentalFeature feature = ExperimentalFeature.find((String)"Print Prep Docket after Closing Account");
            if (feature != null && feature.getBooleanValue(Boolean.valueOf(true)).booleanValue()) {
                OrderMate.LOG.warn("Print Prep Docket for " + this.currentAccount + " when Clicking Save Button again ");
                WaitermateSaveAccount.getInstance().printPrep(this.currentAccount);
            }
            this.gotDone();
        } else {
            this.gotDone();
        }
    }

    private void saveWithCloseAccount(boolean shouldClose) {
        if (shouldClose) {
            WaitermateSaveAccount.getInstance().closeAccount(this.currentAccount, true, true, LoginManager.getEventContext());
        }
        try {
            WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            OrderMate.LOG.warn("Print Prep Docket Faild for " + this.currentAccount + "  due to ", (Throwable)e);
        }
        finally {
            if (shouldClose) {
                WaitermateSaveAccount.getInstance().printClosingReceipts(this.currentAccount);
            }
            WaitermateSaveAccount.getInstance().printPrep(this.currentAccount);
        }
    }

    private void gotDone() {
        if (this.currentAccount != null) {
            TriggerActivationContext context = new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)this.currentAccount);
            CouponAdministratorRemote.getInstance().accountSaved(context);
            this.currentAccount.unlock();
        }
        if (this.doneOverride != null) {
            this.doneOverride.emit();
        } else if (Terminal.getLocalHost().getQuickLogout()) {
            this.logout.emit();
        } else {
            this.done.emit();
        }
        this.currentAccount = null;
    }

    private void gotItemFound(Account account, InventoryItem item) {
        this.itemOrderedFromSearch = true;
        this.accountItemsState.gotNewItem(account, item);
    }

    private void gotAddItemComplete() {
        this.itemOrderedFromSearch = false;
    }

    private void gotAddItemDone() {
        if (this.itemOrderedFromSearch) {
            this.itemOrderedFromSearch = false;
            AccountAdmin.getInstance().gotFindItem(Boolean.FALSE);
        } else {
            this.accountItemsState.selectItems();
            this.accountItemsState.showLastPage();
        }
    }

    public void gotAccountSelected(Account theAccount) {
        if (theAccount == null || theAccount.equals((Object)this.currentAccount)) {
            return;
        }
        if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)theAccount)) {
            if (this.currentAccount != null) {
                WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
                WaitermateSaveAccount.getInstance().printPrep(this.currentAccount);
                this.currentAccount.unlock();
            }
            this.currentAccount = theAccount;
            this.doOrderAccountItems();
        } else if (theAccount.getUser() != null) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"THAT_ACCOUNT_IS_CURRENTLY_IN_USE_BY") + " :" + theAccount.getUser().toString()), (String)Internationalization.getLiteralFor((String)"CANNOT_LOCK_ACCOUNT"));
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THAT_ACCOUNT_CANNOT_BE_LOCKED"), (String)Internationalization.getLiteralFor((String)"CANNOT_LOCK_ACCOUNT"));
        }
    }

    public void gotCustomerCard(CustomerCard card) {
        if (this.currentAccount == null) {
            return;
        }
        if (!AccountType.barTabType.equals((Object)this.currentAccount.getAccountType())) {
            return;
        }
        if (((BarTabAccount)this.currentAccount).getLogicalTable() == null) {
            return;
        }
        if (ScreenResource.isDialogShowing()) {
            return;
        }
        OrderMate.LOG.info("Customer card swiped:" + card);
        CustomerCardHelper helper = new CustomerCardHelper((GuiHandler)new WaitermateGuiHandler());
        BarTabAccount account = helper.createOrGetBarTab(card, LoginManager.getEventContext());
        if (this.currentAccount.equals((Object)account)) {
            return;
        }
        if (WaitermateSaveAccount.getInstance().lockAccount((Lockable)account)) {
            LogicalTable existingTable = account.getLogicalTable();
            if (existingTable != null && !((BarTabAccount)this.currentAccount).getLogicalTable().equals((Object)existingTable)) {
                account.delinkFromLogicalTable();
                ReservationNotifier.notifyForDelinkedAccount((LogicalTable)existingTable, (Account)account, (ReservationNotifier.DelinkReason)ReservationNotifier.DelinkReason.CLOSE);
            }
            account.linkToLogicalTable(((BarTabAccount)this.currentAccount).getLogicalTable());
            account.save();
            ReservationNotifier.notifyForLinkedAccount((LogicalTable)((BarTabAccount)this.currentAccount).getLogicalTable(), (Account)account);
            this.chooseAccount.addAccount((Account)account);
            this.chooseAccount.setVisible(this.chooseAccount.getNumAccounts() > 1);
            account.unlock();
            this.gotAccountSelected((Account)account);
        } else {
            this.chooseAccount.setSelectedAccount(this.currentAccount);
        }
    }

    public void setDoneOverride(Signal orderingDone) {
        this.doneOverride = orderingDone;
    }

    public void rebuild() {
        this.accountItemsState.rebuild();
    }
}

