/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockUtilities;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class WaiterMateStockUtilsGui
implements StockUtilities.StockUtilitiesGui {
    public boolean promptAllowOverSell(List oversoldItems) {
        StringBuffer dialogString = new StringBuffer("<html>" + Internationalization.getLiteralFor((String)"THERE_IS_NOT_ENOUGH") + " " + Internationalization.getLiteralFor((String)"") + ": <ul>");
        for (int j = 0; j < oversoldItems.size(); ++j) {
            InventoryItem item = (InventoryItem)oversoldItems.get(j);
            dialogString.append("<li> " + item.getLabel());
        }
        dialogString.append("</ul> <br>" + Internationalization.getLiteralFor((String)"ALLOW_ANYWAY_QUESTIONMARK") + "</html>");
        return Dialogs.displayChoiceDialog((String)dialogString.toString(), (String)Internationalization.getLiteralFor((String)"ALLOW_OVERSOLD_ITEMS_QUESTIONMARK"), (String)Internationalization.getLiteralFor((String)"YES"), (String)Internationalization.getLiteralFor((String)"NO"), (boolean)false);
    }

    public void warnCannotOverSell(List oversoldItems) {
        StringBuffer dialogString = new StringBuffer("<html>" + Internationalization.getLiteralFor((String)"THERE_IS_NOT_ENOUGH") + " " + Internationalization.getLiteralFor((String)"") + ": <ul>");
        for (int j = 0; j < oversoldItems.size(); ++j) {
            InventoryItem item = (InventoryItem)oversoldItems.get(j);
            dialogString.append("<li> " + item.getLabel());
        }
        dialogString.append("</ul></html>");
        Dialogs.displayOkDialog((String)dialogString.toString(), (String)Internationalization.getLiteralFor((String)"OVERSOLD_ITEMS"));
    }

    public boolean promptAllowOverSell(InventoryItemUnit unit) {
        return Dialogs.displayChoiceDialog((String)(Internationalization.getLiteralFor((String)"THERE_IS_NOT_ENOUGH") + " " + Internationalization.getLiteralFor((String)"REMAINING_STOCK_TO_SELL") + " " + unit + Internationalization.getLiteralFor((String)"COMMA_ALLOW_ANYWAY_QUESTIONMARK")), (String)Internationalization.getLiteralFor((String)"ALLOW_OVERSOLT_ITEM_QUESTIONMARK"), (String)Internationalization.getLiteralFor((String)"YES"), (String)Internationalization.getLiteralFor((String)"NO"), (boolean)false);
    }

    public boolean warnCannotOverSell(InventoryItemUnit unit, boolean resetAllowed) {
        if (resetAllowed) {
            JLabel msg = new JLabel(Internationalization.getLiteralFor((String)"THERE_IS_NOT_ENOUGH_REMAINING_STOCK_TO_SELL") + " " + unit + Internationalization.getLiteralFor((String)"COMMA_DO_YOU_WANT_TO_CLEAR_IT_QUESTIONMARK"));
            PopupWindow dialog = Dialogs.createDialog((JComponent)msg, (String)Internationalization.getLiteralFor((String)"RESET_STOCK_COUNT_DOWN"), (String)Internationalization.getLiteralFor((String)"RESET"), (String)"/waitermate/guikit/images/clear.png", (String)Internationalization.getLiteralFor((String)"CANCEL"), (String)"/waitermate/guikit/images/cancel.png", (boolean)true, (boolean)true, (boolean)true);
            return dialog.start();
        }
        Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"THERE_IS_NOT_ENOUGH") + " " + Internationalization.getLiteralFor((String)"REMAINING_STOCK_TO_SELL") + " " + unit + ". "), (String)Internationalization.getLiteralFor((String)"OVERSOLD_ITEM"));
        return false;
    }

    public String getLockIcon() {
        return "/waitermate/images/lock.png";
    }

    public String getNoStockIcon() {
        return "/waitermate/images/crossed_circle2.png";
    }
}

