/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountadmin.discountitems;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.HtmlUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.SalesPriceAdjustmentI;
import ordermate.database.sales.Sellable;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DeletableRenderer;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.ItemToggleRenderer;
import waitermate.gui.displayitems.accountitems.SalesItemDisplayFormat;
import waitermate.gui.displayitems.accountitems.SelectItemsPanel;

public class AdjustmentItemsPanel
extends JPanel {
    public final Signal selectionChanged = Signals.createSignal(Set.class, (String)"selectedItems");
    public final Signal removeAdjustment = Signals.createSignal(SalesPriceAdjustmentI.class, (String)"selectedAdjustement");
    private final RendererScrollPaneModel existingModel;
    private final SelectItemsPanel selectItemsPanel = new SelectItemsPanel();
    private final CustomScrollPane removePanel;

    public AdjustmentItemsPanel() {
        this(3);
    }

    public AdjustmentItemsPanel(int numColumns) {
        ItemToggleRenderer renderer = new ItemToggleRenderer(this.selectItemsPanel);
        DiscountedSalesItemDisplayFormat format = new DiscountedSalesItemDisplayFormat();
        renderer.setFormat(format);
        this.selectItemsPanel.setRenderer(renderer);
        this.selectItemsPanel.selectionChanged.connect((Object)this, "gotSelectionChanged");
        DeletableRenderer deletableRenderer = new DeletableRenderer();
        deletableRenderer.selected.connect((Object)this, "gotAdjustment");
        this.existingModel = new RendererScrollPaneModel((Renderer)deletableRenderer);
        this.removePanel = new CustomScrollPane((CustomScrollPaneModel)this.existingModel);
        this.removePanel.setColumns(1);
        this.removePanel.setRowsPerPage(4);
        this.removePanel.setBorder((Border)BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"PRESS_TO_REMOVE")));
        this.setLayout((LayoutManager)new GraphPaperLayout(4, 1));
        this.add((Component)this.selectItemsPanel, new Rectangle(1, 0, 3, 1));
        this.add((Component)this.removePanel, new Rectangle(0, 0, 1, 1));
    }

    public Set<Sellable> getSelectedItems() {
        return this.selectItemsPanel.getSelectedItems();
    }

    public void selectAll() {
        this.selectItemsPanel.selectAll();
    }

    public void selectNone() {
        this.selectItemsPanel.selectNone();
    }

    public void setRenderer(Renderer newRendered) {
        this.selectItemsPanel.setRenderer(newRendered);
    }

    public List<Sellable> getItems() {
        return this.selectItemsPanel.getItems();
    }

    public Renderer getRenderer() {
        return this.selectItemsPanel.getRenderer();
    }

    public void setColumns(int newNumColumns) {
        this.selectItemsPanel.setColumns(newNumColumns);
    }

    public void setItems(Collection<Sellable> newItems) {
        this.selectItemsPanel.setItems(newItems);
    }

    public void setAdjustements(Collection existingAdjustments) {
        this.existingModel.removeAllObjects();
        this.existingModel.addObjects(existingAdjustments);
    }

    void setCourse(int course) {
        this.selectItemsPanel.setCourse(course);
    }

    void gotSelectionChanged(Set<Sellable> items) {
        this.selectionChanged.emit(items);
    }

    void gotAdjustment(Displayable adjustement) {
        this.removeAdjustment.emit((Object)adjustement);
    }

    private static class DiscountedSalesItemDisplayFormat
    implements SalesItemDisplayFormat {
        private DiscountedSalesItemDisplayFormat() {
        }

        @Override
        public String getText(Sellable item) {
            StringBuilder retValue = new StringBuilder();
            boolean gotOne = false;
            if (item.isPriceAdjustable()) {
                for (SalesPriceAdjustment adj : item.getPriceAdjustments()) {
                    if (gotOne) {
                        retValue.append(", ");
                    }
                    retValue.append(adj.getLabel());
                    gotOne = true;
                }
            }
            return HtmlUtils.html((String)(item.getLabel() + HtmlUtils.newline((int)1) + HtmlUtils.boldColor((String)retValue.toString(), null)));
        }
    }
}

