/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountadmin.holditems;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.accountadmin.holditems.SelectHoldtime;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItems;

public class HoldItems {
    public final Signal done = Signals.createSignal();
    public final Signal cancel = Signals.createSignal();
    private SelectItems selectItems = new SelectItems();
    private SelectHoldtime selectHoldtime;
    private List<Sellable> items;

    public HoldItems() {
        this.selectItems.back.connect((Object)this.cancel, "emit");
        this.selectItems.items.connect((Object)this, "startEnterHoldTime");
        this.selectHoldtime = new SelectHoldtime();
        this.selectHoldtime.cancel.connect((Object)this.cancel, "emit");
        this.selectHoldtime.timeSelected.connect((Object)this, "gotHoldTime");
    }

    public void startHoldAccount(List<Sellable> itemsToHold) {
        this.items = null;
        this.selectItems.startSelection(itemsToHold);
    }

    void startEnterHoldTime(Set<Sellable> selectedItems) {
        this.items = new ArrayList<Sellable>(selectedItems);
        this.selectHoldtime.startSelectTime(this.items);
    }

    void gotHoldTime(Integer holdTime) {
        if (this.items != null) {
            for (Sellable sellableItem : this.items) {
                if (!(sellableItem instanceof SalesLineItemWrapper)) continue;
                SalesLineItem item = (SalesLineItem)sellableItem.getSellingObject();
                item.setHoldTime(holdTime.intValue());
            }
            this.done.emit();
        }
    }
}

