/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountitems;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.ItemGroup;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.accountitems.PriceLevelList;
import waitermate.gui.tablelayout.tablestate.TableStatePanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.components.DrawerToggleButton;

public class AccountItemsNav
extends NavBar
implements ActionListener {
    public final Signal pay = Signals.createSignal();
    public final Signal save = Signals.createSignal();
    public final Signal showItems = Signals.createSignal();
    public final Signal showPhoneMenu = Signals.createSignal();
    public final Signal showDeliveryMenu = Signals.createSignal();
    public final Signal useCheapestPriceLevels = Signals.createSignal();
    public final Signal usePriceLevel = Signals.createSignal(PriceLevel.class, (String)"toUse");
    public final Signal creditLimit = Signals.createSignal();
    public final Signal makeCombo = Signals.createSignal();
    public final Signal breakCombo = Signals.createSignal();
    public final Signal printOrder = Signals.createSignal();
    public final Signal holdAccount = Signals.createSignal();
    public final Signal orderInfoSignal = Signals.createSignal();
    public final Signal customerLocation = Signals.createSignal();
    public final Signal renameTab = Signals.createSignal();
    public final Signal assignBarTabToTable = Signals.createSignal();
    public final Signal printAllBills = Signals.createSignal();
    public final Signal seatAdminSignal = Signals.createSignal();
    public final Signal<LogicalTableState, ?, ?, ?, ?> tableStateChanged = Signals.createSignal(LogicalTableState.class, (String)"state");
    private StandardSecurityDecorator payButton;
    private JButton showOrderButton;
    private JButton makeComboButton;
    private JButton breakComboButton;
    private JButton printOrderButton;
    private JButton orderInfoButton;
    private JButton customerLocationButton;
    private JButton renameBarTabButton;
    private JButton assignBarTabToTableButton;
    private JToggleButton deliveryButton;
    private JToggleButton pickupButton;
    private ButtonGroup deliveryGroup;
    private DrawerToggleButton priceLevelButton;
    private DrawerToggleButton tableStateButton;
    private StandardSecurityDecorator tableStateSecurity;
    private StandardSecurityDecorator priceLevelSecurity;
    private StandardSecurityDecorator printButtonDecorator;
    private StandardSecurityDecorator printAllButtonDecorator;
    private StandardSecurityDecorator saveButtonDecorator;
    private StandardSecurityDecorator creditLimitDecorator;
    private StandardSecurityDecorator printOrderDecorator;
    private PriceLevelList priceLevelList;
    private TableStatePanel tableStatePanel;
    private String accountName = "";
    private Price accountPrice = new Price(0.0);
    private Price preauthAmount = null;
    private Price creditAmount = null;
    private int numPatrons = 0;
    private String customerName = "";
    private String customerPoints = "0";
    private String discountOrSurcharge = "";
    private String customerCategory = "";
    private boolean showLoyaltyPoints = false;
    private boolean shouldShowCategory = true;
    private StandardSecurityDecorator configDecorator;
    private StandardSecurityDecorator seatAdminDecorator;
    private boolean payButtonIsEnabled;
    private JToggleButton holdButton;

    public AccountItemsNav() {
        this.deliveryButton = this.constructToggleButton(IconLoader.get((String)"/waitermate/images/delivery.png"), Internationalization.getLiteralFor((String)"DELIVERY"));
        this.pickupButton = this.constructToggleButton(IconLoader.get((String)"/waitermate/images/phoneOrder.png"), Internationalization.getLiteralFor((String)"PICKUP"));
        this.holdButton = this.constructToggleButton(IconLoader.get((String)"/waitermate/images/clock.png"), Internationalization.getLiteralFor((String)"HOLD"));
        this.deliveryGroup = new ButtonGroup();
        this.deliveryGroup.add(this.deliveryButton);
        this.deliveryGroup.add(this.pickupButton);
        this.addLeft(this.pickupButton);
        this.addLeft(this.deliveryButton);
        this.customerLocationButton = this.constructButton(IconLoader.get((String)"/waitermate/images/customerLocation.png"), Internationalization.getLiteralFor((String)"LOCATION"), "customerLocation", this.customerLocation);
        this.addRight(this.customerLocationButton);
        if (Terminal.getLocalHost().isGeneralManualPrintPrep()) {
            this.printOrderButton = this.constructButton(IconLoader.get((String)"/waitermate/images/printOrder.png"), Internationalization.getLiteralFor((String)"PRINT_ORDER"), "PrintOrder");
            this.printOrderDecorator = new StandardSecurityDecorator((JComponent)this.printOrderButton, AllPermissions.SAVE);
            this.printOrderDecorator.setName(this.printOrderButton.getName());
            this.addRight((Component)this.printOrderDecorator);
        }
        this.showOrderButton = this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), Internationalization.getLiteralFor((String)"SHOW_ORDER"), "ShowOrder", new Insets(0, 8, 0, 8));
        this.addRight(this.showOrderButton);
        this.makeComboButton = this.constructButton(IconLoader.get((String)"/waitermate/images/comboMake.png"), Internationalization.getLiteralFor((String)"MAKE_COMBO"), "Make Combo", new Insets(0, 8, 0, 8));
        this.addRight(this.makeComboButton);
        this.makeComboButton.setVisible(Terminal.getLocalHost().isShowMakeComboInNav());
        this.breakComboButton = this.constructButton(IconLoader.get((String)"/waitermate/images/comboBreak.png"), Internationalization.getLiteralFor((String)"BREAK_COMBO"), "Break Combo", new Insets(0, 8, 0, 8));
        this.addRight(this.breakComboButton);
        this.breakComboButton.setVisible(Terminal.getLocalHost().isShowMakeComboInNav());
        this.orderInfoButton = this.constructButton(IconLoader.get((String)"/waitermate/images/tablet.png"), "<HTML>" + Internationalization.getLiteralFor((String)"ORDER") + "<BR>" + Internationalization.getLiteralFor((String)"INFO") + "</HTML>", "orderInfo", this.orderInfoSignal);
        this.orderInfoButton.setVisible(false);
        this.addRight(this.orderInfoButton);
        this.payButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/pay.png"), Internationalization.getLiteralFor((String)"PAY"), "Pay", new Insets(0, 8, 0, 8)), AllPermissions.PAY);
        this.payButton.getDecorateComponent().setName("payButton");
        this.addRight((Component)this.payButton);
        this.addRight(this.holdButton);
        this.renameBarTabButton = this.constructButton(IconLoader.get((String)"/waitermate/images/rename_tab.png"), Internationalization.getLiteralFor((String)"RENAME_TAB"), "renameTab", new Insets(0, 8, 0, 8), this.renameTab);
        this.addRight(this.renameBarTabButton);
        this.assignBarTabToTableButton = this.constructButton(IconLoader.get((String)"/waitermate/images/move_tabs.png"), Internationalization.getLiteralFor((String)"ASSIGN_TO_TABLE"), "assignTabToTable", new Insets(0, 8, 0, 8), this.assignBarTabToTable);
        this.addRight(this.assignBarTabToTableButton);
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
        this.printButtonDecorator = new StandardSecurityDecorator((JComponent)this.getPrintButton(), AllPermissions.PRINT_BILL);
        this.addRight((Component)this.printButtonDecorator);
        this.printAllButtonDecorator = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/printerAdmin.png"), Internationalization.getLiteralFor((String)"PRINT_ALL_BILLS"), "printAllBills", new Insets(0, 8, 0, 8), this.printAllBills), AllPermissions.PRINT_BILL);
        this.printAllButtonDecorator.setVisible(false);
        this.addRight((Component)this.printAllButtonDecorator);
        this.seatAdminDecorator = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/move_tabs.png"), "Seat Admin", "seatAdmin", new Insets(0, 8, 0, 8), this.seatAdminSignal), AllPermissions.ACCOUNT_ADMIN);
        this.addRight((Component)this.seatAdminDecorator);
        this.configDecorator = new StandardSecurityDecorator((JComponent)this.getConfigButton(), AllPermissions.ACCOUNT_ADMIN);
        this.addRight((Component)this.configDecorator);
        Terminal localHost = Terminal.getLocalHost();
        this.saveButtonDecorator = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/save.png"), Internationalization.getLiteralFor((String)"SAVE"), "saveButton", new Insets(0, 8, 0, 8)), AllPermissions.SAVE);
        if (localHost.isSaveButtonEnabled()) {
            this.addRight((Component)this.saveButtonDecorator);
        }
        this.addRight(this.getCancelButton());
        this.setCenterFont(OrderMateTheme.getSmallFont());
        this.priceLevelButton = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"PRICES_CAPITAL"), IconLoader.get((String)"/waitermate/guikit/images/selectTypeUp.png"), IconLoader.get((String)"/waitermate/guikit/images/selectTypeDown.png"));
        this.priceLevelSecurity = new StandardSecurityDecorator((JComponent)this.priceLevelButton, AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL);
        this.priceLevelSecurity.setVisible(false);
        this.addLeft((Component)this.priceLevelSecurity);
        this.priceLevelList = new PriceLevelList();
        this.priceLevelList.setSingleItem(false);
        this.priceLevelList.usePriceLevel.connect((Object)this, "gotPriceLevel");
        this.priceLevelList.useCheapest.connect((Object)this, "gotUseCheapest");
        this.priceLevelButton.setDrawer((JComponent)this.priceLevelList);
        this.tableStateButton = this.constructDrawerToggleButton(Internationalization.getLiteralFor((String)"TABLE_STATE"), IconLoader.get((String)"/waitermate/images/table_states.png"), IconLoader.get((String)"/waitermate/images/table_states.png"));
        this.tableStateButton.setName("tableState");
        this.tableStateSecurity = new StandardSecurityDecorator((JComponent)this.tableStateButton, AllPermissions.ALTER_TABLE_STATE);
        this.addLeft((Component)this.tableStateSecurity);
        this.tableStatePanel = new TableStatePanel();
        this.tableStatePanel.stateChanged.connect((Object)this, "gotTableStateChanged");
        this.tableStateButton.setDrawer((JComponent)this.tableStatePanel);
        this.addLeft((Component)this.tableStateSecurity);
        this.creditLimitDecorator = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/money.png"), Internationalization.getLiteralFor((String)"CREDIT_LIMIT"), "creditLimit", new Insets(0, 8, 0, 8)), AllPermissions.VIEW_CREDIT_LIMIT);
        this.addLeft((Component)this.creditLimitDecorator);
        this.shouldShowCategory = CustomerCategory.getAllCategories().size() > 1;
    }

    public void setTotal(Price newTotal) {
        this.accountPrice = newTotal;
        this.refreshText();
    }

    public void setPreauthAndCredit(Price preauth, Price credit) {
        this.preauthAmount = preauth;
        this.creditAmount = credit;
    }

    public void setAccountName(String name) {
        this.accountName = name;
        this.refreshText();
    }

    public void setCustomerName(String theName) {
        this.customerName = theName;
        this.refreshText();
    }

    public void setPossiblePriceLevels(Set priceLevelsSet, Account account) {
        if (priceLevelsSet == null || priceLevelsSet.size() <= 1) {
            this.priceLevelSecurity.setVisible(false);
        } else {
            this.priceLevelSecurity.setVisible(true);
            this.priceLevelList.setPossibleLevels(priceLevelsSet, new TriggerActivationContext(LoginManager.getEventContext(), new Date(), (ItemGroup)account));
        }
    }

    public void setCustomerPoints(int points) {
        this.customerPoints = SystemProperty.getInstance().isPointsTypeEnabled() ? String.valueOf(points) : new Price((double)points / 100.0).toString();
        this.refreshText();
    }

    public void setNumPatrons(int pax) {
        this.numPatrons = pax;
        this.refreshText();
    }

    public void setDiscountOrSurcharge(SalesPriceAdjustment adjustment) {
        this.discountOrSurcharge = adjustment == null ? "" : "()";
    }

    private void refreshText() {
        String text = "<html>";
        String accountText = "";
        String categoryText = "";
        String loyaltyText = "";
        if (this.accountName != null) {
            accountText = this.accountName + "<br>";
        }
        if (this.shouldShowCategory && this.customerCategory != null && !this.customerCategory.isEmpty()) {
            categoryText = this.customerCategory + "<br>";
        }
        if (this.showLoyaltyPoints) {
            loyaltyText = " (" + this.customerPoints + ")";
        }
        String totalString = SystemProperty.getInstance().isExTax() ? Internationalization.getLiteralFor((String)"TOTAL_INC_TAX_COLON") : Internationalization.getLiteralFor((String)"TOTAL_COLON");
        text = this.customerName != null && !this.customerName.equalsIgnoreCase("") ? text + this.customerName + loyaltyText + "<br>" + categoryText + accountText + totalString + this.accountPrice : text + accountText + totalString + this.accountPrice + " " + this.discountOrSurcharge;
        if (this.preauthAmount != null && !this.preauthAmount.equals((Object)Price.ZERO_DOLLAR)) {
            text = text + "<br>Preauth: " + this.preauthAmount;
        }
        if (this.creditAmount != null) {
            text = text + "<br>Credit: " + this.creditAmount;
        }
        if (this.numPatrons > 0) {
            text = text + "<br>" + this.numPatrons + " " + Internationalization.getLiteralFor((String)"COVERS");
        }
        text = text + "</html>";
        this.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.getBackButton()) {
            this.reset();
            this.back.emit();
        } else if (source == this.getOkButton()) {
            this.reset();
            this.ok.emit();
        } else if (source == this.getCancelButton()) {
            this.cancel.emit();
        } else if (source == this.getConfigButton()) {
            this.config.emit();
        } else if (source == this.seatAdminDecorator.getDecorateComponent()) {
            this.seatAdminSignal.emit();
        } else if (source == this.getPrintButton()) {
            this.print.emit();
        } else if (source == this.showOrderButton) {
            this.showItems.emit();
        } else if (source == this.makeComboButton) {
            this.makeCombo.emit();
        } else if (source == this.breakComboButton) {
            this.breakCombo.emit();
        } else if (this.payButton != null && source == this.payButton.getDecorateComponent()) {
            this.pay.emit();
        } else if (source == this.saveButtonDecorator.getDecorateComponent()) {
            this.save.emit();
        } else if (source == this.deliveryButton) {
            this.showDeliveryMenu.emit();
        } else if (source == this.pickupButton) {
            this.showPhoneMenu.emit();
        } else if (source == this.creditLimitDecorator.getDecorateComponent()) {
            this.creditLimit.emit();
        } else if (source == this.printOrderButton) {
            this.printOrder.emit();
        } else if (source == this.holdButton) {
            this.holdAccount.emit();
        }
    }

    public void reset() {
        this.setCustomerName("");
        this.setCustomerPoints(0);
        this.setCustomerCategory("");
        this.setShowLoyaltyPoints(false);
    }

    public void setDeliveryButtonsVisible(boolean visible) {
        this.deliveryButton.setVisible(visible);
        this.pickupButton.setVisible(visible);
    }

    public void setDeliveryButtonSelected(boolean selected) {
        this.deliveryButton.setSelected(selected);
    }

    public void setMakeCombosVisible(boolean value) {
        this.makeComboButton.setVisible(value);
        this.breakComboButton.setVisible(value);
    }

    public void setPickupButtonSelected(boolean selected) {
        this.pickupButton.setSelected(selected);
    }

    public void setPickupButtonEnabled(boolean enabled) {
        this.pickupButton.setEnabled(enabled);
    }

    public void setCreditLimitButtonsVisible(boolean visible) {
        this.creditLimitDecorator.setVisible(visible);
    }

    public void gotNewUser(User theUser) {
        this.setupPayButton(theUser, this.payButtonIsEnabled);
    }

    public void setupPayButton(User theUser, boolean enabled) {
        this.payButton.setVisible(Terminal.getLocalHost().getPayableCashDrawers(theUser).size() > 0);
        this.payButtonIsEnabled = enabled;
        this.payButton.setEnabled(enabled);
    }

    void gotPriceLevel(PriceLevel level) {
        this.usePriceLevel.emit((Object)level);
        this.priceLevelButton.closeDrawer();
    }

    void gotUseCheapest() {
        this.useCheapestPriceLevels.emit();
        this.priceLevelButton.closeDrawer();
    }

    public void enableAccountAdminButton(boolean enabled) {
        this.configDecorator.setEnabled(enabled);
    }

    public void enableCustomerLocationButton(boolean value) {
        this.customerLocationButton.setEnabled(value);
    }

    public void showCustomerLocationButton(boolean value) {
        this.customerLocationButton.setVisible(value);
    }

    public void showTableStatesButton(boolean value) {
        this.tableStateSecurity.setVisible(value);
    }

    public void setSaveButtonEnabled(boolean enabled) {
        this.saveButtonDecorator.setEnabled(enabled);
    }

    public void setMakeCombosEnabled(boolean value) {
        this.makeComboButton.setEnabled(value);
    }

    public void setBreakCombosEnabled(boolean canBreakCombos) {
        this.breakComboButton.setEnabled(canBreakCombos);
    }

    public void setPrintOrderEnabled(boolean value) {
        if (Terminal.getLocalHost().isGeneralManualPrintPrep() && this.printOrderButton != null) {
            this.printOrderButton.setEnabled(value);
        }
    }

    public void setPrintOrderVisible(boolean value) {
        if (this.printOrderDecorator != null) {
            this.printOrderDecorator.setVisible(value);
        }
    }

    public void setHoldButtonVisible(boolean b) {
        this.holdButton.setVisible(b);
    }

    public void setHoldButtonSelected(boolean selected) {
        this.holdButton.setSelected(selected);
    }

    public void setOrderInfoVisible(boolean isVisible) {
        this.orderInfoButton.setVisible(isVisible);
    }

    public void setCustomerCategory(String customerCategory) {
        this.customerCategory = customerCategory;
        this.refreshText();
    }

    public void setShowLoyaltyPoints(boolean showLoyaltyPoints) {
        this.showLoyaltyPoints = showLoyaltyPoints;
    }

    public void setSeatAdminEnabled(boolean enable) {
        this.seatAdminDecorator.setVisible(enable);
    }

    public void enableRenameBartabLabel(boolean equals) {
        this.renameBarTabButton.setVisible(equals);
    }

    public void enablePrintAllBills(boolean equals) {
        this.printAllButtonDecorator.setVisible(equals);
    }

    public void gotTableStateChanged(LogicalTableState state) {
        this.tableStateButton.closeDrawer();
        this.tableStateChanged.emit((Object)state);
    }

    public void showCoursesLinkedTableStates(boolean showCourseStates) {
        this.tableStatePanel.showStatesLinkedToCourses(showCourseStates);
    }

    public void enableAssignBarTabToTableButton(boolean enabled) {
        this.assignBarTabToTableButton.setVisible(enabled);
    }
}

