/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountitems;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.gui.BorderUtils;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PriceLevelList
extends JPanel {
    public final Signal useCheapest = Signals.createSignal();
    public final Signal usePriceLevel = Signals.createSignal(PriceLevel.class, (String)"Level");
    private JButton cheapestButton;
    private JLabel cheapestLabel;
    private JLabel selectionLabel;
    private RendererScrollPaneModel possibleLevelsModel;

    public PriceLevelList() {
        this.setLayout((LayoutManager)new GraphPaperLayout(1, 20));
        BorderUtils.addEmptyBorder((JComponent)this);
        this.cheapestLabel = new JLabel();
        this.add((Component)this.cheapestLabel, new Rectangle(0, 0, 1, 3));
        this.cheapestButton = new JButton("Cheapest Active Price");
        this.cheapestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriceLevelList.this.useCheapest.emit();
            }
        });
        this.add((Component)this.cheapestButton, new Rectangle(0, 3, 1, 3));
        this.selectionLabel = new JLabel();
        this.add((Component)this.selectionLabel, new Rectangle(0, 6, 1, 2));
        DisplayableRenderer priceLevelRenderer = new DisplayableRenderer();
        priceLevelRenderer.selected.connect((Object)this, "gotPriceLevel");
        this.possibleLevelsModel = new RendererScrollPaneModel((Renderer)priceLevelRenderer);
        CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)this.possibleLevelsModel);
        pane.setColumns(1);
        pane.setRowsPerPage(4);
        pane.setOpaque(false);
        this.add((Component)pane, new Rectangle(0, 8, 1, 12));
        this.setPreferredSize(new Dimension(330, 500));
    }

    public void setSingleItem(boolean value) {
        this.cheapestLabel.setText(this.getSelectCheapestCaption(value));
        this.selectionLabel.setText(this.getSelectOtherCaption(value));
    }

    private String getSelectCheapestCaption(boolean isSingle) {
        if (isSingle) {
            return "<html>This item has several possible prices.  You can set the item to its cheapest active price :</html>";
        }
        return "<html>The items in this account have several possible prices.  You can set all items to their cheapest active price :</html>";
    }

    private String getSelectOtherCaption(boolean isSingle) {
        if (isSingle) {
            return "<html>Alternatively you can set the item to one of the following levels:</html>";
        }
        return "<html>Alternatively you can move all items that support it to one of the following levels:</html>";
    }

    public void setPossibleLevels(Set priceSet, TriggerActivationContext context) {
        for (PriceLevel currentPriceLevel : priceSet) {
            if (!currentPriceLevel.isActive(context)) {
                currentPriceLevel.setLabelFormat("%s (Inactive)");
                currentPriceLevel.setForegroundColor(Color.RED);
                continue;
            }
            currentPriceLevel.setLabelFormat("");
            currentPriceLevel.setForegroundColor(OrderMateTheme.getDefaultTextColor());
        }
        this.possibleLevelsModel.removeAllObjects();
        this.possibleLevelsModel.addObjects((Collection)priceSet);
    }

    void gotPriceLevel(Displayable level) {
        this.usePriceLevel.emit((Object)level);
    }
}

