/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.accountitems;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.PreauthType;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.PreauthTransactionHelper;
import ordermate.database.hardware.eftpos.EftposStatus;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.integration.eftpos.manager.PreauthRequest;
import ordermate.integration.eftpos.manager.PreauthResult;
import ordermate.signals.FireAndForgetSignal;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.gui.screens.payment.eftpos.EftposController;
import waitermate.guikit.dialogs.Dialogs;

public class WaitermatePreauth {
    private final ItemGroup itemGroup;
    private final String CLOSE = "Settle";
    private final String TOPUP = "Topup";
    private final String VOID = "Void";
    private final String VERIFY = "Verify";
    private final String PART_CANCEL = "Partial Cancel";
    private final String EXTEND = "Extend";
    private EftposController controller;
    private Price changingAmount = null;
    public final Signal preauthFinished = new FireAndForgetSignal(new Class[]{PreauthResult.class});

    public WaitermatePreauth(ItemGroup itemGroup) {
        this.itemGroup = itemGroup;
        if (!itemGroup.isPersistent()) {
            Dialogs.displayOkDialog((String)"Cannot do a preauth with an unpersisted account", (String)"Preauth Failed");
            OrderMate.LOG.error("Cannot do a preauth with an unpersisted account");
            throw new IllegalStateException("Cannot do a preauth with an unpersisted account");
        }
        this.controller = new EftposController();
        this.controller.preauthFinished.connect((Object)this, "gotPreauthFinished");
    }

    void gotPreauthFinished(PreauthResult result) {
        if (this.itemGroup instanceof CreditLimited) {
            CreditLimited limited = (CreditLimited)this.itemGroup;
            PreauthRequest request = result.getRequest();
            if (PreauthType.ALLOCATION.equals((Object)request.getTxn().getType())) {
                if (EftposStatus.APPROVED.equals((Object)result.getEftposStatus())) {
                    limited.setCreditLimit(request.getTxn().getAmount());
                } else {
                    limited.setCreditLimit(Price.ZERO_DOLLAR);
                }
            } else if (PreauthType.TOPUP.equals((Object)request.getTxn().getType())) {
                if (EftposStatus.APPROVED.equals((Object)result.getEftposStatus())) {
                    limited.setCreditLimit(PreauthTransactionHelper.getInstance().getTotalPreAuth(request.getTxn().getReferredTxn()));
                }
            } else if (EftposStatus.APPROVED.equals((Object)result.getEftposStatus())) {
                limited.setCreditLimit(Price.ZERO_DOLLAR);
            }
        }
        if (result != null) {
            if (result.getExplicitError() != null) {
                Dialogs.displayOkDialog((String)result.getExplicitError(), (String)"Preauth Failed");
            } else {
                Dialogs.displayOkDialog((String)("The preauth " + result.getRequest().getTxn().getType() + " has completed"), (String)"Preauth Complete");
            }
        }
        if (this.changingAmount == null || result == null || !EftposStatus.APPROVED.equals((Object)result.getEftposStatus())) {
            this.preauthFinished.emit((Object)result);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Price newAmount = WaitermatePreauth.this.changingAmount;
                    WaitermatePreauth.this.changingAmount = null;
                    WaitermatePreauth.this.doAllocation(newAmount);
                }
            });
        }
    }

    public void begin() {
        try {
            PreauthTransaction existing = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)this.itemGroup.getAccount()).toString());
            if (existing != null) {
                StringBuilder SB = new StringBuilder("Do you wish to use the preauth of ");
                SB.append(PreauthTransactionHelper.getInstance().getTotalPreAuth(existing)).append("?");
                Object response = Dialogs.displaySelectionDialog((String)SB.toString(), this.controller.getSupportedPreAuthTypes(existing));
                if ("Settle".equals(response)) {
                    this.doClose(existing);
                } else if ("Void".equals(response)) {
                    this.askToVoid(existing);
                } else if ("Topup".equals(response)) {
                    this.doTopup(existing);
                } else if ("Partial Cancel".equals(response)) {
                    this.doPartVoid(existing);
                } else if ("Extend".equals(response)) {
                    this.askToExtend(existing);
                } else if ("Verify".equals(response)) {
                    this.askToVerify(existing);
                }
            } else {
                this.doAllocation();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
            Dialogs.displayOkDialog((String)"Unexpected Error Occurred", (String)"Preauth Failed");
        }
    }

    private void doTopup(PreauthTransaction toTopup) {
        StringBuilder SB = new StringBuilder("<HTML>");
        SB.append("How much would you like to topup?</HTML>");
        Price amount = WaitermatePreauth.getAmount(SB.toString());
        if (amount != null) {
            FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
            PreauthRequest request = PreauthRequest.makeTopupRequest((FinanceTransactionContext)context, (Price)new Price((Number)amount, 0.01), (PreauthTransaction)toTopup, (ItemGroup)this.itemGroup);
            this.controller.performPreauth(request);
        }
    }

    private void doPartVoid(PreauthTransaction toPartVoid) {
        StringBuilder SB = new StringBuilder("<HTML>");
        SB.append("How much would you like to remove?</HTML>");
        Price amount = WaitermatePreauth.getAmount(SB.toString());
        if (amount != null) {
            FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
            PreauthRequest request = PreauthRequest.makePartVoidRequest((FinanceTransactionContext)context, (Price)new Price((Number)amount, 0.01), (PreauthTransaction)toPartVoid, (ItemGroup)this.itemGroup);
            this.controller.performPreauth(request);
        }
    }

    private void askToExtend(PreauthTransaction toExtend) {
        if (Dialogs.displayChoiceDialog((String)"Are you sure you want to extend the Preauthorized Transaction?", (String)"Extend Preauthorised Transaction?", (boolean)true)) {
            this.doExtend(toExtend);
        }
    }

    private void doExtend(PreauthTransaction toExtend) {
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        PreauthRequest request = PreauthRequest.makeExtendRequest((FinanceTransactionContext)context, (PreauthTransaction)toExtend);
        this.controller.performPreauth(request);
    }

    private void askToVerify(PreauthTransaction toVerify) {
        if (Dialogs.displayChoiceDialog((String)"Are you sure you want to Verify the Preauthorized Transaction?", (String)"Verify Preauthorised Transaction?", (boolean)true)) {
            this.doVerify(toVerify);
        }
    }

    private void doVerify(PreauthTransaction toVerify) {
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        PreauthRequest request = PreauthRequest.makeVerifyRequest((FinanceTransactionContext)context, (PreauthTransaction)toVerify);
        this.controller.performPreauth(request);
    }

    private void doClose(PreauthTransaction toClose) {
        double value = Math.min(this.itemGroup.getDue().doubleValue(), PreauthTransactionHelper.getInstance().getTotalPreAuth(toClose).doubleValue());
        Price priceValue = new Price(value, 0.01);
        Price max = new Price(value, 0.01);
        if (max.approximatelyEquals(Price.ZERO_DOLLAR)) {
            Dialogs.displayOkDialog((String)"You cannot Settle a preauth of $0, please Void", (String)"Cannot Settle");
            return;
        }
        do {
            if (!max.lessThan((Object)(priceValue = new Price(value = Dialogs.getPriceDouble((String)("Preauth Amount (Max " + max + ")"), (double)value), 0.01)))) continue;
            Dialogs.displayOkDialog((String)"You cannot settle for more than was preauthorised or is due", (String)"Invalid Amount");
        } while (max.lessThan((Object)priceValue));
        if (value <= 0.0 || value == Double.MIN_VALUE) {
            return;
        }
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        PreauthRequest request = PreauthRequest.makeConsumptionRequest((FinanceTransactionContext)context, (Price)new Price(value, 0.01), (PreauthTransaction)toClose, (ItemGroup)this.itemGroup);
        this.controller.performPreauth(request);
    }

    private void askToVoid(PreauthTransaction toVoid) {
        if (Dialogs.displayChoiceDialog((String)"If you Void the preauthorised transaction, you will need to make an alternative payment. Are you sure?", (String)"Void Preauthorised Transaction?", (boolean)true)) {
            this.doVoid(toVoid);
        }
    }

    public void doVoid(PreauthTransaction toVoid) {
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        PreauthRequest request = PreauthRequest.makeVoidRequest((FinanceTransactionContext)context, (PreauthTransaction)toVoid);
        this.controller.performPreauth(request);
    }

    private void doAllocation() {
        Price amount = WaitermatePreauth.getAmount();
        if (amount != null) {
            this.doAllocation(amount);
        }
    }

    public static Price getAmount() {
        StringBuilder SB = new StringBuilder("<HTML>");
        SB.append("You must reserve funds on the <br>customer's credit card to open a bar tab.<br>").append("How much would you like to reserve?</HTML>");
        double value = Dialogs.getPriceDouble((String)SB.toString());
        if (value <= 0.009 || value == Double.MIN_VALUE) {
            return null;
        }
        return new Price(value, 0.01);
    }

    public static Price getAmount(String displayStr) {
        double value = Dialogs.getPriceDouble((String)displayStr);
        if (value <= 0.009 || value == Double.MIN_VALUE) {
            return null;
        }
        return new Price(value, 0.01);
    }

    public void doAllocation(Price amount) {
        FinanceTransactionContext context = new FinanceTransactionContext(LoginManager.getEventContext());
        PreauthRequest request = PreauthRequest.makeAllocationRequest((FinanceTransactionContext)context, (Price)amount, (Account)this.itemGroup.getAccount());
        this.controller.performPreauth(request);
    }

    private void askToChange(PreauthTransaction toChange) {
        Price amount = WaitermatePreauth.getAmount();
        if (amount != null && amount.greaterThan((Object)Price.ZERO_DOLLAR) && Dialogs.displayChoiceDialog((String)("This will void the current preauth transaction of " + PreauthTransactionHelper.getInstance().getTotalPreAuth(toChange)), (String)"Proceed?", (String)"Yes", (String)"No", (boolean)false)) {
            this.changingAmount = amount;
            this.doVoid(toChange);
        }
    }
}

