/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.CustomerPerSeatItemGroup;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.misc.OrderItemLogType;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.dialogs.AutoComboSelector;
import waitermate.gui.screens.ordering.additems.AddItemsConfiguration;
import waitermate.gui.screens.ordering.additems.FinaliseItem;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.SpecifyCombo;
import waitermate.gui.screens.ordering.additems.SpecifyItem;
import waitermate.gui.screens.ordering.additems.selectitem.SelectMenuItem;
import waitermate.gui.screens.ordering.modifyitem.ModifyItem;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.gui.screens.selectaccount.table.CoversHelper;
import waitermate.guikit.dialogs.Dialogs;

public class AddItems {
    public final Signal done = Signals.createSignal();
    private final Signal modifyDone = Signals.createSignal();
    public final Signal comboCancel = Signals.createSignal();
    public final Signal comboBack = Signals.createSignal();
    public final Signal comboDone = Signals.createSignal(SalesLineItem.class, (String)"SelectedItem");
    private final Signal finaliseItemBack = Signals.createSignal();
    private final Signal finaliseComboBack = Signals.createSignal();
    private final Signal autoComboDone = Signals.createSignal();
    public final Signal orderingComplete = Signals.createSignal();
    private final SelectMenuItem selectItem;
    private final SpecifyItem specifyItem;
    private final FinaliseItem finaliseItem;
    private Account account;
    private OrderedItemDetails details;
    private boolean incrementQuantity;
    private boolean singleItem;
    private final AddItemsConfiguration addItemConfig;

    public AddItems(boolean quickSaleMode) {
        this.selectItem = new SelectMenuItem(quickSaleMode);
        this.specifyItem = new SpecifyItem();
        this.specifyItem.back.connect((Object)this, "gotBackToItem");
        this.specifyItem.itemsDone.connect((Object)this, "gotStartFinaliseItems");
        this.finaliseItem = new FinaliseItem();
        this.finaliseItem.itemsDone.connect((Object)this, "gotFinishedItems");
        this.finaliseItemBack.connect((Object)this, "gotBackFromFinaliseItem");
        this.finaliseComboBack.connect((Object)this, "gotBackFromFinaliseCombo");
        this.autoComboDone.connect((Object)this, "refreshItems");
        this.comboBack.connect((Object)this, "gotBackToItem");
        this.comboDone.connect((Object)this, "gotStartFinaliseItem");
        this.selectItem.itemSelected.connect((Object)this, "gotInventoryItem");
        this.selectItem.comboSelected.connect((Object)this, "gotInventoryCombo");
        this.selectItem.back.connect((Object)this, "finishAddItems");
        this.selectItem.ok.connect((Object)this, "orderingComplete");
        this.selectItem.modifySelected.connect((Object)this, "gotModifyLast");
        this.modifyDone.connect((Object)this, "gotModifyDone");
        this.addItemConfig = new AddItemsConfiguration();
    }

    public void startAddingItem(Account toAdd, InventoryGroup menuGroup, OrderedItemDetails theDetails) {
        this.details = theDetails;
        this.account = toAdd;
        this.singleItem = false;
        int seats = CoversHelper.getValueForSeats((ItemGroup)this.account);
        this.selectItem.setupSeatsPanel(this.account.usesSeatNums() ? seats : 1, this.details.getSeat());
        this.specifyItem.setOrderedItemDetails(this.details);
        this.doSelectItems(menuGroup);
    }

    private ItemGroup getCurrentItemGroup() {
        Account itemGroup = this.account;
        if (itemGroup instanceof TableAccount) {
            int theSeat = this.details.getSeat();
            TableAccount tableAcc = (TableAccount)this.account;
            Customer customer = tableAcc.getCustomerForSeat(theSeat);
            if (SystemProperty.getInstance().isCustomerAssignmentPerSeat() && customer != null) {
                itemGroup = new CustomerPerSeatItemGroup(tableAcc, customer, new int[]{theSeat});
            }
        }
        return itemGroup;
    }

    private void doSelectItems(InventoryGroup menuGroup) {
        boolean showQuantity = Terminal.getLocalHost().getHasMenuKeypad();
        boolean showQuickSeatSelect = this.account.usesSeatNums() && this.account.getNumPatrons() > 1 && Terminal.getLocalHost().getQuickSeatSelect() && Terminal.getLocalHost().getSeatNums() && Terminal.getLocalHost().getStickyMenu();
        this.selectItem.selectItem(this.getCurrentItemGroup(), menuGroup, this.account.getOrderedItems(), this.getCurrentItemGroup().getItemHelper().getAllItemsUnsaved(), showQuantity, showQuickSeatSelect);
    }

    public void gotStartAddingItem(Account toAdd, InventoryItem selectedItem, OrderedItemDetails theDetails, SalesQuantity qty) {
        this.startAddingItem(toAdd, selectedItem, theDetails, qty, true);
    }

    public void gotStartAddingCombo(Account toAdd, InventoryCombo selectedCombo, OrderedItemDetails theDetails, SalesQuantity qty) {
        this.startAddingCombo(toAdd, selectedCombo, theDetails, qty, true);
    }

    public void gotStartAddingItem(Account toAdd, InventoryItemUnit itemUnit, OrderedItemDetails theDetails, SalesQuantity qty) {
        this.startAddingItem(toAdd, itemUnit, theDetails, qty, true);
    }

    public void startAddingItem(Account toAdd, InventoryItem selectedItem, OrderedItemDetails theDetails, SalesQuantity quantity, boolean incrementQuantityFlag) {
        if (toAdd == null) {
            throw new IllegalArgumentException(Internationalization.getLiteralFor((String)"ACCOUNT_SHOULD_NOT_BE_NULL"));
        }
        this.details = theDetails;
        this.account = toAdd;
        this.incrementQuantity = incrementQuantityFlag;
        this.singleItem = true;
        this.specifyItem.setOrderedItemDetails(this.details);
        this.specifyItem.startSpecifyingItem(selectedItem, quantity, this.account);
    }

    public void startAddingCombo(Account toAdd, InventoryCombo selectedCombo, OrderedItemDetails theDetails, SalesQuantity quantity, boolean incrementQuantityFlag) {
        this.details = theDetails;
        this.account = toAdd;
        this.incrementQuantity = incrementQuantityFlag;
        this.singleItem = true;
        this.startSpecifyingCombo(selectedCombo, quantity);
    }

    public void startAddingItem(Account toAdd, InventoryItemUnit selectedUnit, OrderedItemDetails theDetails, SalesQuantity quantity, boolean incrementQuantityFlag) {
        this.details = theDetails;
        this.account = toAdd;
        this.incrementQuantity = incrementQuantityFlag;
        this.singleItem = true;
        this.specifyItem.setOrderedItemDetails(this.details);
        this.specifyItem.startSpecifyingUnit(selectedUnit, quantity, this.account);
    }

    void gotInventoryItem(InventoryItem invItem) {
        SalesQuantity quantity = this.selectItem.getQuantity();
        this.incrementQuantity = this.selectItem.getIncrementQuantityFlag();
        this.details.setSeat(this.selectItem.getSelectedSeat());
        this.specifyItem.setOrderedItemDetails(this.details);
        this.specifyItem.startSpecifyingItem(invItem, quantity, this.account);
    }

    void gotInventoryCombo(InventoryCombo combo) {
        SalesQuantity quantity = this.selectItem.getQuantity();
        this.incrementQuantity = this.selectItem.getIncrementQuantityFlag();
        this.details.setSeat(this.selectItem.getSelectedSeat());
        this.startSpecifyingCombo(combo, quantity);
    }

    private void startSpecifyingCombo(InventoryCombo combo, SalesQuantity quantity) {
        SpecifyCombo specifyCombo = SpecifyCombo.getInstance();
        specifyCombo.configureSignals(this.comboBack, this.comboCancel, this.comboDone);
        specifyCombo.startSpecifyingItem(combo, quantity, this.account);
    }

    void gotBackToItem() {
        if (!this.singleItem) {
            this.selectItem.display();
        } else {
            this.finishAddItems();
        }
    }

    void gotModifyLast() {
        SalesLineItem lastItem = this.account.getLastItemOrdered();
        if (lastItem != null) {
            this.account.addOrderedItemToAccount(lastItem);
            ModifyItem.getInstance().startModify(lastItem, this.account, this.modifyDone);
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"NO_ITEMS_PREVIOUSLY_SELECTED_CANNOT_MODIFY_LAST_ITEM"), (String)Internationalization.getLiteralFor((String)"CANNOT_MODIFY_LAST_ITEM"));
        }
    }

    void gotModifyDone() {
        if (Terminal.getLocalHost().getStickyMenu() && !this.singleItem) {
            this.doSelectItems(this.selectItem.getInventoryGroup());
        } else {
            this.orderingComplete();
        }
    }

    void gotStartFinaliseItems(List<SalesLineItem> slsLineItems) {
        this.finaliseItem.startFinalisingItem(slsLineItems, this.account, this.details, this.finaliseItemBack);
    }

    void gotStartFinaliseItem(SalesLineItem newItem) {
        this.finaliseItem.startFinalisingItem(Collections.singletonList(newItem), this.account, this.details, this.finaliseComboBack);
    }

    void gotBackFromFinaliseItem() {
        this.specifyItem.gotBackToNotes();
    }

    void gotBackFromFinaliseCombo() {
        SpecifyCombo specifyCombo = SpecifyCombo.getInstance();
        specifyCombo.gotBackToState();
    }

    void gotFinishedItems(List<SalesLineItem> slsLineItems) {
        for (SalesLineItem item : slsLineItems) {
            item.setCourse(this.details.getCourse());
            SalesCombo.updateCourse((SalesLineItem)item);
            List<SalesLineItem> splitItems = this.updateSeatAndQtys(item);
            for (SalesLineItem itemToAddtoAccount : splitItems) {
                this.account.mergeItemIntoOrderedList(itemToAddtoAccount, this.incrementQuantity, LoginManager.getEventContext());
            }
        }
        if (this.details.getOpenPrice() != null && !Price.ZERO_DOLLAR.equals((Object)this.details.getOpenPrice()) && slsLineItems.size() == 1) {
            slsLineItems.get(0).setPrice(this.details.getOpenPrice(), LoginManager.getEventContext());
        }
        if (Terminal.getLocalHost().getStickyMenu() && !this.singleItem) {
            this.doSelectItems(this.selectItem.getInventoryGroup());
        } else {
            this.orderingComplete();
        }
    }

    void gotFinishedCurrentItem(SalesLineItem newItem) {
        newItem.setCourse(this.details.getCourse());
        SalesCombo.updateCourse((SalesLineItem)newItem);
        List<SalesLineItem> splitItems = this.updateSeatAndQtys(newItem);
        for (SalesLineItem itemToAddtoAccount : splitItems) {
            this.account.mergeItemIntoOrderedList(itemToAddtoAccount, this.incrementQuantity, LoginManager.getEventContext());
        }
        if (Terminal.getLocalHost().getStickyMenu() && !this.singleItem) {
            this.doSelectItems(this.selectItem.getInventoryGroup());
        } else {
            this.orderingComplete();
        }
    }

    private List<SalesLineItem> updateSeatAndQtys(SalesLineItem item) {
        if (this.details.getSeatToQtyMap() == null) {
            item.setSeat(this.details.getSeat());
            return Collections.singletonList(item);
        }
        Map<Integer, Integer> seatQty = this.details.getSeatToQtyMap();
        ArrayList<SalesLineItem> itemsSplit = new ArrayList<SalesLineItem>();
        for (Integer seat : seatQty.keySet()) {
            if (seatQty.get(seat) <= 0) continue;
            SalesLineItem copy = item.copy(LoginManager.getEventContext(), true);
            copy.setSeat(seat.intValue());
            copy.setQuantity(new SalesQuantity(new BigDecimal(seatQty.get(seat))), LoginManager.getEventContext());
            itemsSplit.add(copy);
        }
        return itemsSplit;
    }

    public void orderingComplete() {
        try {
            TerminalEventLog.logOrderedItems((User)LoginManager.getInstance().getUser(), (Terminal)LoginManager.getEventContext().getTerminal(), (ItemGroup)this.account, (Collection)this.account.getOrderedItems(), (OrderItemLogType)OrderItemLogType.ADD);
        }
        catch (Exception ex) {
            OrderMate.LOG.error((Object)ex);
        }
        if (this.checkOversell()) {
            this.account.addOrderedItemsToAccount();
            if (SystemProperty.getInstance().formAutoCombosOnOrder()) {
                this.doAutoCombos(this.account, this.details);
            }
        }
        this.orderingComplete.emit();
        this.finishAddItems();
    }

    public void finishAddItems() {
        this.details.setSeatToQtyMap(null);
        this.account.clearOrderedItems();
        this.done.emit();
    }

    private boolean isPerSeatTable() {
        return SystemProperty.getInstance().isCustomerAssignmentPerSeat() && this.account instanceof TableAccount;
    }

    private List<List<? extends SalesLineItem>> getCurrentItems() {
        ArrayList<List<? extends SalesLineItem>> bundles = new ArrayList<List<? extends SalesLineItem>>();
        if (this.isPerSeatTable()) {
            HashMap itemsMap = new HashMap();
            for (SalesLineItem anItem : this.account.getItemHelper().getUnpaidItems()) {
                Customer itemCustomer = anItem.getCustomer();
                if (itemCustomer != null) {
                    if (!itemsMap.containsKey(itemCustomer)) {
                        itemsMap.put(itemCustomer, new ArrayList());
                    }
                    ((List)itemsMap.get(itemCustomer)).add(anItem);
                    continue;
                }
                int itemSeat = anItem.getSeat();
                if (!itemsMap.containsKey(itemSeat)) {
                    itemsMap.put(itemSeat, new ArrayList());
                }
                ((List)itemsMap.get(itemSeat)).add(anItem);
            }
            for (List itemList : itemsMap.values()) {
                bundles.add(itemList);
            }
        } else {
            bundles.add(this.account.getItemHelper().getUnpaidItems());
        }
        return bundles;
    }

    public void doAutoCombos(Account theAccount, OrderedItemDetails theDetails) {
        if (this.account == null) {
            OrderMate.LOG.warn("Account of AddItems is null for doing auto combos!Setting the account for auto combos!");
            this.setAccount(theAccount);
        }
        List<List<? extends SalesLineItem>> items = this.getCurrentItems();
        if (this.addItemConfig.isAllowAutoCombo() && AutoComboSelector.canMakeCombos((ItemGroup)this.account, items)) {
            AutoComboSelector selector = AutoComboSelector.getInstance();
            selector.configureSignal(this.autoComboDone);
            selector.setContext((ItemGroup)this.account, items, LoginManager.getEventContext());
            selector.startMake();
        }
    }

    public void refreshItems() {
        this.selectItem.refreshGroups();
    }

    private boolean checkOversell() {
        if (this.account instanceof CreditLimited) {
            Price price = Price.ZERO_DOLLAR;
            for (SalesLineItem item : this.account.getOrderedItems()) {
                price = price.add(item.getPrice());
            }
            if (((CreditLimited)this.account).exceedsCreditLimit(price)) {
                return CreditLimitPanel.doCreditLimitDialog((CreditLimited)this.account, price, this.account.getLabel(), true);
            }
        }
        return true;
    }

    public AddItemsConfiguration getAddItemConfig() {
        return this.addItemConfig;
    }

    public void setAccount(Account currentAccount) {
        this.account = currentAccount;
    }
}

