/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ItemBarcodeType;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockUtilities;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.services.sales.ItemGroupPriceLevelPolicy;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.SpecifyComponents;
import waitermate.gui.screens.ordering.additems.addnotes.AddNotes;
import waitermate.gui.screens.ordering.additems.selectWeight.SelectWeight;
import waitermate.gui.screens.ordering.additems.selectprice.OpenPrice;
import waitermate.gui.screens.ordering.additems.selectunit.SelectUnit;
import waitermate.guikit.dialogs.Dialogs;

class SpecifyItem {
    public final Signal itemsDone = Signals.createSignal(List.class, (String)"New items");
    public final Signal back = Signals.createSignal();
    private SelectUnit selectUnit = new SelectUnit();
    private OpenPrice enterPrice;
    private AddNotes enterNotes;
    private SpecifyComponents specifyComponents;
    private SelectWeight selectWeight;
    private SalesItem currentNewItem;
    private Account account;
    private InventoryItem initialItem;
    private SalesQuantity quantity;
    private InventoryComboGroup theComboGroup;
    private OrderedItemDetails details;

    public SpecifyItem() {
        this.selectUnit.unitSelected.connect((Object)this, "gotUnit");
        this.selectUnit.back.connect((Object)this, "gotBack");
        this.specifyComponents = new SpecifyComponents();
        this.specifyComponents.back.connect((Object)this, "gotBackToUnit");
        this.specifyComponents.done.connect((Object)this, "enterPrice");
        this.enterPrice = new OpenPrice();
        this.enterPrice.back.connect((Object)this.specifyComponents, "startBack");
        this.enterPrice.price.connect((Object)this, "gotPrice");
        this.enterNotes = new AddNotes();
        this.enterNotes.back.connect((Object)this, "gotBackToPrice");
        this.enterNotes.notes.connect((Object)this, "gotNotes");
        this.selectWeight = new SelectWeight();
        this.selectWeight.cancel.connect((Object)this, "gotBack");
        this.selectWeight.weightOk.connect((Object)this, "gotWeight");
        this.selectWeight.manuallyEnterWeight.connect((Object)this, "gotManuallyEnterWeight");
    }

    public void startSpecifyingItem(InventoryItem selected, SalesQuantity newQuantity, Account newAccount) {
        this.account = newAccount;
        this.initialItem = selected;
        this.currentNewItem = null;
        this.quantity = newQuantity;
        this.theComboGroup = null;
        this.selectUnit(newAccount, selected.getUnits(), null);
    }

    public void startSpecifyingUnit(InventoryItemUnit selectedUnit, SalesQuantity newQuantity, Account newAccount) {
        this.account = newAccount;
        this.initialItem = selectedUnit.getItem();
        this.currentNewItem = null;
        this.quantity = newQuantity;
        this.theComboGroup = null;
        this.gotUnit(selectedUnit);
    }

    public void startSpecifyingComboItem(InventoryItem selected, InventoryComboGroup comboGroup, SalesQuantity newQuantity, Account newAccount) {
        this.account = newAccount;
        this.initialItem = selected;
        this.currentNewItem = null;
        this.quantity = newQuantity;
        this.theComboGroup = comboGroup;
        this.selectUnit(newAccount, this.theComboGroup.getAllUnitsForItem(selected), this.theComboGroup.getUnitPriceAddPerItemSize(selected));
    }

    void selectUnit(Account newAccount, List<InventoryItemUnit> unitsToSelect, Map<InventoryItemPortion, Map<InventoryItemSize, Price>> priceAdds) {
        ArrayList<InventoryItemUnit> filteredUnits = new ArrayList<InventoryItemUnit>();
        for (InventoryItemUnit unit : unitsToSelect) {
            UnitPriceLevel upl = unit.getActiveUnitPriceLevel(LoginManager.getEventContext(), new Date(), this.account);
            if (upl == null) continue;
            filteredUnits.add(unit);
        }
        if (filteredUnits.size() > 1) {
            this.selectUnit.selectUnit(newAccount, filteredUnits, priceAdds);
        } else if (filteredUnits.isEmpty()) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"THERE_IS_NO_PRICE_OR_SIZE_ASSOCIATED_WITH_THIS_ITEM_PLEASE_CONTACT_YOUR_MANAGER") + "</html>"), (String)Internationalization.getLiteralFor((String)"ITEM_CANNOT_BE_ORDERED"));
        } else {
            this.gotUnit((InventoryItemUnit)filteredUnits.get(0));
        }
    }

    void gotUnit(InventoryItemUnit newUnit) {
        if (!InventoryWeightUnit.NA.equals((Object)newUnit.getItem().getInventoryWeightUnit())) {
            if (this.quantity == null || SalesQuantity.ZERO.equals(this.quantity) || SalesQuantity.ONE == this.quantity || !ItemBarcodeType.Weight.equals((Object)SystemProperty.getInstance().getItemBarcodeType())) {
                this.selectWeight.startSelectingWeight(newUnit);
            } else {
                this.specifyUnit(newUnit);
            }
        } else {
            this.specifyUnit(newUnit);
        }
    }

    void gotWeight(InventoryItemUnit unit, Double value) {
        this.quantity = new SalesQuantity(value.toString());
        this.specifyUnit(unit);
        this.currentNewItem.setWeightManuallyEntered(false);
    }

    void gotManuallyEnterWeight(InventoryItemUnit unit) {
        InventoryWeightUnit weightUnit = unit.getItem().getInventoryWeightUnit();
        double value = Dialogs.getDouble((String)weightUnit.getDisplay(), (double)0.0);
        if (value != Double.MIN_VALUE) {
            this.quantity = SalesQuantity.valueOf((String)Double.toString(value /= (double)weightUnit.getFactor()));
            this.specifyUnit(unit);
            this.currentNewItem.setWeightManuallyEntered(true);
        } else {
            this.gotBack();
        }
    }

    private void specifyUnit(InventoryItemUnit newUnit) {
        if (this.theComboGroup != null) {
            this.specifyComponents.start(newUnit, this.theComboGroup.getItems(), this.quantity, this.account);
        } else {
            List possibleItems = newUnit.getPortion().isFractional() ? newUnit.getItem().getMenuGroup().getItems(newUnit.getPortion(), newUnit.getSize()) : Collections.emptyList();
            this.specifyComponents.start(newUnit, possibleItems, this.quantity, this.account);
        }
    }

    void gotBackToUnit() {
        if (this.initialItem.getUnits().size() > 1) {
            this.selectUnit.display(false);
        } else {
            this.gotBack();
        }
    }

    void enterPrice(SalesItem newItem) {
        this.currentNewItem = newItem;
        boolean openPrice = false;
        for (SalesComponent component : this.currentNewItem.getComponentList()) {
            openPrice = component.getInventoryItem().isOpenPrice();
        }
        if (openPrice) {
            this.enterPrice.display(false);
        } else {
            this.enterNotes();
        }
    }

    void gotPrice(Price newPrice) {
        this.currentNewItem.setPrice(newPrice, LoginManager.getEventContext());
        boolean itemNote = false;
        for (SalesComponent component : this.currentNewItem.getComponentList()) {
            itemNote = component.getInventoryItem().isItemNote();
        }
        if (itemNote) {
            this.enterNotes();
        } else {
            this.finishItem();
        }
    }

    void gotBackToPrice() {
        boolean openPrice = false;
        Iterator it = this.currentNewItem.getComponentList().iterator();
        while (it.hasNext() && !openPrice) {
            SalesComponent component = (SalesComponent)it.next();
            openPrice = component.getInventoryItem().isOpenPrice();
        }
        if (openPrice) {
            this.enterPrice.display(false);
        } else {
            this.gotBackToUnit();
        }
    }

    void enterNotes() {
        boolean itemNote = false;
        for (SalesComponent component : this.currentNewItem.getComponentList()) {
            itemNote = component.getInventoryItem().isItemNote();
        }
        if (itemNote) {
            this.enterNotes.display(false);
        } else {
            this.finishItem();
        }
    }

    void gotNotes(String notes) {
        this.currentNewItem.setNotes(notes);
        this.finishItem();
    }

    public void gotBackToNotes() {
        boolean itemNote = false;
        for (SalesComponent component : this.currentNewItem.getComponentList()) {
            itemNote = component.getInventoryItem().isItemNote();
        }
        if (itemNote) {
            this.enterNotes.display(false);
        } else {
            this.gotBackToPrice();
        }
    }

    private void finishItem() {
        if (!StockUtilities.allowQuantityEdit((Account)this.account, (List)this.account.getOrderedItems(), (SalesLineItem)this.currentNewItem, (SalesQuantity)this.currentNewItem.getQuantity(), (User)LoginManager.getInstance().getUser())) {
            this.gotBack();
            return;
        }
        if (this.theComboGroup != null) {
            this.finalizeComboItem();
        }
        List pricedItems = this.currentNewItem.getSalesItems();
        Iterator it = pricedItems.iterator();
        boolean fail = false;
        ItemGroupPriceLevelPolicy policy = new ItemGroupPriceLevelPolicy((ItemGroup)this.account);
        while (it.hasNext() && !fail) {
            SalesItem item = (SalesItem)it.next();
            this.account.addOrderedItem((SalesLineItem)item);
            Iterator compIt = item.getComponentList().iterator();
            while (compIt.hasNext() && !fail) {
                SalesComponent component = (SalesComponent)compIt.next();
                UnitPriceLevel priceLevel = component.getUnit().getActiveUnitPriceLevel(LoginManager.getEventContext(), new Date(), this.account);
                if (priceLevel == null) {
                    Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THE_SELECTED_ITEM_AND_SIZE_HAS_NO_CURRENTLY_ACTIVE_PRICES"), (String)Internationalization.getLiteralFor((String)"ITEM_CANNOT_BE_ORDERED"));
                    fail = true;
                    continue;
                }
                policy.setComponentPriceLevel(component, priceLevel);
            }
        }
        this.account.removeOrderedItems(pricedItems);
        List regroupedItems = this.currentNewItem.regroupItems(pricedItems, Terminal.getLocalHost(), LoginManager.getInstance().getUser());
        this.tearDownScreens();
        this.itemsDone.emit((Object)regroupedItems);
    }

    public void gotBack() {
        this.tearDownScreens();
        this.back.emit();
    }

    private void tearDownScreens() {
        this.selectUnit.tearDown();
        this.specifyComponents.tearDown();
        this.enterNotes.tearDown();
        this.enterPrice.tearDown();
    }

    private void finalizeComboItem() {
        Course course = this.theComboGroup.getItemCourse(this.currentNewItem.getFirstInventoryItem());
        if (course != null) {
            this.currentNewItem.setCourse(course);
        }
    }

    public void setOrderedItemDetails(OrderedItemDetails details) {
        this.details = details;
    }
}

