/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.CreditLimited;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.button.CustomButton;
import ordermate.internationalization.Internationalization;
import ordermate.services.sales.UpgradeableComboHelper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.additems.SpecifyCombo;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class UpgradeCombo {
    private final Signal cancel = Signals.createSignal();
    private final Signal done = Signals.createSignal(SalesLineItem.class, (String)"newCombo");
    private Signal gotCombo;
    private Signal upgradeFinished;
    private static final UpgradeCombo instance = new UpgradeCombo();
    private Account currentAccount;
    private List<UpgradeItem> upgradeItems;

    private UpgradeCombo() {
        this.cancel.connect((Object)this, "gotUpgradeFinished");
        this.done.connect((Object)this, "gotUpgradeDone");
    }

    public static final UpgradeCombo getInstance() {
        return instance;
    }

    public void configureSignal(Signal finishedSignal) {
        this.upgradeFinished = finishedSignal;
    }

    public void configureComboSignal(Signal comboSignal) {
        this.gotCombo = comboSignal;
    }

    public void upgradeRequested(SalesItem theItem, ItemGroup itemGroup, EventContext context) {
        if (!theItem.isModifiable(context)) {
            throw new IllegalArgumentException("Cannot upgrade an item that is not modifiable: " + theItem);
        }
        if (this.upgradeFinished == null) {
            throw new IllegalStateException("Cannot perform an Upgrade request if the finished signal has not been set.");
        }
        this.currentAccount = itemGroup.getAccount();
        if (!this.currentAccount.getAllItems().contains(theItem)) {
            throw new IllegalArgumentException("Item to upgrade must be in account : " + this.currentAccount + " " + theItem);
        }
        TriggerActivationContext triggerContext = new TriggerActivationContext(context, itemGroup);
        List potentialCombos = UpgradeableComboHelper.getInstance().getPotentialCombos(triggerContext, (SalesLineItem)theItem);
        InventoryCombo theCombo = null;
        if (potentialCombos.size() > 1) {
            ArrayList<CustomButton> buttons = new ArrayList<CustomButton>();
            Dimension buttonDim = new Dimension(400, 80);
            for (InventoryCombo combo : potentialCombos) {
                CustomButton button = new CustomButton((Displayable)combo);
                button.setPreferredSize(buttonDim);
                buttons.add(button);
            }
            CustomButton selected = (CustomButton)new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_A_COMBO"), buttons, 1, Math.min(6, buttons.size()), true).start();
            if (selected != null) {
                theCombo = (InventoryCombo)selected.getData();
            }
        } else if (potentialCombos.size() == 1) {
            theCombo = (InventoryCombo)potentialCombos.get(0);
        }
        if (theCombo != null) {
            this.doUpgrade(Arrays.asList(theItem), theCombo, context);
        }
    }

    public void specificUpgradeRequested(List<SalesItem> itemsToUpgrade, InventoryCombo theCombo, Account account, EventContext context) {
        for (SalesLineItem salesLineItem : itemsToUpgrade) {
            if (salesLineItem.isModifiable(context)) continue;
            throw new IllegalArgumentException("Cannot upgrade an item that is not modifiable: " + salesLineItem);
        }
        if (this.upgradeFinished == null) {
            throw new IllegalStateException("Cannot perform an Upgrade request if the finished signal has not been set.");
        }
        this.currentAccount = account;
        for (SalesItem salesItem : itemsToUpgrade) {
            if (this.currentAccount.getAllItems().contains(salesItem)) continue;
            throw new IllegalArgumentException("Item to upgrade must be in account : " + this.currentAccount + " " + salesItem);
        }
        TriggerActivationContext triggerContext = new TriggerActivationContext(context, (ItemGroup)this.currentAccount);
        if (theCombo != null) {
            this.doUpgrade(itemsToUpgrade, theCombo, context);
        }
    }

    private void doUpgrade(List<SalesItem> itemsToUpgrade, InventoryCombo combo, EventContext context) {
        SpecifyCombo.getInstance().configureSignals(this.cancel, this.cancel, this.done);
        this.upgradeItems = new ArrayList<UpgradeItem>();
        for (SalesItem item : itemsToUpgrade) {
            this.upgradeItems.add(new UpgradeItem(item, context));
        }
        SpecifyCombo.getInstance().startSpecifyingItem(combo, SalesQuantity.ONE, this.currentAccount, this.getItemsForUpgrade(this.upgradeItems));
    }

    void gotUpgradeDone(SalesLineItem addedCombo) {
        if (!this.checkOversell(addedCombo)) {
            return;
        }
        for (UpgradeItem itemPair : this.upgradeItems) {
            if (itemPair.getUpgradedItem() == itemPair.getOriginalItem()) continue;
            this.currentAccount.getItemHelper().addItemBefore(itemPair.getOriginalItem(), new SalesLineItem[]{itemPair.getUpgradedItem()});
        }
        if (this.upgradeItems != null && this.upgradeItems.size() > 0) {
            int seat = this.upgradeItems.get(0).getUpgradedItem().getSeat();
            int course = this.upgradeItems.get(0).getUpgradedItem().getCourse();
            addedCombo.setSeat(seat);
            for (SalesItem item : addedCombo.getSalesItems()) {
                item.setSeat(seat);
            }
            addedCombo.setCourse(course);
            SalesCombo.updateCourse((SalesLineItem)addedCombo);
            this.currentAccount.getItemHelper().addItemBefore((SalesLineItem)this.upgradeItems.get(0).getUpgradedItem(), new SalesLineItem[]{addedCombo});
            if (this.gotCombo != null) {
                this.gotCombo.emit((Object)addedCombo);
                this.gotCombo = null;
            }
            this.gotUpgradeFinished();
        }
    }

    void gotUpgradeFinished() {
        for (UpgradeItem itemPair : this.upgradeItems) {
            if (!itemPair.getUpgradedItem().getAccount().equals((Object)this.currentAccount)) {
                throw new IllegalStateException("Account no longer contains upgraded item");
            }
            if (itemPair.getOriginalItem().getAccount().equals((Object)this.currentAccount)) continue;
            throw new IllegalStateException("Account no longer contains original item");
        }
        this.currentAccount = null;
        this.upgradeItems.clear();
        this.upgradeFinished.emit();
        this.upgradeFinished = null;
    }

    private boolean checkOversell(SalesLineItem newCombo) {
        if (this.currentAccount instanceof CreditLimited && !this.upgradeItems.isEmpty()) {
            Price delta = newCombo.getPrice();
            for (UpgradeItem itemPair : this.upgradeItems) {
                delta = delta.subtract(itemPair.getUpgradedItem().getPrice());
            }
            CreditLimited limitedAccount = (CreditLimited)this.currentAccount;
            if (limitedAccount.exceedsCreditLimit(delta)) {
                return CreditLimitPanel.doCreditLimitDialog(limitedAccount, delta, limitedAccount.getLabel(), true);
            }
        }
        return true;
    }

    private List<SalesItem> getItemsForUpgrade(List<UpgradeItem> itemPairs) {
        ArrayList<SalesItem> items = new ArrayList<SalesItem>();
        for (UpgradeItem itemPair : itemPairs) {
            items.add(itemPair.getUpgradedItem());
        }
        return items;
    }

    private class UpgradeItem {
        private SalesItem originalItem;
        private SalesItem upgradedItem = null;

        public UpgradeItem(SalesItem originalItem, EventContext context) {
            this.originalItem = originalItem;
            if (this.originalItem.getQuantity().greaterThan(SalesQuantity.ONE)) {
                this.upgradedItem = (SalesItem)originalItem.split(SalesQuantity.ONE, context);
            }
        }

        public SalesLineItem getOriginalItem() {
            return this.originalItem;
        }

        public SalesItem getUpgradedItem() {
            if (this.upgradedItem != null) {
                return this.upgradedItem;
            }
            return this.originalItem;
        }
    }
}

