/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectWeight;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import ordermate.database.hardware.physical.scales.ScalesStatus;
import ordermate.integration.scales.ScalesAdapter;
import ordermate.integration.scales.ScalesResponse;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ScalesSniffer
implements ActionListener {
    private static final int MIN_PERIOD = 50;
    final Signal readScales = Signals.createSignal(ScalesResponse.class, (String)"response");
    private ScalesAdapter myAdapter;
    private Timer timer;
    int index = 0;

    ScalesSniffer() {
    }

    public void startSniffing(ScalesAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Scales adapter should not be null");
        }
        this.myAdapter = adapter;
        int period = 500;
        period = Math.max(this.myAdapter.getRecommendedPollPeriod(), 50);
        this.myAdapter.connectToScales();
        this.timer = new Timer(period, this);
        this.timer.start();
    }

    private void sniffScales() {
        if (this.myAdapter == null) {
            this.readScales.emit((Object)new ScalesResponse(ScalesStatus.Unreachable, null));
        } else {
            this.readScales.emit((Object)this.myAdapter.getMeasurement());
        }
    }

    public void stopSniffing() {
        if (this.myAdapter != null) {
            this.myAdapter.disconnectFromScales();
        }
        this.myAdapter = null;
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.sniffScales();
    }
}

