/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectWeight;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JLabel;
import ordermate.database.hardware.physical.scales.ScalesStatus;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

class SelectWeightNavBar
extends NavBar {
    Signal manualEntry = Signals.createSignal();
    private JButton manuallyEnterWeightButton;

    public SelectWeightNavBar() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.manuallyEnterWeightButton = this.constructButton(IconLoader.get((String)"/waitermate/images/kcalc.png"), Internationalization.getLiteralFor((String)"MAUNAL_ENTRY"), "manualEntry", this.manualEntry);
        this.addLeft(this.getCancelButton());
        this.addLeft(this.manuallyEnterWeightButton);
        this.addRight(this.getOkButton());
        this.setText(Internationalization.getLiteralFor((String)"GETTING_WEIGHT_FROM_SCALES"));
    }

    void enableManualEntryButton(boolean value) {
        this.manuallyEnterWeightButton.setEnabled(value);
    }

    void setStatus(ScalesStatus status) {
        JLabel statusLabel = this.getCentreLabel();
        if (status.equals((Object)ScalesStatus.OK)) {
            statusLabel.setText(Internationalization.getLiteralFor((String)"WEIGHT_DETERMINED"));
            statusLabel.setForeground(Color.GREEN);
        } else if (status.equals((Object)ScalesStatus.Zero)) {
            statusLabel.setText(Internationalization.getLiteralFor((String)"PLEASE_PLACE_THE_ITEM_ON_THE_SCALES"));
            statusLabel.setForeground(null);
        } else if (status.equals((Object)ScalesStatus.Unstable)) {
            statusLabel.setText(Internationalization.getLiteralFor((String)"GETTING_WEIGHT_VALUE"));
            statusLabel.setForeground(Color.GRAY);
        } else if (status.equals((Object)ScalesStatus.Unreachable)) {
            statusLabel.setText(Internationalization.getLiteralFor((String)"SCALES_ARE_UNREACHABLE"));
            statusLabel.setForeground(Color.ORANGE);
        } else if (status.equals((Object)ScalesStatus.Unlevel)) {
            statusLabel.setText(Internationalization.getLiteralFor((String)"SCALES_ARE_UNLEVEL"));
            statusLabel.setForeground(Color.YELLOW);
        } else {
            statusLabel.setForeground(Color.RED);
            if (status.equals((Object)ScalesStatus.Minus)) {
                statusLabel.setText(Internationalization.getLiteralFor((String)"NEGATIVE_VALUE_ON_SCALES"));
            } else if (status.equals((Object)ScalesStatus.Overload)) {
                statusLabel.setText(Internationalization.getLiteralFor((String)"SCALES_ARE_OVERLOADED"));
            } else {
                statusLabel.setText(Internationalization.getLiteralFor((String)"GENERAL_SCALES_ERROR_SEE_LOGS"));
            }
        }
        statusLabel.validate();
        statusLabel.repaint();
    }
}

