/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectcomboitems;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItemHelper;
import ordermate.gui.ordering.OrderComboHelper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.additems.selectcomboitems.SelectComboItemsPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class SelectComboItems
extends AbstractScreen {
    public final Signal itemSelected;
    public final Signal back = Signals.createSignal();
    public final Signal ok = Signals.createSignal();
    public final Signal clear = Signals.createSignal(InventoryComboGroup.class, (String)"selected group");
    private NavBar nav;
    private JComponent gui;
    private final SelectComboItemsPanel panel;
    private WaitermateGuiHandler guiHandler = new WaitermateGuiHandler();
    private OrderComboHelper comboHelper = new OrderComboHelper((GuiHandler)this.guiHandler);
    private InventoryCombo currentCombo;
    private Map<InventoryComboGroup, List<SalesItem>> orderedItemMap;
    private List<SalesItem> forcedItems;
    private boolean isClickedOk;

    public SelectComboItems() {
        this.panel = new SelectComboItemsPanel();
        this.gui = new NameDecorator((JComponent)this.panel, "selectComboItems");
        new JPanel().add(this.gui);
        this.itemSelected = this.panel.itemSelected;
        this.panel.tabChanged.connect((Object)this, "gotTabChanged");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        JButton selectNone = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/selectNone.png"), Internationalization.getLiteralFor((String)"CLEAR_ITEMS"), "Clear items");
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectComboItems.this.clear.emit((Object)SelectComboItems.this.panel.getSelectedGroup());
            }
        });
        this.nav.addRight((Component)selectNone);
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.back.connect(this.back);
        this.nav.ok.connect(this.ok);
    }

    public void start(InventoryCombo combo, Map<InventoryComboGroup, List<SalesItem>> orderedItems, List<SalesItem> forcedItemsList, TriggerActivationContext activationContext) {
        this.isClickedOk = false;
        this.orderedItemMap = new LinkedHashMap<InventoryComboGroup, List<SalesItem>>(orderedItems);
        this.forcedItems = new ArrayList<SalesItem>(forcedItemsList);
        this.currentCombo = combo;
        this.nav.getOkButton().setEnabled(false);
        this.orderedItemMap.clear();
        this.panel.clearComboGroups();
        this.panel.setQuantityVisible(Terminal.getLocalHost().getHasMenuKeypad());
        this.panel.setTriggerActivationContext(activationContext);
        boolean multipleSingleItemGroups = combo.hasOnlyOneSingleItemGroupWithOption(activationContext);
        InventoryComboGroup singleItemGroup = null;
        boolean hasChoices = false;
        ArrayList<SalesItem> allForcedItems = new ArrayList<SalesItem>(this.forcedItems);
        for (InventoryComboGroup group : combo.getGroups()) {
            this.orderedItemMap.put(group, new ArrayList());
            this.comboHelper.addItemsToGroupMap(this.orderedItemMap, allForcedItems);
            this.panel.addComboGroup(group, this.orderedItemMap.get(group));
            if (group.matchesItemsAtMaxQuantity(this.orderedItemMap.get(group))) continue;
            if (group.hasSingleItemWithChoices(activationContext) && !multipleSingleItemGroups) {
                singleItemGroup = group;
                continue;
            }
            hasChoices |= group.hasChoices(activationContext);
        }
        this.comboHelper.addItemsToGroupMap(this.orderedItemMap, this.forcedItems);
        this.comboHelper.orderDefaultItems(this.orderedItemMap, activationContext);
        this.panel.selectIncompleteTab(this.getOrderedItems());
        this.updatedOrderedItems(this.orderedItemMap);
        orderedItems.clear();
        orderedItems.putAll(this.orderedItemMap);
        if (hasChoices) {
            this.display();
        } else if (singleItemGroup != null) {
            this.panel.itemSelected.emit((Object)((InventoryItemUnit)singleItemGroup.getItemUnits().get(0)).getItem(), (Object)singleItemGroup);
        } else if (!this.isClickedOk) {
            this.clickOk();
        }
    }

    public void updatedOrderedItems(Map<InventoryComboGroup, List<SalesItem>> orderedItems) {
        this.orderedItemMap = new LinkedHashMap<InventoryComboGroup, List<SalesItem>>(orderedItems);
        this.panel.updatedOrderedItems(this.orderedItemMap);
        this.nav.getOkButton().setEnabled(this.currentCombo.matchesItems(this.getOrderedItems()));
        this.updateStatusMsg();
    }

    private boolean checkHasForcedItems() {
        boolean allContains = true;
        ArrayList<SalesItem> localForcedItems = new ArrayList<SalesItem>(this.forcedItems);
        for (InventoryComboGroup group : this.currentCombo.getGroups()) {
            List subForcedList;
            if (!this.orderedItemMap.containsKey(group) || (subForcedList = group.getMatchedItems(localForcedItems)) == null || subForcedList.isEmpty()) continue;
            allContains = allContains && SalesLineItemHelper.containsAllIsEquivalentTo(this.orderedItemMap.get(group), (List)subForcedList);
            localForcedItems.removeAll(subForcedList);
        }
        return allContains;
    }

    public void updateStatusMsg() {
        String statusMsg = this.panel.getSelectedTabStatusMsg();
        if (this.nav.getOkButton().isEnabled()) {
            statusMsg = Internationalization.getLiteralFor((String)"PRESS_OK_OR") + " " + statusMsg;
        }
        this.nav.setText(statusMsg);
    }

    public void gotTabChanged() {
        this.updateStatusMsg();
    }

    public SalesQuantity getQuantity() {
        return this.panel.getQuantity();
    }

    public void setQuantity(SalesQuantity quantity) {
        this.panel.setQuantity(quantity);
    }

    public boolean getIncrementQuantityFlag() {
        return this.panel.getIncrementQuantityFlag();
    }

    public void setIncrementQuantityFlag(boolean increment) {
        this.panel.setIncrementQuantityFlag(increment);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void clickOk() {
        this.isClickedOk = true;
        this.nav.ok.emit();
    }

    public boolean hasChoices() {
        if (this.currentCombo == null) {
            return true;
        }
        if (!this.areAllItemsChosen(this.currentCombo.getGroups())) {
            return true;
        }
        for (InventoryComboGroup group : this.currentCombo.getGroups()) {
            if (group.hasSingleItemChoice()) continue;
            return true;
        }
        return false;
    }

    public boolean areAllItemsChosen(List<InventoryComboGroup> groups) {
        for (InventoryComboGroup group : groups) {
            if (this.panel.isTabGroupChosen(group)) continue;
            return false;
        }
        return true;
    }

    public InventoryComboGroup getSelectedTabGroup() {
        return this.panel.getSelectedGroup();
    }

    public List<SalesItem> getOrderedItems() {
        return new OrderComboHelper((GuiHandler)new WaitermateGuiHandler()).getAllItemsFromMap(this.orderedItemMap);
    }

    public Map<InventoryComboGroup, List<SalesItem>> getOrderedItemsSortedByGroup() {
        return this.orderedItemMap;
    }

    public void setOrderedItemsSortedByGroup(Map<InventoryComboGroup, List<SalesItem>> newMap) {
        this.orderedItemMap = newMap;
    }
}

