/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectcomboitems;

import au.com.ordermate.units.SalesQuantity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.OrderedQuantity;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.searchers.inventoryitem.InventoryItemSearcher;
import ordermate.gui.BorderUtils;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.additems.search.InventoryItemSearchPanel;
import waitermate.gui.displayitems.SelectComboItemButtonRenderer;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.guikit.dialogs.KeypadDialog;

public class SelectComboItemsPanel
extends JPanel {
    public final Signal<InventoryItem, InventoryComboGroup, ?, ?, ?> itemSelected = Signals.createSignal(InventoryItem.class, (String)"selected item", InventoryComboGroup.class, (String)"from combo group");
    public final Signal tabChanged = Signals.createSignal();
    private static final String STATUS_CAN_ORDER_MORE = Internationalization.getLiteralFor((String)"SELECT_AN_ITEM_TO_ADD");
    private static final String STATUS_CANNOT_ORDER_MORE = Internationalization.getLiteralFor((String)"SELECT_AN_ITEM_TO_REMOVE");
    private static final String STATUS_NOT_ENOUGH_ITEMS = Internationalization.getLiteralFor((String)"NOT_ENOUGH_ITEMS_ORDERED");
    private static final String STATUS_TOO_MANY_ITEMS = Internationalization.getLiteralFor((String)"TOO_MANY_ITEMS_ORDERED");
    private static final int MAX_ITEMS_IN_SIMPLE_GROUP = 128;
    private List<String> tabStatus = new ArrayList<String>();
    private TriggerActivationContext activationContext;
    private JTabbedPane tabs;
    private KeypadDialog quantityKeypad;
    private Map<InventoryComboGroup, SelectItemButtonRenderer> renderers;
    private List<RendererScrollPaneModel> models = new ArrayList<RendererScrollPaneModel>();
    private List<InventoryComboGroup> indexedTabComboGroup;
    private int selectedIndex = 0;
    private int rows = 4;
    private int columns = 4;

    public SelectComboItemsPanel() {
        super(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JTabbedPane pane = (JTabbedPane)event.getSource();
                if (SelectComboItemsPanel.this.selectedIndex != pane.getSelectedIndex()) {
                    SelectComboItemsPanel.this.selectedIndex = pane.getSelectedIndex();
                    SelectComboItemsPanel.this.tabChanged.emit();
                }
            }
        });
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.tabs, (boolean)false);
        this.tabs.setFont(OrderMateTheme.getLargeFont());
        this.quantityKeypad = new KeypadDialog(new Keypad.HorizontalKeypadBuilder().build(), 1);
        this.quantityKeypad.setUnits(Internationalization.getLiteralFor((String)"QTY_COLON"));
        this.quantityKeypad.setVisible(false);
        BorderUtils.addEmptyBorder((JComponent)this.quantityKeypad);
        this.add((Component)this.quantityKeypad, "North");
        this.add((Component)this.tabs, "Center");
    }

    public void clearComboGroups() {
        this.tabs.removeAll();
        this.renderers = new HashMap<InventoryComboGroup, SelectItemButtonRenderer>();
        this.models = new ArrayList<RendererScrollPaneModel>();
        this.indexedTabComboGroup = new ArrayList<InventoryComboGroup>();
        this.quantityKeypad.setup(false);
        this.quantityKeypad.setValue("1");
    }

    protected void setTriggerActivationContext(TriggerActivationContext context) {
        this.activationContext = context;
    }

    public void addComboGroup(InventoryComboGroup comboGroup, List<? extends SalesLineItem> orderedItems) {
        if (comboGroup.getActiveItems().size() < 128) {
            this.addSimpleComboGroup(comboGroup, orderedItems);
        } else {
            this.addItemSearchComboGroup(comboGroup, orderedItems);
        }
    }

    private void addItemSearchComboGroup(InventoryComboGroup comboGroup, List<? extends SalesLineItem> orderedItems) {
        InventoryItemSearchPanel panel = new InventoryItemSearchPanel(new InventoryItemSearcher(), false);
        panel.startSearch(comboGroup.getActiveItems(), null, true);
        panel.objectSelected.connect((Object)this, "gotInventoryItem");
        this.addComboGroupPanel(panel, comboGroup, orderedItems);
    }

    private void addComboGroupPanel(JPanel panel, InventoryComboGroup comboGroup, List<? extends SalesLineItem> orderedItems) {
        this.tabs.addTab(comboGroup.getLabel(), panel);
        if (!comboGroup.matchesItems(orderedItems)) {
            this.tabs.setForegroundAt(this.tabs.getTabCount() - 1, Color.RED);
        }
        this.indexedTabComboGroup.add(this.tabs.getTabCount() - 1, comboGroup);
    }

    private void addSimpleComboGroup(InventoryComboGroup comboGroup, List<? extends SalesLineItem> orderedItems) {
        SelectComboItemButtonRenderer renderer = new SelectComboItemButtonRenderer(true, comboGroup);
        renderer.itemSelected.connect((Object)this, "gotInventoryItem");
        this.renderers.put(comboGroup, renderer);
        RendererScrollPaneModel model = new RendererScrollPaneModel((Renderer)renderer, this.columns, this.rows);
        model.setObjects(comboGroup.getActiveItems());
        this.models.add(model);
        OrderedQuantity newOrderedQuantity = new OrderedQuantity(orderedItems, true);
        renderer.setOrderedQuantities(newOrderedQuantity, new OrderedQuantity());
        CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)model);
        scrollPane.setName("itemsScroll");
        scrollPane.setColumns(this.columns);
        scrollPane.setRowsPerPage(this.rows);
        scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_ITEMS_IN_THIS_GROUP"));
        this.addComboGroupPanel((JPanel)scrollPane, comboGroup, orderedItems);
        this.setSelectedTab(comboGroup);
        if (!comboGroup.hasChoices(this.activationContext)) {
            SalesQuantity orderedItemsTotal = this.getOrderedItemsListQty(orderedItems);
            SalesQuantity difference = comboGroup.getMinQuantity().subtract(orderedItemsTotal);
            if (difference.greaterThan(0L)) {
                this.quantityKeypad.setValue(difference.toString());
                this.itemSelected.emit(comboGroup.getActiveItems().get(0), (Object)comboGroup);
                this.quantityKeypad.setValue("1");
            }
        }
    }

    private SalesQuantity getOrderedItemsListQty(List<? extends SalesLineItem> orderedItems) {
        SalesQuantity toReturn = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : orderedItems) {
            toReturn = toReturn.add(salesLineItem.getQuantity());
        }
        return toReturn;
    }

    public void setRows(Integer row) {
        this.setRowsPerPage(row);
    }

    public void setRowsPerPage(Integer row) {
        this.rows = row;
        if (this.models != null) {
            for (RendererScrollPaneModel model : this.models) {
                model.setRowsPerPage(this.rows);
            }
        }
    }

    public void setColumns(Integer col) {
        this.columns = col;
        for (RendererScrollPaneModel model : this.models) {
            model.setColumns(this.columns);
        }
    }

    public void updatedOrderedItems(Map<InventoryComboGroup, List<SalesItem>> orderedItems) {
        this.tabStatus = new ArrayList<String>(this.tabs.getTabCount());
        this.quantityKeypad.setup(false);
        this.quantityKeypad.setValue("1");
        this.quantityKeypad.setFirstPressQuantityFlag(true);
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            SalesQuantity totalQty;
            InventoryComboGroup group = this.indexedTabComboGroup.get(i);
            if (!orderedItems.containsKey(group)) {
                orderedItems.put(group, new ArrayList());
            }
            OrderedQuantity newOrderedQuantity = new OrderedQuantity(orderedItems.get(group), true);
            if (this.renderers.get(group) != null) {
                this.renderers.get(group).setOrderedQuantities(newOrderedQuantity, new OrderedQuantity());
            }
            if ((totalQty = group.getMatchItemsTotalQuantity(orderedItems.get(group))).equals(group.getMaxQuantity())) {
                this.tabs.setForegroundAt(i, OrderMateTheme.getDefaultTextColor());
                this.tabStatus.add(i, STATUS_CANNOT_ORDER_MORE);
                continue;
            }
            if (totalQty.greaterThanOrEquals(group.getMinQuantity()) && totalQty.lessThan(group.getMaxQuantity())) {
                this.tabs.setForegroundAt(i, OrderMateTheme.getDefaultTextColor());
                this.tabStatus.add(i, STATUS_CAN_ORDER_MORE);
                continue;
            }
            if (totalQty.lessThan(group.getMinQuantity())) {
                this.tabs.setForegroundAt(i, Color.RED);
                this.tabStatus.add(i, STATUS_NOT_ENOUGH_ITEMS + "  " + STATUS_CAN_ORDER_MORE);
                continue;
            }
            if (totalQty.greaterThan(group.getMaxQuantity())) {
                this.tabs.setForegroundAt(i, Color.RED);
                this.tabStatus.add(i, STATUS_TOO_MANY_ITEMS + "  " + STATUS_CANNOT_ORDER_MORE);
                continue;
            }
            throw new IllegalStateException("logic error, all cases should be covered, should not get to this case.");
        }
        for (RendererScrollPaneModel model : this.models) {
            model.refresh();
        }
    }

    public String getSelectedTabStatusMsg() {
        return this.getTabStatus(this.tabs.getSelectedIndex());
    }

    public String getTabStatus(int index) {
        if (index >= 0 && index < this.tabStatus.size()) {
            return this.tabStatus.get(index);
        }
        return "";
    }

    public boolean isTabGroupChosen(InventoryComboGroup group) {
        if (this.indexedTabComboGroup.indexOf(group) == -1) {
            return false;
        }
        return this.getTabStatus(this.indexedTabComboGroup.indexOf(group)).equals(STATUS_CANNOT_ORDER_MORE);
    }

    public void selectIncompleteTab(List<? extends SalesLineItem> orderedItems) {
        InventoryComboGroup group;
        int i;
        for (i = 0; i < this.tabs.getTabCount(); ++i) {
            group = this.indexedTabComboGroup.get(i);
            if (group.matchesItems(orderedItems)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        for (i = 0; i < this.tabs.getTabCount(); ++i) {
            group = this.indexedTabComboGroup.get(i);
            if (!group.getMinQuantity().equals(0L)) continue;
            this.tabs.setSelectedIndex(i);
        }
    }

    public boolean hasIncompleteTab(List<? extends SalesLineItem> orderedItems) {
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            InventoryComboGroup group = this.indexedTabComboGroup.get(i);
            if (group.matchesItems(orderedItems)) continue;
            return true;
        }
        return false;
    }

    public void setQuantityVisible(boolean visible) {
        this.quantityKeypad.setVisible(visible);
    }

    public SalesQuantity getQuantity() {
        return new SalesQuantity(this.quantityKeypad.getValueAsBigDecimal());
    }

    public void setQuantity(SalesQuantity quantity) {
        this.quantityKeypad.setValue("" + quantity);
    }

    public boolean getIncrementQuantityFlag() {
        return this.quantityKeypad.getFirstPressQuantityFlag();
    }

    public void setIncrementQuantityFlag(boolean increment) {
        this.quantityKeypad.setFirstPressQuantityFlag(increment);
    }

    public InventoryComboGroup getSelectedGroup() {
        return this.indexedTabComboGroup.get(this.tabs.getSelectedIndex());
    }

    void gotInventoryItem(InventoryItem selected) {
        this.itemSelected.emit((Object)selected, (Object)this.getSelectedGroup());
    }

    private void setSelectedTab(InventoryComboGroup group) {
        this.tabs.setSelectedIndex(this.indexedTabComboGroup.indexOf(group));
    }
}

