/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectitem;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.units.SalesQuantity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesLineItem;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.WaiterMate;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.SimpleMenuItemSelectionPanel;
import waitermate.guikit.dialogs.Dialogs;

public class MultipleMenuItemSelectionPanel
extends AbstractMenuItemSelectionPanel {
    private final SimpleMenuItemSelectionPanel menuItemSelection;
    private final SelectItemButtonRenderer menuRenderer;
    private final boolean showTabbedMenu;
    private final SimpleMenuItemSelectionPanel rootGroups;
    private final GroupTabbedPane currentTabbedPane;
    private List<SalesLineItem> orderedItems;
    private List uncomittedItems;
    private TriggerActivationContext currentContext;
    private boolean contextChanged = false;

    public MultipleMenuItemSelectionPanel(SelectItemButtonRenderer itemsRenderer, boolean tabbedMenu) {
        boolean showItemsQuantity = itemsRenderer.isShowItemsQuantity();
        this.menuRenderer = new SelectItemButtonRenderer(showItemsQuantity);
        this.menuItemSelection = new SimpleMenuItemSelectionPanel(this.menuRenderer);
        this.showTabbedMenu = tabbedMenu;
        this.menuItemSelection.groupSelected.connect((Object)this, "showGroup");
        this.itemSelected = this.menuItemSelection.itemSelected;
        this.comboSelected = this.menuItemSelection.comboSelected;
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(4, 1)));
        this.rootGroups = new SimpleMenuItemSelectionPanel(1, 10, new SelectItemButtonRenderer(showItemsQuantity));
        this.rootGroups.setScrollName("menuGroupScroll");
        this.rootGroups.groupSelected.connect((Object)this, "showGroup");
        this.rootGroups.itemSelected.connect((Object)this, "gotItemSelected");
        this.add((Component)new NameDecorator((JComponent)this.rootGroups, "menuGroups"), new Rectangle(0, 0, 1, 1));
        this.currentTabbedPane = new GroupTabbedPane();
        if (!this.showTabbedMenu) {
            this.currentTabbedPane.addTab("", this.menuItemSelection);
        }
        this.add((Component)this.currentTabbedPane, new Rectangle(1, 0, 3, 1));
    }

    @Override
    public void setRowsPerPage(int rowsPerPage) {
        this.menuItemSelection.setRowsPerPage(rowsPerPage);
    }

    @Override
    public void setColumns(int columns) {
        this.menuItemSelection.setColumns(columns);
    }

    @Override
    public InventoryGroup getInventoryGroup() {
        return this.menuItemSelection.getInventoryGroup();
    }

    void gotItemSelected(InventoryItem item) {
        this.itemSelected.emit((Object)item);
    }

    @Override
    public boolean getFirstPressQuantityFlag() {
        return this.menuItemSelection.getFirstPressQuantityFlag();
    }

    @Override
    public SalesQuantity getQuantity() {
        return this.menuItemSelection.getQuantity();
    }

    @Override
    public int getSeat() {
        return this.menuItemSelection.getSeat();
    }

    @Override
    public void setNumKeypadVisible(boolean showQuantity) {
        this.menuItemSelection.setNumKeypadVisible(showQuantity);
    }

    @Override
    public void setSeatPanelVisible(boolean display) {
        this.menuItemSelection.setSeatPanelVisible(display);
    }

    @Override
    public void setupSeatsPanel(int numSeats, int selectedSeat) {
        this.menuItemSelection.setupSeatsPanel(numSeats, selectedSeat);
    }

    public void showRootGroup(TriggerActivationContext context, List newOrderedItems, List newUncommitedItems) {
        this.currentContext = context;
        InventoryProfile profile = InventoryProfile.getProfile((AccountType)this.currentContext.getAccount().getAccountType(), (Terminal)Terminal.getLocalHost());
        if (profile == null) {
            if (context.getAccount().allowsOrderingItems()) {
                Dialogs.displayOkDialog((String)("<html><p align='center'>" + Internationalization.getLiteralFor((String)"THERE_IS_NO_MENU_PROFILE_ASSIGNED_TO_THIS_ACCOUNT_TYPE") + "</html>"), (String)Internationalization.getLiteralFor((String)"NO_PROFILE_SETUP"));
            }
        } else {
            this.orderedItems = new ArrayList<SalesLineItem>(newOrderedItems);
            this.uncomittedItems = newUncommitedItems == null ? null : new ArrayList(newUncommitedItems);
            List menuGroups = profile.getActiveProfileGroups(this.currentContext);
            if (menuGroups.isEmpty()) {
                Dialogs.displayOkDialog((String)("<html><p align='centre'>" + Internationalization.getLiteralFor((String)"THERE_ARE_NO_ACTIVE_MENU_SECTIONS_FOR_THIS_ACCOUNT_TYPE") + "</html>"), (String)Internationalization.getLiteralFor((String)"NO_ACTIVE_MENU_SECTIONS"));
                return;
            }
            InventoryGroup firstGroup = (InventoryGroup)menuGroups.get(0);
            if (this.orderedItems.isEmpty()) {
                this.showGroup(this.currentContext, firstGroup);
            } else {
                SalesLineItem lastItem = this.orderedItems.get(this.orderedItems.size() - 1);
                if (lastItem.getMenuGroup() != null) {
                    InventoryGroup lastGroup = lastItem.getMenuGroup();
                    if (profile.isInventoryGroupsPreloaded()) {
                        lastGroup = profile.getCachedGroup(lastGroup);
                    } else {
                        InventoryProfile.cacheMenuGroups((Terminal)Terminal.getLocalHost()).run();
                    }
                    this.showGroup(this.currentContext, lastGroup);
                } else {
                    if (Config.isDebuging()) {
                        throw new IllegalStateException("The " + lastItem + " has a null menu group.");
                    }
                    this.showGroup(this.currentContext, firstGroup);
                }
            }
        }
    }

    public void showGroup(InventoryGroup theGroup) {
        this.showGroup(this.currentContext, theGroup);
    }

    @Override
    public void showGroup(TriggerActivationContext context, InventoryGroup theGroup, List<SalesLineItem> newOrderedItems, List<SalesLineItem> newUncommitedItems) {
        this.orderedItems = newOrderedItems;
        this.uncomittedItems = newUncommitedItems;
        this.showGroup(context, theGroup);
    }

    private void showGroup(TriggerActivationContext context, InventoryGroup group) {
        if (this.currentContext != context) {
            this.currentContext = context;
            this.contextChanged = true;
        }
        if (group == null) {
            if (Config.isDebuging()) {
                throw new IllegalStateException("Attempt to show null root group.");
            }
            WaiterMate.LOG.warn("Attempt to show null root group.");
            return;
        }
        InventoryGroup selectedGroup = group;
        if (this.showTabbedMenu && !selectedGroup.hasContent() && selectedGroup.hasSubGroups() && selectedGroup.getDepth() == 0) {
            List subGroups = selectedGroup.getSubGroups();
            for (int i = 0; i < subGroups.size(); ++i) {
                if (!((InventoryGroup)subGroups.get(i)).isActive(context)) continue;
                selectedGroup = (InventoryGroup)subGroups.get(i);
                break;
            }
        }
        this.menuRenderer.setCurrentGroup(selectedGroup);
        boolean showSubgroupsAsButtons = !this.showTabbedMenu || !selectedGroup.isTopLevelGroup() && (!selectedGroup.getParentGroup().isTopLevelGroup() || selectedGroup.hasSubGroups());
        this.menuItemSelection.showGroup(context, selectedGroup, this.orderedItems, this.uncomittedItems, showSubgroupsAsButtons);
        InventoryGroup rootGroup = selectedGroup.getRootGroup();
        this.rootGroups.showRootGroup(context, selectedGroup.getProfile(), true, rootGroup, this.orderedItems, this.uncomittedItems);
        if (this.showTabbedMenu) {
            if (this.contextChanged || this.currentTabbedPane.actualRoot == null || !this.currentTabbedPane.actualRoot.equals((Object)rootGroup) || this.currentTabbedPane.getTabCount() == 0 || !this.currentTabbedPane.actualRoot.isParent(selectedGroup)) {
                this.currentTabbedPane.setRootGroup(rootGroup, selectedGroup);
            } else if (this.showTabbedMenu && this.currentTabbedPane.getSelectedGroup() != selectedGroup) {
                this.currentTabbedPane.setSelectedTab(selectedGroup);
            }
        }
        this.contextChanged = false;
    }

    @Override
    public void setGroupTextWidth(int textWidth) {
        this.rootGroups.setGroupTextWidth(textWidth);
        this.menuItemSelection.setGroupTextWidth(textWidth);
    }

    @Override
    public void setItemTextWidth(int textWidth) {
        this.rootGroups.setItemTextWidth(textWidth);
        this.menuItemSelection.setItemTextWidth(textWidth);
    }

    private static class GroupComponent
    extends JPanel {
        private final InventoryGroup group;

        public GroupComponent(InventoryGroup theGroup) {
            super(new BorderLayout());
            if (theGroup == null) {
                throw new IllegalArgumentException("Group cannot be null");
            }
            this.group = theGroup;
        }

        public InventoryGroup getGroup() {
            return this.group;
        }
    }

    private class GroupTabbedPane
    extends JTabbedPane
    implements ChangeListener {
        private InventoryGroup actualRoot = null;

        public GroupTabbedPane() {
            this.setName("menuGroupTab");
            OrderMateTheme.setupTabbedPane((JTabbedPane)this);
            this.setFont(OrderMateTheme.getLargeFont());
        }

        public void setSelectedTab(InventoryGroup selectedGroup) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof GroupComponent) || ((GroupComponent)comp).getGroup() != selectedGroup) continue;
                this.setSelectedComponent(comp);
                break;
            }
        }

        public InventoryGroup getSelectedGroup() {
            return ((GroupComponent)this.getSelectedComponent()).getGroup();
        }

        private void attachMenuItemSelection() {
            if (MultipleMenuItemSelectionPanel.this.menuItemSelection.getParent() != null) {
                MultipleMenuItemSelectionPanel.this.menuItemSelection.getParent().remove(MultipleMenuItemSelectionPanel.this.menuItemSelection);
            }
            if (this.getSelectedIndex() >= 0) {
                ((GroupComponent)this.getSelectedComponent()).add(MultipleMenuItemSelectionPanel.this.menuItemSelection);
            }
        }

        private void setRootGroup(InventoryGroup rootGroup, InventoryGroup selectedGroup) {
            this.actualRoot = rootGroup;
            this.getModel().removeChangeListener(this);
            this.removeAll();
            if (rootGroup.hasContent()) {
                GroupComponent rootComponent = new GroupComponent(rootGroup);
                this.addTab(rootGroup.getLabel(), rootComponent);
                this.setBackgroundAt(0, rootGroup.getBackgroundColor());
                this.setForegroundAt(0, rootGroup.getForegroundColor());
            }
            ArrayList subGroups = new ArrayList(rootGroup.getActiveSubgroups(MultipleMenuItemSelectionPanel.this.currentContext));
            for (int i = 0; i < subGroups.size(); ++i) {
                InventoryGroup subGroup = (InventoryGroup)subGroups.get(i);
                this.addTab(subGroup.getLabel(), new GroupComponent(subGroup));
                this.setBackgroundAt(this.getTabCount() - 1, subGroup.getBackgroundColor());
                this.setForegroundAt(this.getTabCount() - 1, subGroup.getForegroundColor());
                if (selectedGroup != subGroup) continue;
                this.setSelectedIndex(this.getTabCount() - 1);
            }
            this.attachMenuItemSelection();
            this.getModel().addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            InventoryGroup selectedGroup = this.getSelectedGroup();
            MultipleMenuItemSelectionPanel.this.showGroup(MultipleMenuItemSelectionPanel.this.currentContext, selectedGroup);
            this.attachMenuItemSelection();
        }
    }
}

