/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectitem;

import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.screens.ordering.additems.selectitem.AbstractMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.MultipleMenuItemSelectionPanel;
import waitermate.gui.screens.ordering.additems.selectitem.SimpleMenuItemSelectionPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class SelectMenuItem
extends AbstractScreen {
    public final Signal<InventoryItem, ?, ?, ?, ?> itemSelected = Signals.createSignal(InventoryItem.class, (String)"Selected Item");
    public final Signal<InventoryCombo, ?, ?, ?, ?> comboSelected = Signals.createSignal(InventoryCombo.class, (String)"Selected combo");
    public final Signal modifySelected = Signals.createSignal();
    public final Signal back = Signals.createSignal();
    public final Signal ok = Signals.createSignal();
    private final AbstractMenuItemSelectionPanel itemsPanel;
    private final NameDecorator mainArea;
    private final NavBar navPanel;
    private List<SalesLineItem> orderedItems;
    private List<SalesLineItem> uncommitedItems;
    private final AbstractButton modifyButton;
    private ItemGroup currentItemGroup;
    private final boolean tabbed;

    public SelectMenuItem(boolean quickSaleMode) {
        boolean showQuantity = Terminal.getLocalHost().isShowQuantity(quickSaleMode);
        this.tabbed = Terminal.getLocalHost().isTabbedMenuOrdering(quickSaleMode);
        SelectItemButtonRenderer itemsRenderer = new SelectItemButtonRenderer(showQuantity);
        if (this.tabbed) {
            this.itemsPanel = new MultipleMenuItemSelectionPanel(itemsRenderer, this.tabbed);
        } else {
            this.itemsPanel = new SimpleMenuItemSelectionPanel(itemsRenderer);
            this.itemsPanel.groupSelected.connect((Object)this, "gotItemPanelGroupSelected");
        }
        this.mainArea = new NameDecorator((JComponent)this.itemsPanel, "ItemScreen");
        this.navPanel = new NavBar();
        this.modifyButton = this.navPanel.constructButton((Icon)IconLoader.get((String)"/waitermate/images/edit.png"), "<HTML>" + Internationalization.getLiteralFor((String)"MODIFY") + " " + Internationalization.getLiteralFor((String)"AND") + "<BR>" + Internationalization.getLiteralFor((String)"SAVE_LAST") + "</HTML>", "modifyLast", this.modifySelected);
        this.navPanel.addRight((Component)this.modifyButton);
        this.navPanel.addLeft((Component)this.navPanel.getBackButton());
        this.navPanel.addRight((Component)this.navPanel.getOkButton());
        this.navPanel.addRight((Component)this.navPanel.getCancelButton());
        this.navPanel.back.connect((Object)this, "gotBack");
        this.navPanel.cancel.connect(this.back);
        this.navPanel.ok.connect(this.ok);
        this.itemsPanel.itemSelected.connect((Object)this, "gotItem");
        this.itemsPanel.comboSelected.connect((Object)this, "gotCombo");
    }

    public void gotItemPanelGroupSelected(InventoryGroup group) {
        InventoryGroup selectedGroup = group;
        if (this.shouldDisplayFirstSubGroup(selectedGroup)) {
            selectedGroup = (InventoryGroup)selectedGroup.getSubGroups().get(0);
        }
        this.itemsPanel.showGroup(new TriggerActivationContext(LoginManager.getEventContext(), this.currentItemGroup), selectedGroup, this.orderedItems, this.uncommitedItems);
        this.navPanel.getBackButton().setEnabled(true);
        this.navPanel.setText(selectedGroup.getLabelFull());
    }

    public void gotBack() {
        InventoryGroup group = this.itemsPanel.getInventoryGroup();
        if (group == null) {
            this.back.emit();
        } else {
            InventoryGroup previous = group.getParentGroup();
            if (!group.isTopLevelGroup() && !this.shouldDisplayFirstSubGroup(previous)) {
                this.gotItemPanelGroupSelected(previous);
            } else {
                this.back.emit();
            }
        }
    }

    public void selectItem(ItemGroup itemGroup, InventoryGroup group, List<SalesLineItem> newOrderedItems, List<SalesLineItem> newUncommitedItems, boolean showQuantity, boolean showQuickSeatSelect) {
        this.currentItemGroup = itemGroup;
        this.orderedItems = newOrderedItems;
        this.uncommitedItems = newUncommitedItems;
        this.itemsPanel.showGroup(new TriggerActivationContext(LoginManager.getEventContext(), new Date(), itemGroup), group, this.orderedItems, this.uncommitedItems);
        this.itemsPanel.setNumKeypadVisible(showQuantity);
        this.itemsPanel.setSeatPanelVisible(showQuickSeatSelect);
        this.navPanel.getBackButton().setEnabled(true);
        this.modifyButton.setEnabled(this.orderedItems.size() > 0);
        this.navPanel.setText(group.getLabelFull());
        this.navPanel.getOkButton().setVisible(true);
        this.navPanel.getCancelButton().setVisible(true);
        this.display();
    }

    public SalesQuantity getQuantity() {
        return this.itemsPanel.getQuantity();
    }

    public boolean getIncrementQuantityFlag() {
        return this.itemsPanel.getFirstPressQuantityFlag();
    }

    public void gotItem(InventoryItem theItem) {
        this.doValidateModifyLastButtonState(true);
        this.itemSelected.emit((Object)theItem);
    }

    public void gotCombo(InventoryCombo theCombo) {
        this.doValidateModifyLastButtonState(true);
        this.comboSelected.emit((Object)theCombo);
    }

    public JComponent getMainArea() {
        return this.mainArea;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    public void setupSeatsPanel(int numPatrons, int selectedSeat) {
        this.itemsPanel.setupSeatsPanel(numPatrons, selectedSeat);
    }

    public int getSelectedSeat() {
        return this.itemsPanel.getSeat();
    }

    public InventoryGroup getInventoryGroup() {
        return this.itemsPanel.getInventoryGroup();
    }

    private void doValidateModifyLastButtonState(boolean enableIt) {
        this.modifyButton.setVisible(Terminal.getLocalHost().getStickyMenu());
        this.modifyButton.setEnabled(enableIt);
    }

    public void refreshGroups() {
        InventoryGroup group = this.getInventoryGroup();
        if (group != null) {
            this.itemsPanel.showGroup(new TriggerActivationContext(LoginManager.getEventContext(), new Date(), this.currentItemGroup), group, this.orderedItems, this.uncommitedItems);
        }
    }

    private boolean shouldDisplayFirstSubGroup(InventoryGroup selectedGroup) {
        return this.tabbed && !selectedGroup.hasContent() && selectedGroup.hasSubGroups();
    }
}

