/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectoptions;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.additems.selectoptions.SelectOptionsGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class SelectOptions
extends AbstractScreen
implements ActionListener {
    public final Signal optionsSelected = Signals.createSignal(List.class, (String)"options");
    public final Signal back = Signals.createSignal();
    private final SelectOptionsGui gui;
    private final NavBar nav;
    private final JButton resetButton;
    private final JButton nextButton;
    private final JButton backButton;
    private final List<InventoryOptionGroupLink> allGroupLinks = new ArrayList<InventoryOptionGroupLink>();
    private SalesComponent component;
    private int currentLink;
    private boolean isAutoSelect = false;
    private final Map<InventoryOptionGroupLink, List<InventoryOption>> selectionsMap = new LinkedHashMap<InventoryOptionGroupLink, List<InventoryOption>>();

    public SelectOptions() {
        this.gui = new SelectOptionsGui();
        this.gui.optionSelected.connect((Object)this, "gotOptionSelected");
        this.nav = new NavBar();
        this.resetButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/clear.png"), Internationalization.getLiteralFor((String)"RESET"), "resetButton");
        this.resetButton.addActionListener(this);
        this.nextButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/ok.png"), Internationalization.getLiteralFor((String)"OK"), "nextButton");
        this.nextButton.addActionListener(this);
        this.backButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/back.png"), Internationalization.getLiteralFor((String)"BACK"), "backButton");
        this.backButton.addActionListener(this);
        this.nav.addLeft((Component)this.backButton);
        this.nav.getCancelButton().setEnabled(false);
    }

    public void selectOptions(SalesComponent yourComponent, TriggerActivationContext context, boolean autoSelect) {
        this.component = yourComponent;
        this.isAutoSelect = autoSelect;
        this.allGroupLinks.clear();
        InventoryItemUnit unit = this.component.getUnit();
        List links = unit.getActiveOptionGroupLinks(context);
        for (InventoryOptionGroupLink link : links) {
            if (!link.getOptionGroup().isActive(context)) continue;
            this.allGroupLinks.add(link);
        }
        this.selectionsMap.clear();
        for (InventoryOptionGroupLink link : this.allGroupLinks) {
            this.selectionsMap.put(link, new ArrayList());
        }
        for (SalesOption option : this.component.getCurrentOptions()) {
            for (InventoryOptionGroupLink nextLink : this.selectionsMap.keySet()) {
                if (!nextLink.getOptionGroup().equals((Object)option.getOption().getOptionGroup())) continue;
                this.selectionsMap.get(nextLink).add(option.getOption());
            }
        }
        if (autoSelect) {
            this.autoSelectOptions();
        }
        if (this.allGroupLinks.isEmpty()) {
            this.optionsSelected.emit(this.getSelectedOptions());
            return;
        }
        this.nav.addRight((Component)this.nextButton);
        this.nav.addRight((Component)this.resetButton);
        this.currentLink = -1;
        this.gotNextGroup();
    }

    private void autoSelectOptions() {
        for (InventoryOptionGroupLink link : this.allGroupLinks) {
            List<InventoryOption> options;
            InventoryOptionGroup group = link.getOptionGroup();
            List availableOptions = group.getOptions();
            if (group.getDefaultOption() == null || !availableOptions.contains(group.getDefaultOption()) || !(options = this.selectionsMap.get(link)).isEmpty()) continue;
            options.add(group.getDefaultOption());
        }
    }

    public void gotOptionSelected(InventoryOption theOption, Boolean asAdded) {
        if (Boolean.FALSE.equals(asAdded)) {
            this.removeOption(theOption);
        } else {
            this.addOption((Displayable)theOption);
        }
    }

    private void addOption(Displayable selectedOption) {
        List<InventoryOption> currentSelections;
        InventoryOptionGroupLink groupLink = this.allGroupLinks.get(this.currentLink);
        if (groupLink.isSatisfied(true, currentSelections = this.selectionsMap.get(groupLink))) {
            int index = currentSelections.lastIndexOf(selectedOption);
            if (index < 0) {
                currentSelections.remove(currentSelections.size() - 1);
                currentSelections.add((InventoryOption)selectedOption);
            } else {
                currentSelections.remove(index);
            }
        } else {
            currentSelections.add((InventoryOption)selectedOption);
        }
        this.reevaluate();
    }

    private void removeOption(InventoryOption option) {
        InventoryOptionGroupLink groupLink = this.allGroupLinks.get(this.currentLink);
        List<InventoryOption> currentSelections = this.selectionsMap.get(groupLink);
        int index = currentSelections.lastIndexOf(option);
        if (index >= 0) {
            currentSelections.remove(index);
        }
        this.reevaluate();
    }

    private void reevaluate() {
        InventoryOptionGroupLink groupLink = this.allGroupLinks.get(this.currentLink);
        List<InventoryOption> currentSelections = this.selectionsMap.get(groupLink);
        this.nextButton.setEnabled(groupLink.isSatisfied(false, currentSelections));
        if (this.allGroupLinks.get(this.currentLink).isSatisfied(true, currentSelections)) {
            this.gotNextGroup();
        } else {
            this.nav.getCancelButton().setEnabled(true);
            InventoryOptionGroupLink nextLink = this.allGroupLinks.get(this.currentLink);
            this.displayOptionGroupLink(false, nextLink);
        }
    }

    void gotBack() {
        InventoryOptionGroupLink displayLink = null;
        while (displayLink == null && this.currentLink >= 0) {
            if (this.currentLink == 0) {
                this.nav.back.emit();
                this.back.emit();
                break;
            }
            --this.currentLink;
            displayLink = this.allGroupLinks.get(this.currentLink);
        }
        if (displayLink != null) {
            this.displayOptionGroupLink(true, displayLink);
        }
    }

    private void gotNextGroup() {
        InventoryOptionGroupLink displayLink = null;
        while (displayLink == null && this.currentLink < this.allGroupLinks.size()) {
            if (this.currentLink == this.allGroupLinks.size() - 1) {
                this.nav.ok.emit();
                this.optionsSelected.emit(this.getSelectedOptions());
                break;
            }
            ++this.currentLink;
            displayLink = this.allGroupLinks.get(this.currentLink);
            if (!this.isAutoSelect || this.selectionsMap.get(displayLink).isEmpty() || !displayLink.isSatisfied(false, this.selectionsMap.get(displayLink))) continue;
            displayLink = null;
        }
        if (displayLink != null) {
            this.displayOptionGroupLink(true, displayLink);
        }
    }

    void gotResetOption() {
        if (this.selectionsMap.isEmpty()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"NO_OPTIONS_SELECTED_TO_CANCEL"), (String)Internationalization.getLiteralFor((String)"THERE_ARE_NO_OPTIONS_SELECTED_TO_CANCEL"));
            return;
        }
        List<InventoryOption> currentGroupOptions = this.selectionsMap.get(this.allGroupLinks.get(this.currentLink));
        currentGroupOptions.clear();
        this.nav.getCancelButton().setEnabled(false);
        this.displayOptionGroupLink(true, this.allGroupLinks.get(this.currentLink));
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    private List<InventoryOption> getSelectedOptions() {
        ArrayList<InventoryOption> allOptions = new ArrayList<InventoryOption>();
        for (List<InventoryOption> groupElements : this.selectionsMap.values()) {
            allOptions.addAll(groupElements);
        }
        return allOptions;
    }

    private void displayOptionGroupLink(boolean reset, InventoryOptionGroupLink optionGroupLink) {
        InventoryOptionGroup group = optionGroupLink.getOptionGroup();
        if (optionGroupLink.isForcedChoice()) {
            List<InventoryOption> currentSelections = this.selectionsMap.get(optionGroupLink);
            if (!currentSelections.contains(group.getOptions().get(0))) {
                this.addOption((Displayable)group.getOptions().get(0));
            } else {
                this.reevaluate();
            }
            return;
        }
        if (reset) {
            this.gui.reset();
        }
        this.gui.setOptions(optionGroupLink, this.selectionsMap.get(optionGroupLink));
        this.nav.setText(this.getLabelFor(optionGroupLink));
        this.display(false);
        this.nextButton.setEnabled(optionGroupLink.isSatisfied(false, this.selectionsMap.get(optionGroupLink)));
    }

    private String getLabelFor(InventoryOptionGroupLink optionGroupLink) {
        StringBuilder SB = new StringBuilder("Select ");
        int min = optionGroupLink.getMinQty();
        int max = optionGroupLink.getMaxQty();
        if (optionGroupLink.hasRealMaximum()) {
            if (min == max) {
                SB.append(min);
            } else if (min <= 0) {
                SB.append("up to ").append(max);
            } else if (max - min == 1) {
                SB.append(min).append(" or ").append(max);
            } else {
                SB.append("from ").append(min).append(" to ").append(max);
            }
        } else if (min > 0) {
            SB.append("at least ").append(min);
        } else {
            SB.append("any");
        }
        SB.append(" ").append(optionGroupLink.getOptionGroup().getLabel());
        return SB.toString();
    }

    private InventoryOptionGroupLink getCurrentLink() {
        return this.allGroupLinks.get(this.currentLink);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.resetButton) {
            this.gotResetOption();
        } else if (source == this.nextButton) {
            this.gotNextGroup();
        } else if (source == this.backButton) {
            this.gotBack();
        }
    }
}

