/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.additems.selectoptions;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.gui.GuiConfig;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.reports.general.StringReport;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class SelectOptionsGui
extends JPanel {
    private final RendererScrollPaneModel<InventoryOption> model;
    private final CustomScrollPane pane;
    private final RendererScrollPaneModel<InventoryOption> selectionsModel;
    private final CustomScrollPane selectionsPane;
    Signal<InventoryOption, Boolean, ?, ?, ?> optionSelected = Signals.createSignal(InventoryOption.class, (String)"selectedOption", Boolean.class, (String)"added");
    private InventoryOption lastOption;
    private InventoryOptionGroupLink currentLink;

    public SelectOptionsGui() {
        super((LayoutManager)new GraphPaperLayout(10, 10));
        this.setName("selectOptions");
        this.model = new RendererScrollPaneModel((Renderer)new OptionRenderer(), 3, 5);
        this.pane = new CustomScrollPane(this.model);
        this.pane.setName("itemOptions");
        this.pane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_OPTIONS_FOR_THIS_ITEM"));
        StringReport rows = (StringReport)PersistenceManager.getObject(StringReport.class, (String)Query.select((PropertiedObject.Property)GuiConfig.Properties.VALUE, (String)"value").select(GuiConfig.Properties.ID, "ID").equals(GuiConfig.Properties.COMPONENT, (Object)GuiConfigManager.CompStrings.ITEM_OPTIONS.toString()).equals(GuiConfig.Properties.GUI_CONFIG_SET, (Object)Terminal.getLocalHost().getScreenLayoutSet()).toString());
        int numRows = 6;
        if (rows != null && rows.getValue() != null) {
            try {
                numRows = Integer.parseInt(rows.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selectionsModel = new RendererScrollPaneModel((Renderer)new SelectedOptionRenderer(), 1, numRows);
        this.selectionsPane = new CustomScrollPane(this.selectionsModel);
        this.selectionsPane.setDecorationLocation(DecoratorLocation.NorthSouth);
        this.selectionsPane.setName("selectedOptions");
        this.add((Component)new NameDecorator((JComponent)this.pane, GuiConfigManager.CompStrings.ITEM_OPTIONS.toString()), new Rectangle(0, 0, 8, 10));
        this.add((Component)this.selectionsPane, new Rectangle(8, 0, 2, 10));
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.pane.setRowsPerPage(rowsPerPage);
    }

    public void setColumns(int columns) {
        this.pane.setColumns(columns);
        this.selectionsPane.setColumns(columns);
    }

    void setOptions(InventoryOptionGroupLink link, List<InventoryOption> selections) {
        this.selectionsModel.setObjects(selections);
        if (this.currentLink == null || !this.currentLink.equals((Object)link)) {
            this.currentLink = link;
            this.model.setObjects(link.getOptionGroup().getOptions());
            this.selectionsModel.setObjects(selections);
        } else {
            this.selectionsModel.setObjects(selections);
            this.model.getComponent((Displayable)this.lastOption);
        }
    }

    public void reset() {
        this.currentLink = null;
        this.lastOption = null;
    }

    private class SelectedOptionRenderer
    implements Renderer {
        private final Color REDUCED = new Color(230, 255, 230);
        private final Color STANDARD = Color.LIGHT_GRAY;

        private SelectedOptionRenderer() {
        }

        public Component createComponent() {
            CustomButton button = new CustomButton();
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomButton source = (CustomButton)e.getSource();
                    Displayable data = source.getData();
                    if (data instanceof InventoryOption) {
                        SelectOptionsGui.this.lastOption = (InventoryOption)data;
                        SelectOptionsGui.this.optionSelected.emit((Object)SelectOptionsGui.this.lastOption, (Object)Boolean.FALSE);
                    }
                }
            });
            return button;
        }

        public void setupComponent(Component component, Object object, int index) {
            Price price;
            InventoryOption theOption = (InventoryOption)object;
            CustomButton button = (CustomButton)component;
            button.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
            OrderMateTheme.setupUntoggledButton((AbstractButton)button);
            button.setData((Displayable)theOption);
            StringBuilder SB = new StringBuilder("<html>").append(theOption.getLabel());
            if (SelectOptionsGui.this.currentLink != null && index < SelectOptionsGui.this.currentLink.getReducedZone()) {
                button.setBackground(this.REDUCED);
                price = theOption.getReducedPrice();
            } else {
                button.setBackground(this.STANDARD);
                price = theOption.getPrice();
            }
            if (!Price.ZERO_DOLLAR.equals((Object)price)) {
                SB.append(" (").append(price).append(")");
            }
            SB.append("</html>");
            button.setText(SB.toString());
        }
    }

    private class OptionRenderer
    implements Renderer {
        private OptionRenderer() {
        }

        public Component createComponent() {
            CustomButton button = new CustomButton();
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomButton source = (CustomButton)e.getSource();
                    Displayable data = source.getData();
                    if (data instanceof InventoryOption) {
                        SelectOptionsGui.this.lastOption = (InventoryOption)data;
                        SelectOptionsGui.this.optionSelected.emit((Object)SelectOptionsGui.this.lastOption, (Object)Boolean.TRUE);
                    }
                }
            });
            return button;
        }

        public void setupComponent(Component component, Object object, int index) {
            InventoryOption theOption = (InventoryOption)object;
            CustomButton button = (CustomButton)component;
            OrderMateTheme.setupUntoggledButton((AbstractButton)button);
            button.setData((Displayable)theOption);
            this.updateButton(button);
        }

        private void updateButton(CustomButton button) {
            InventoryOption theOption = (InventoryOption)button.getData();
            int totalCount = SelectOptionsGui.this.selectionsModel.getSize();
            Price nextPrice = theOption.getPrice();
            if (SelectOptionsGui.this.currentLink != null && totalCount < SelectOptionsGui.this.currentLink.getReducedZone()) {
                nextPrice = theOption.getReducedPrice();
            }
            int redCount = 0;
            int count = 0;
            Price redPrice = theOption.getReducedPrice();
            Price price = theOption.getPrice();
            for (int i = 0; i < SelectOptionsGui.this.selectionsModel.getSize(); ++i) {
                InventoryOption nextOption = (InventoryOption)SelectOptionsGui.this.selectionsModel.getObjects().get(i);
                if (!nextOption.equals((Object)theOption)) continue;
                if (SelectOptionsGui.this.currentLink != null && i < SelectOptionsGui.this.currentLink.getReducedZone()) {
                    ++redCount;
                }
                ++count;
            }
            StringBuilder SB = new StringBuilder("<html>").append(theOption.getLabel());
            if (!Price.ZERO_DOLLAR.equals((Object)nextPrice)) {
                SB.append(" (").append(nextPrice).append(")");
            }
            if (count > 0) {
                if (count > 0) {
                    SB.append("<br>");
                    if (Price.ZERO_DOLLAR.equals((Object)price)) {
                        SB.append("x ").append(count);
                    } else if (!redPrice.equals((Object)price)) {
                        if (redCount > 0) {
                            SB.append("x ").append(redCount).append(" @ ").append(redPrice).append("<br>");
                        }
                        if (count > redCount) {
                            SB.append("x ").append(count - redCount).append(" @ ").append(price);
                        }
                    } else {
                        SB.append("x ").append(count).append(" @ ").append(price);
                    }
                }
                OrderMateTheme.setupToggledButton((AbstractButton)button);
            }
            SB.append("</html>");
            button.setText(SB.toString());
        }
    }
}

