/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon.handlers;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.ComboCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.coupon.ExistingCouponItemsAnalyser;
import ordermate.database.sales.coupon.SalesComboCouponUsage;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.additems.AddItems;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.UpgradeCombo;
import waitermate.gui.screens.ordering.coupon.AbstractCouponRedeemer;
import waitermate.gui.screens.ordering.coupon.handlers.SelectSalesLineItemDialog;
import waitermate.guikit.ScreenResource;

public class WaiterMateComboCouponRedeemer
extends AbstractCouponRedeemer {
    private final Signal upgradeSuccess = Signals.createSignal(SalesLineItem.class, (String)"upgradeSuccess");
    private final Signal upgradeDone = Signals.createSignal();
    private AddItems addItems;
    private SalesLineItem upgradedCombo;

    public WaiterMateComboCouponRedeemer(SalesCoupon coupon, AddItems addItems) {
        super(coupon);
        this.addItems = addItems;
        this.upgradeSuccess.connect((Object)this, "gotUpgradeComboComplete");
        this.upgradeDone.connect((Object)this, "gotUpgradeDone");
    }

    public boolean handleCouponRedemption(TriggerActivationContext theContext) {
        this.context = theContext;
        ComboCoupon comboCoupon = (ComboCoupon)this.getHandledCoupon().getInventoryCoupon();
        ExistingCouponItemsAnalyser itemsAnalyser = comboCoupon.getExistingItemsAnalyser();
        InventoryCombo combo = comboCoupon.getTool().getCombo();
        if (combo != null) {
            List<Object> existingItems = new ArrayList<SalesItem>();
            if (itemsAnalyser.hasEligibleItems(this.context.getAccount().getItems()) && comboCoupon.isUseExistingItems()) {
                List lineItems = itemsAnalyser.getEligibleItems(this.context.getAccount().getItemHelper().getUnpaidItems());
                SelectSalesLineItemDialog dialog = new SelectSalesLineItemDialog(lineItems, "Use Existing Combo Items");
                dialog.setCancelButtonText("Order New Item");
                dialog.startFillTheFrame();
                existingItems = dialog.getSelectedItems();
            }
            if (!existingItems.isEmpty()) {
                this.upgradedCombo = null;
                UpgradeCombo.getInstance().configureSignal(this.upgradeDone);
                UpgradeCombo.getInstance().configureComboSignal(this.upgradeSuccess);
                UpgradeCombo.getInstance().specificUpgradeRequested(existingItems, combo, this.context.getAccount(), (EventContext)this.context);
            } else {
                this.addItems.comboCancel.connect((Object)this, "gotComboCancel");
                this.addItems.comboBack.connect((Object)this, "gotComboCancel");
                this.addItems.comboDone.connect((Object)this, "gotComboDone");
                this.addItems.gotStartAddingCombo(this.context.getAccount(), combo, new OrderedItemDetails(), SalesQuantity.ONE);
            }
            return true;
        }
        OrderMate.LOG.error("Cannot resolve combo from coupon!" + this.getHandledCoupon().getUniqueId());
        return false;
    }

    public void gotUpgradeComboComplete(SalesLineItem result) {
        this.upgradedCombo = result;
    }

    public void gotUpgradeDone() {
        if (this.upgradedCombo != null) {
            this.gotComboDone(this.upgradedCombo);
        } else {
            this.gotComboCancel();
        }
    }

    public void gotComboCancel() {
        this.cleanUp();
        this.emitRedeemDone(false);
    }

    public void gotComboDone(SalesLineItem newCombo) {
        this.cleanUp();
        SalesComboCouponUsage usage = SalesComboCouponUsage.createUsage((SalesCombo)((SalesCombo)newCombo), (SalesCoupon)this.getHandledCoupon(), (TriggerActivationContext)this.context);
        this.context.getAccount().addSalesCouponUsage((SalesCouponUsage)usage);
        this.emitRedeemDone(true);
        ScreenResource.refreshScreen();
    }

    private void cleanUp() {
        this.addItems.comboDone.disconnect((Object)this);
        this.addItems.comboBack.disconnect((Object)this);
        this.addItems.comboCancel.disconnect((Object)this);
    }
}

