/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.coupon.handlers;

import ordermate.OrderMate;
import ordermate.database.inventory.coupon.CouponHandlerFactory;
import ordermate.database.inventory.coupon.CouponRedeemer;
import ordermate.database.inventory.coupon.CouponType;
import ordermate.database.inventory.coupon.CouponUnredeemer;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.coupon.SalesComboCouponUsage;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.sales.coupon.SalesPriceAdjustmentCouponUsage;
import waitermate.gui.screens.ordering.additems.AddItems;
import waitermate.gui.screens.ordering.coupon.AbstractCouponRedeemer;
import waitermate.gui.screens.ordering.coupon.AbstractCouponUnredeemer;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateAdjustmentCouponRedeemer;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateAdjustmentCouponUnredeemer;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateComboCouponRedeemer;
import waitermate.gui.screens.ordering.coupon.handlers.WaiterMateComboCouponUnredeemer;

public class WaiterMateCouponHandlerFactory
implements CouponHandlerFactory {
    private AddItems addItems;

    public WaiterMateCouponHandlerFactory(AddItems addItems) {
        this.addItems = addItems;
    }

    public CouponRedeemer getCouponRedeemer(SalesCoupon salesCoupon, TriggerActivationContext context) {
        AbstractCouponRedeemer redeemer = null;
        InventoryCoupon coupon = salesCoupon.getInventoryCoupon();
        if (CouponType.Combo.equals((Object)coupon.getCouponType())) {
            redeemer = new WaiterMateComboCouponRedeemer(salesCoupon, this.addItems);
        } else if (CouponType.PriceAdjustment.equals((Object)coupon.getCouponType())) {
            redeemer = new WaiterMateAdjustmentCouponRedeemer(salesCoupon);
        } else {
            OrderMate.LOG.warn("WaiterMate coupon handler cannot handle " + coupon.getCouponType());
        }
        return redeemer;
    }

    public CouponUnredeemer getCouponUnredeemer(SalesCouponUsage usage, TriggerActivationContext context) {
        AbstractCouponUnredeemer unredeemer = null;
        InventoryCoupon coupon = usage.getCoupon().getInventoryCoupon();
        if (CouponType.Combo.equals((Object)coupon.getCouponType())) {
            unredeemer = new WaiterMateComboCouponUnredeemer((SalesComboCouponUsage)usage);
        } else if (CouponType.PriceAdjustment.equals((Object)coupon.getCouponType())) {
            unredeemer = new WaiterMateAdjustmentCouponUnredeemer((SalesPriceAdjustmentCouponUsage)usage);
        } else {
            OrderMate.LOG.warn("WaiterMate coupon handler cannot handle " + coupon.getCouponType());
        }
        return unredeemer;
    }
}

