/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.HtmlUtils;
import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class VoucherCreator {
    private GiftVoucher voucher;
    private String uuid;
    private VoucherCreationResult result;

    public VoucherCreator(String scannedUuid) {
        this.uuid = scannedUuid;
    }

    public GiftVoucher start() {
        if (this.uuid == null) {
            this.result = VoucherCreationResult.INVALID;
            return null;
        }
        this.voucher = this.tryCreateVoucher(this.uuid);
        return this.voucher;
    }

    private GiftVoucher tryCreateVoucher(String uuidToCreate) {
        VoucherResponse response = this.doCreate(uuidToCreate, false);
        if (response == null) {
            this.result = VoucherCreationResult.NO_RESPONSE;
            return null;
        }
        if (!response.isApproved() && response.getError() == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Voucher with UUID ").append(HtmlUtils.highlight((String)uuidToCreate, (String)"green", (boolean)true, (boolean)false));
            sb.append(" not found. Create voucher?");
            HtmlUtils.html((String)sb.toString());
            boolean doCreate = Dialogs.displayChoiceDialog((String)HtmlUtils.html((String)sb.toString()), (String)"New Voucher! Create?", (String)"Yes", (String)"No", (boolean)true);
            if (doCreate) {
                response = this.doCreate(uuidToCreate, doCreate);
                if (response == null) {
                    this.result = VoucherCreationResult.NO_RESPONSE;
                    return null;
                }
                this.result = response.getVoucher() == null ? VoucherCreationResult.REJECTED : VoucherCreationResult.ACCEPTED;
                return response.getVoucher();
            }
        } else if (!response.isApproved()) {
            if (VoucherError.CANNOT_CREATE.equals((Object)response.getError())) {
                this.result = VoucherCreationResult.REJECTED;
                return null;
            }
            if (response.getVoucher() == null) {
                this.result = VoucherCreationResult.INVALID;
                return null;
            }
        }
        this.result = VoucherCreationResult.ACCEPTED;
        return response.getVoucher();
    }

    private VoucherResponse doCreate(String uuidToCreate, boolean bypass) {
        CreateVoucherTask task = new CreateVoucherTask(uuidToCreate, bypass);
        ProgressDialog.doProgressDialog((Task)task);
        return task.getResponse();
    }

    private void displayNotFoundDialog(String UUID) {
        Dialogs.displayOkDialog((String)HtmlUtils.html((String)("Voucher id " + HtmlUtils.boldColor((String)UUID, (String)"green") + " is not found!")), (String)"Getting Voucher Unsuccessful");
    }

    public void handleResult() {
        if (this.result != null) {
            switch (this.result) {
                case ACCEPTED: {
                    break;
                }
                case REJECTED: {
                    Dialogs.displayOkDialog((String)"A voucher for this ID could not be retrieved or created.", (String)"Voucher Creation Failed");
                    OrderMate.LOG.warn("Voucher creation request was rejected: Authority rejected. Voucher ID: " + this.uuid);
                    break;
                }
                case INVALID: {
                    this.displayNotFoundDialog(this.uuid);
                    OrderMate.LOG.warn("Voucher creation request was rejected: invalid ID. Voucher ID: " + this.uuid);
                    break;
                }
                case NO_RESPONSE: {
                    this.displayNotFoundDialog(this.uuid);
                    OrderMate.LOG.warn("Voucher creation request was rejected: No authority for this ID, or no response from authority. Voucher ID: " + this.uuid);
                    break;
                }
            }
        }
    }

    private class CreateVoucherTask
    extends AbstractTask {
        private VoucherResponse response;
        private String voucherUuid;
        private boolean bypassValidation;

        CreateVoucherTask(String id, boolean bypass) {
            this.voucherUuid = id;
            this.bypassValidation = bypass;
        }

        public String getName() {
            return "Creating New Voucher";
        }

        protected void performTask() throws Exception {
            this.response = VoucherAdministratorRMI.getInstance().createVoucher(this.voucherUuid, this.bypassValidation);
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public VoucherResponse getResponse() {
            return this.response;
        }
    }

    private static enum VoucherCreationResult {
        ACCEPTED,
        REJECTED,
        INVALID,
        NO_RESPONSE;

    }
}

