/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher;

import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.VoucherValidationUtil;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.KeyboardDialog;

public class VoucherKeyboardDialog
extends KeyboardDialog {
    public static final String VALIDATION_STATUS_NAME = "validationStatus";
    private final VoucherValidationUtil util;
    private final JLabel validationStatus;
    private AtomicBoolean timerTaskStarted = new AtomicBoolean(false);
    private AtomicBoolean userInputDetected = new AtomicBoolean(false);

    public VoucherKeyboardDialog(String label) {
        super(label);
        this.util = new VoucherValidationUtil();
        this.validationStatus = new JLabel();
        this.validationStatus.setName(VALIDATION_STATUS_NAME);
        this.validationStatus.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.validationStatus.setFont(OrderMateTheme.getLargeFont());
        this.validationStatus.setHorizontalAlignment(0);
        this.setStatusTo(ValidationStatus.Undetermined);
        this.add(this.validationStatus, "South");
    }

    private void setStatusTo(ValidationStatus status) {
        if (ValidationStatus.Valid.equals((Object)status)) {
            this.validationStatus.setText("Voucher code valid!");
            this.validationStatus.setForeground(Color.GREEN);
        } else if (ValidationStatus.Invalid.equals((Object)status)) {
            this.validationStatus.setText("Voucher code invalid!");
            this.validationStatus.setForeground(Color.RED);
        } else if (ValidationStatus.Undetermined.equals((Object)status)) {
            this.validationStatus.setText(" ");
            this.validationStatus.setForeground(Color.BLACK);
        } else if (ValidationStatus.MaxVoucherLengthReached.equals((Object)status)) {
            this.validationStatus.setText("Max voucher code length reached!");
            this.validationStatus.setForeground(Color.ORANGE);
            this.startTimerThread();
        }
    }

    private void startTimerThread() {
        if (!this.timerTaskStarted.get()) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (!VoucherKeyboardDialog.this.userInputDetected.get()) {
                        try {
                            VoucherKeyboardDialog.this.setStatusTo(ValidationStatus.Valid);
                        }
                        catch (Exception e) {
                            OrderMate.LOG.warn("Couldn't roll back the validation status, is the dialog still there?", (Throwable)e);
                        }
                    }
                    VoucherKeyboardDialog.this.timerTaskStarted.set(false);
                    VoucherKeyboardDialog.this.userInputDetected.set(false);
                }
            };
            new Timer().schedule(task, 2500L);
            this.timerTaskStarted.set(true);
        }
    }

    void gotValueText(String text) {
        String repeat;
        String formerText = this.valueLabel.getText();
        this.setValue(text);
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        if (this.timerTaskStarted.get()) {
            if (text.length() < formerText.length()) {
                this.userInputDetected.set(true);
            } else if (this.util.matchesAnyUuidLength(text)) {
                this.userInputDetected.set(false);
            }
        }
        if ((repeat = this.util.stripRepeat(text)) != null) {
            text = repeat;
            this.setValue(repeat);
        }
        if (!this.util.hasEnoughCharacters(text)) {
            this.setStatusTo(ValidationStatus.Undetermined);
        } else if (this.util.matchesSchemeFormat(text)) {
            this.setStatusTo(ValidationStatus.Valid);
        } else {
            this.setStatusTo(ValidationStatus.Invalid);
        }
    }

    protected void connectSignals() {
        this.keyboard.updated.connect((Object)this, "gotValueText");
    }

    private static enum ValidationStatus {
        Valid,
        Invalid,
        Undetermined,
        MaxVoucherLengthReached;

    }
}

