/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.giftvoucher.topup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.VoucherTransactionHelper;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentHelper;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.giftvoucher.topup.TopupVoucherNav;
import waitermate.gui.screens.ordering.giftvoucher.topup.TopupVoucherPanel;
import waitermate.gui.screens.payment.AbstractTransactionNav;
import waitermate.gui.screens.payment.AbstractVoucherTransactionScreen;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class TopupVoucherScreen
extends AbstractVoucherTransactionScreen {
    private TopupVoucherPanel gui;
    private Account currentAccount;
    private GiftVoucher giftVoucher;
    private TopupVoucherNav nav;
    private VoucherResponse response;
    private Price chargeable;
    private Date expiryDateTime;

    public TopupVoucherScreen(GiftVoucher voucher, Account account) {
        this(voucher, account, new Price("5"), new Price("10"), new Price("15"), new Price("20"), new Price("30"), new Price("50"), new Price("70"));
    }

    public TopupVoucherScreen(GiftVoucher voucher, Account account, Price ... quickTopupPrices) {
        this.giftVoucher = voucher;
        this.currentAccount = account;
        this.expiryDateTime = VoucherTransactionHelper.getInstance().returnExpiryDateForVoucher(voucher);
        this.gui = new TopupVoucherPanel(voucher, this.expiryDateTime, quickTopupPrices);
        this.gui.chargeableUpdated.connect((Object)this, "gotChargeableAmount");
        this.gui.expiryDateUpdate.connect((Object)this, "gotExpiryDate");
        this.setupNav();
    }

    @Override
    protected GiftVoucherTransaction createVoucherTransaction() {
        final AtomicReference txnRef = new AtomicReference();
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Topping up Voucher";
            }

            protected void performTask() throws Exception {
                GiftVoucherTransaction newTransaction = new GiftVoucherTransaction(TopupVoucherScreen.this.chargeable, TopupVoucherScreen.this.giftVoucher, null, null, TopupVoucherScreen.this.currentAccount, LoginManager.getEventContext());
                newTransaction.setExpiryDate(TopupVoucherScreen.this.expiryDateTime);
                newTransaction.setExpiryTime(TopupVoucherScreen.this.expiryDateTime);
                newTransaction.setAccount(TopupVoucherScreen.this.currentAccount);
                TopupVoucherScreen.this.response = null;
                TopupVoucherScreen.this.response = VoucherAdministratorRMI.getInstance().topupVoucher(newTransaction, LoginManager.getEventContext());
                TopupVoucherScreen.this.currentAccount.removeVoucherTransaction(newTransaction);
                if (TopupVoucherScreen.this.response != null) {
                    if (TopupVoucherScreen.this.response.isApproved()) {
                        GiftVoucherTransaction txn = TopupVoucherScreen.this.response.getTxn();
                        TopupVoucherScreen.this.currentAccount.removeVoucherTransaction(newTransaction);
                        TopupVoucherScreen.this.currentAccount.addVoucherTransaction(txn);
                        TopupVoucherScreen.this.assignCustomerToVoucher(txn);
                        if (txn.isActive() && txn.isAuthorised()) {
                            txnRef.set(txn);
                        }
                    } else {
                        OrderMate.LOG.error("Cannot Topup Voucher: " + TopupVoucherScreen.this.response.getError() + (TopupVoucherScreen.this.response.getDescription() == null ? "No reason" : TopupVoucherScreen.this.response.getDescription()));
                    }
                }
            }

            protected int getTotalSubTasks() {
                return 1;
            }
        };
        ProgressDialog.doProgressDialog((Task)task);
        if (this.response != null && !this.response.isApproved()) {
            Dialogs.displayOkDialog((String)"Cannot Topup Voucher", (String)(this.response.getDescription() == null ? this.response.getError().getExplanation() : this.response.getDescription()));
        }
        return (GiftVoucherTransaction)txnRef.get();
    }

    @Override
    protected boolean mayCreateTransaction() {
        return this.gui.getChargeableAmount().greaterThan((Object)Price.ZERO_NO_ROUND);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public AbstractTransactionNav createNavBar() {
        this.nav = new TopupVoucherNav(false);
        return this.nav;
    }

    void gotChargeableAmount(Price value) {
        this.chargeable = value;
        if (value.greaterThan((Object)Price.ZERO_NO_ROUND)) {
            this.nav.setOkButtonEnabled(true);
        }
    }

    void gotExpiryDate(Date expiryDate) {
        this.expiryDateTime = expiryDate;
    }

    private void assignCustomerToVoucher(GiftVoucherTransaction txn) {
        CustomerAssignmentContext context = new CustomerAssignmentContext(null, this.currentAccount, -2, LoginManager.getEventContext());
        Customer customer = new CustomerAssignmentHelper().getAssignedCustomer(context);
        if (customer != null) {
            txn.getGiftVoucher().setCustomer(customer);
            PersistenceManager.save((PersistentObject)txn.getGiftVoucher());
        }
    }
}

