/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.addmodification;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.finance.CreditLimited;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.modifyitem.addmodification.AddModificationPanel;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class AddModification
extends AbstractScreen {
    private AddModificationPanel gui;
    private NavBar navPanel;
    private SalesComponent currentComponent;
    private Set<InventoryAdd> pluses;
    private Set<AbstractSalesRemove> minuses;
    private ModificationSize selectedAddRemoveType;
    private boolean advancedAddRemove;
    private List<InventoryAdd> plussesToAdd;
    private List<AbstractSalesRemove> minusesToRemove;
    public Signal done = Signals.createSignal();

    public AddModification() {
        this.gui = new AddModificationPanel();
        SystemProperty props = SystemProperty.getInstance();
        this.advancedAddRemove = props.isAdvancedAddRemoveEnabled();
        this.gui.createLayout(this.advancedAddRemove);
        this.navPanel = new NavBar();
        this.navPanel.addRight((Component)this.navPanel.getOkButton());
        this.navPanel.setText(Internationalization.getLiteralFor((String)"SELECT_AN_INGREDIENT_TO_ADD"));
        this.gui.plusSelected.connect((Object)this, "gotPlus");
        this.gui.typeSelected.connect((Object)this, "gotType");
        this.navPanel.ok.connect((Object)this, "gotDone");
    }

    public void startAddModification(SalesComponent currentComp) {
        this.currentComponent = currentComp;
        this.plussesToAdd = new ArrayList<InventoryAdd>();
        this.minusesToRemove = new ArrayList<AbstractSalesRemove>();
        this.pluses = new LinkedHashSet<InventoryAdd>(this.currentComponent.getUnit().getPluses());
        for (SalesAdd plus : this.currentComponent.getCurrentPluses()) {
            this.pluses.remove(plus.getInventoryAdd());
        }
        this.minuses = new LinkedHashSet<AbstractSalesRemove>(this.currentComponent.getCurrentMinuses());
        this.gui.setPluses(this.pluses, this.minuses);
        if (this.advancedAddRemove) {
            this.gui.setAddRemoveTypes(ModificationSize.getAllAddTypes());
            this.selectedAddRemoveType = ModificationSize.getDefaultSize();
        }
        this.display();
    }

    void gotPlus(Modification thePlus) {
        if (this.advancedAddRemove) {
            thePlus.setModificationSize(this.selectedAddRemoveType);
        }
        if (Terminal.getLocalHost().getStickyPlusMinus()) {
            if (thePlus instanceof InventoryAdd) {
                if (this.plussesToAdd.contains(thePlus)) {
                    this.plussesToAdd.remove(thePlus);
                } else {
                    this.plussesToAdd.add((InventoryAdd)thePlus);
                }
            } else if (thePlus instanceof AbstractSalesRemove) {
                AbstractSalesRemove salesRemove = (AbstractSalesRemove)thePlus;
                if (this.minusesToRemove.contains(salesRemove)) {
                    this.minusesToRemove.remove(salesRemove);
                } else {
                    this.minusesToRemove.add(salesRemove);
                }
            } else {
                OrderMate.LOG.error("Unhandled type : " + thePlus.getClass().getSimpleName() + ", could not add in AddModification", (Throwable)new Exception());
            }
            this.display();
        } else {
            if (thePlus instanceof InventoryAdd) {
                this.currentComponent.addPlus((InventoryAdd)thePlus);
            } else if (thePlus instanceof AbstractSalesRemove) {
                this.currentComponent.removeMinus((AbstractSalesRemove)thePlus);
            } else {
                OrderMate.LOG.error("Unhandled type : " + thePlus.getClass().getSimpleName() + ", could not add in AddModification", (Throwable)new Exception());
            }
            this.done.emit();
        }
    }

    void gotType(ModificationSize theType) {
        this.selectedAddRemoveType = theType;
    }

    void gotDone() {
        if (!this.checkOversell()) {
            return;
        }
        for (Modification modification : this.plussesToAdd) {
            this.currentComponent.addPlus((InventoryAdd)modification);
        }
        for (Modification modification : this.minusesToRemove) {
            this.currentComponent.removeMinus((AbstractSalesRemove)modification);
        }
        this.done.emit();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    private boolean checkOversell() {
        Account account = this.currentComponent.getSalesItem().getAccount();
        if (account instanceof CreditLimited) {
            Price total = Price.ZERO_DOLLAR;
            for (InventoryAdd nextAdd : this.plussesToAdd) {
                total = total.add(nextAdd.getModificationPrice());
            }
            if (((CreditLimited)account).exceedsCreditLimit(total = total.multiply(this.currentComponent.getSalesItem().getQuantity()))) {
                return CreditLimitPanel.doCreditLimitDialog((CreditLimited)account, total, account.getLabel(), true);
            }
        }
        return true;
    }
}

