/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.addmodification;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponent;

class AddModificationPanel
extends JPanel
implements ActionListener {
    private DefaultScrollPaneModel pluses;
    private CustomScrollPane plusPane;
    private DataScrollPaneModel addRemoveTypes;
    private CustomScrollPane addRemoveTypesPane;
    public final Signal<Modification, ?, ?, ?, ?> plusSelected = Signals.createSignal(Modification.class, (String)"thePlus");
    public final Signal<ModificationSize, ?, ?, ?, ?> typeSelected = Signals.createSignal(ModificationSize.class, (String)"theType");

    public AddModificationPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 1)));
    }

    public void createLayout(boolean advanced) {
        if (advanced) {
            this.pluses = new DefaultScrollPaneModel(4, 5);
            this.plusPane = new CustomScrollPane((CustomScrollPaneModel)this.pluses);
            this.plusPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_PLUSES_FOR_THIS_ITEM"));
            this.add((Component)new NameDecorator((JComponent)this.plusPane, "pluses"), new Rectangle(0, 0, 17, 1));
            this.addRemoveTypes = new DataScrollPaneModel(1, 6);
            this.addRemoveTypes.objectSelected.connect((Object)this, "gotType");
            this.addRemoveTypesPane = new CustomScrollPane((CustomScrollPaneModel)this.addRemoveTypes);
            this.addRemoveTypesPane.setBorder((Border)new TitledBorder(Internationalization.getLiteralFor((String)"MULTIPLIER") + ":"));
            this.add((Component)new NameDecorator((JComponent)this.addRemoveTypesPane, "types"), new Rectangle(17, 0, 3, 1));
        } else {
            this.pluses = new DefaultScrollPaneModel(4, 5);
            this.plusPane = new CustomScrollPane((CustomScrollPaneModel)this.pluses);
            this.plusPane.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_PLUSES_FOR_THIS_ITEM"));
            this.add((Component)new NameDecorator((JComponent)this.plusPane, "pluses"), new Rectangle(0, 0, 20, 1));
        }
    }

    public void setPluses(Collection<InventoryAdd> plusList, Collection<? extends AbstractSalesRemove> currentMinuses) {
        List buttons = DataScrollPaneModel.createToggleButtons(currentMinuses, null, (ActionListener)this, (boolean)false);
        for (NameDecorator decorator : buttons) {
            CustomToggleButton minus = (CustomToggleButton)decorator.getDecorateComponent();
            OrderMateThemeI.Helper.setButtonColour((AbstractButton)minus, (Color)minus.getForeground(), (Color)EditComponent.MINUS_COLOR);
        }
        buttons.addAll(DataScrollPaneModel.createToggleButtons(plusList, null, (ActionListener)this, (boolean)false));
        this.pluses.setItems((Collection)buttons);
        this.plusPane.displayPage(0);
    }

    public void setAddRemoveTypes(List<ModificationSize> theTypes) {
        this.addRemoveTypes.setItems(theTypes, true, true, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CustomToggleButton) {
            CustomToggleButton source = (CustomToggleButton)e.getSource();
            Modification data = (Modification)source.getData();
            this.plusSelected.emit((Object)data);
        }
    }

    void gotType(Displayable type) {
        ModificationSize data = (ModificationSize)type;
        this.typeSelected.emit((Object)data);
    }
}

