/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.editcomponent;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.SecurityDecorator;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.modify.security.SwipeOverSecurityDecorator;
import waitermate.gui.screens.ordering.modifyitem.PriceLevelSelector;
import waitermate.gui.screens.ordering.modifyitem.editcomponent.EditComponent;
import waitermate.gui.screens.selectaccount.table.CoversHelper;

class EditComponentPanel
extends JPanel
implements ActionListener {
    private JButton quantityButton;
    private JButton addModificationButton;
    private JButton removeModificationButton;
    private JButton priceLevelButton;
    private StandardSecurityDecorator priceLevelSecurity;
    private JLabel nameLabel;
    private JButton optionsButton;
    private RendererScrollPaneModel rendererModel;
    private CustomScrollPane scrollPane;
    private JLabel notesLabel;
    private JLabel basePriceLabel;
    private JButton priceButton;
    private SecurityDecorator priceDecorator;
    private JButton seatButton;
    private JButton refundButton;
    private SwipeOverSecurityDecorator refundSecurity;
    public final Signal quantity = Signals.createSignal();
    public final Signal price = Signals.createSignal();
    public final Signal addModification = Signals.createSignal();
    public final Signal removeModification = Signals.createSignal();
    public final Signal seat = Signals.createSignal();
    public final Signal barcodes = Signals.createSignal();
    public final Signal up = Signals.createSignal();
    public final Signal down = Signals.createSignal();
    public final Signal options = Signals.createSignal();
    public final Signal priceLevelChanged = Signals.createSignal();
    public final Signal refund = Signals.createSignal();
    private SalesComponent component;
    private TriggerActivationContext context;
    private String refundText;

    public EditComponentPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(40, 40)));
        this.quantityButton = new JButton("3");
        this.quantityButton.setName("qtyButton");
        this.quantityButton.setIcon(IconLoader.get((String)"/waitermate/images/calc.png"));
        this.quantityButton.addActionListener(this);
        this.add((Component)this.quantityButton, new Rectangle(1, 12, 12, 6));
        this.nameLabel = new JLabel("");
        this.nameLabel.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)this.nameLabel, new Rectangle(1, 1, 30, 3));
        this.notesLabel = new JLabel("");
        this.add((Component)this.notesLabel, new Rectangle(1, 4, 30, 2));
        this.basePriceLabel = new JLabel();
        this.add((Component)this.basePriceLabel, new Rectangle(1, 6, 30, 2));
        this.optionsButton = new JButton(Internationalization.getLiteralFor((String)"OPTIONS") + ": ");
        this.optionsButton.setName("optionsButton");
        this.optionsButton.setFont(OrderMateTheme.getSmallFont());
        this.optionsButton.addActionListener(this);
        this.add((Component)this.optionsButton, new Rectangle(1, 6, 12, 6));
        this.priceButton = new JButton();
        this.priceButton.setName("openPrice");
        this.priceDecorator = new StandardSecurityDecorator((JComponent)this.priceButton, AllPermissions.EDIT_PRICE);
        this.priceButton.setIcon(IconLoader.get((String)"/waitermate/images/price.png"));
        this.priceButton.addActionListener(this);
        this.add((Component)this.priceDecorator, new Rectangle(1, 18, 12, 6));
        this.seatButton = new JButton();
        this.add((Component)this.seatButton, new Rectangle(1, 24, 12, 6));
        this.seatButton.setIcon(IconLoader.get((String)"/waitermate/images/icon_edittable16.png"));
        this.seatButton.addActionListener(this);
        this.priceLevelButton = new JButton(Internationalization.getLiteralFor((String)"PRICE_LEVEL"));
        this.priceLevelButton.setIcon(IconLoader.get((String)"/waitermate/images/price.png"));
        this.priceLevelButton.addActionListener(this);
        this.priceLevelSecurity = new StandardSecurityDecorator((JComponent)this.priceLevelButton, AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL);
        this.add((Component)this.priceLevelSecurity, new Rectangle(1, 30, 12, 6));
        this.refundButton = new JButton(Internationalization.getLiteralFor((String)"REFUND"));
        this.refundButton.setName("refundButton");
        this.refundButton.setIcon(IconLoader.get((String)"/waitermate/images/redo.png"));
        this.refundButton.addActionListener(this);
        this.refundSecurity = new SwipeOverSecurityDecorator(this.refundButton, AllPermissions.QUICK_REFUND, this.refund, new String[]{"AccountItems", "QuickSale"});
        this.refundSecurity.setTempLoginAuthourisedUser(false);
        this.add((Component)((Object)this.refundSecurity), new Rectangle(1, 36, 12, 4));
        JPanel modPanel = new JPanel();
        modPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        modPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"PLUSES_AND_MINUSES") + ":"));
        this.add((Component)modPanel, new Rectangle(14, 11, 26, 28));
        this.rendererModel = new RendererScrollPaneModel((Renderer)new PlusMinusRenderer(), 1, 6);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.rendererModel);
        modPanel.add((Component)this.scrollPane, new Rectangle(0, 0, 14, 20));
        this.addModificationButton = new JButton(Internationalization.getLiteralFor((String)"PLUS"));
        this.addModificationButton.setIcon(IconLoader.get((String)"/waitermate/images/plus.png"));
        this.addModificationButton.addActionListener(this);
        modPanel.add((Component)this.addModificationButton, new Rectangle(15, 0, 5, 4));
        this.removeModificationButton = new JButton(Internationalization.getLiteralFor((String)"MINUS"));
        this.removeModificationButton.setIcon(IconLoader.get((String)"/waitermate/images/minus.png"));
        this.removeModificationButton.addActionListener(this);
        modPanel.add((Component)this.removeModificationButton, new Rectangle(15, 16, 5, 4));
    }

    public void setPlusMinusEnabled(boolean enable) {
        this.addModificationButton.setEnabled(enable);
        this.optionsButton.setEnabled(enable);
        if (!enable) {
            this.optionsButton.setForeground(Color.GRAY);
        } else {
            this.optionsButton.setForeground(OrderMateTheme.getDefaultTextColor());
        }
        this.removeModificationButton.setEnabled(enable);
        if (enable) {
            this.scrollPane.setEmptyMessage(Internationalization.getLiteralFor((String)"SELECT_PLUS_OR_MINUS_TO_MODIFY_THIS_ITEM"));
        } else {
            this.scrollPane.setEmptyMessage("");
        }
    }

    public void setRefundEnabled(boolean enabled) {
        this.refundSecurity.setEnabled(enabled);
    }

    void setRefundVisible(boolean visible) {
        this.refundSecurity.setVisible(visible);
    }

    public void setEditingItem(boolean isItem, boolean seatNumbers, boolean editQuantity) {
        this.quantityButton.setVisible(isItem && editQuantity);
        this.seatButton.setVisible(isItem && seatNumbers);
        this.priceDecorator.setVisible(isItem);
    }

    public void setModifications(Set newPluses, Set newMinuses) {
        ArrayList ingredients = new ArrayList(newPluses);
        ingredients.addAll(newMinuses);
        this.rendererModel.setObjects(ingredients);
    }

    public void setItemName(String item) {
        this.nameLabel.setText(item);
        this.nameLabel.setFont(OrderMateTheme.getLargeFont());
    }

    public void setNotes(String notes) {
        this.notesLabel.setText(notes);
    }

    public void setOptions(SalesComponent component, TriggerActivationContext context) {
        List newOptions = component.getCurrentOptions();
        if (!newOptions.isEmpty()) {
            StringBuffer buffer = new StringBuffer("<html>");
            buffer.append(Internationalization.getLiteralFor((String)"OPTIONS") + " : ");
            buffer.append("<br>");
            buffer.append(newOptions.toString());
            buffer.append("</html>");
            this.optionsButton.setText(buffer.toString());
            this.optionsButton.setVisible(true);
        } else {
            InventoryItemUnit invUnit = component.getUnit();
            List groupLinks = invUnit.getActiveOptionGroupLinks(context);
            if (groupLinks.isEmpty()) {
                this.optionsButton.setVisible(false);
            } else {
                this.optionsButton.setText(Internationalization.getLiteralFor((String)"NO_OPTIONS_CHOSEN"));
                this.optionsButton.setVisible(true);
            }
        }
    }

    public void setSalesComponent(SalesComponent theComponent, TriggerActivationContext currentContext) {
        this.context = currentContext;
        this.component = theComponent;
        this.priceLevelSecurity.setVisible(this.component.getUnit().getPrices().size() > 1);
        this.setRefundButtonStatus();
    }

    public void setQuantity(SalesQuantity qty) {
        this.quantityButton.setText(Internationalization.getLiteralFor((String)"QUANTITY") + " " + qty);
    }

    public void setQuantity(String qtyText) {
        this.quantityButton.setText(Internationalization.getLiteralFor((String)"QUANTITY") + " " + qtyText);
    }

    public void reset() {
        this.nameLabel.setText("");
        this.quantityButton.setText("");
        this.priceDecorator.setVisible(false);
        this.seatButton.setVisible(false);
    }

    public void setPrice(Price priceAmount) {
        this.priceButton.setText(priceAmount.toString());
        this.setRefundButtonStatus();
    }

    public void setSeat(int seatNum) {
        String text = CoversHelper.getCorrectCoverLiteral();
        this.seatButton.setText(text + " " + String.valueOf(seatNum));
    }

    public void setSeatVisible(boolean visible) {
        this.seatButton.setVisible(visible);
    }

    public void setRefundText(String itemState) {
        if ("REFUNDED".equals(itemState)) {
            this.refundText = "Reverse Refund";
        } else if ("REFUNDED_WASTED".equals(itemState)) {
            this.refundText = "Reverse Refund (Wastage)";
        } else if ("ACTIVE".equals(itemState)) {
            this.refundText = "Refund";
        }
        this.setRefundButtonStatus();
    }

    private void setRefundButtonStatus() {
        if (this.refundSecurity.isEnabled() && this.refundButton != null) {
            if (this.component != null && this.component.getSalesItem().isRefund()) {
                OrderMateTheme.setupToggledButton((AbstractButton)this.refundButton);
            } else {
                OrderMateTheme.setupUntoggledButton((AbstractButton)this.refundButton);
            }
            this.refundButton.setText(this.refundText);
        }
    }

    private void doPriceLevel() {
        PriceLevelSelector.getInstance().doPriceLevel(this.component, this.context);
        this.priceLevelChanged.emit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quantityButton) {
            this.quantity.emit();
        } else if (e.getSource() == this.addModificationButton) {
            this.addModification.emit();
        } else if (e.getSource() == this.removeModificationButton) {
            this.removeModification.emit();
        } else if (e.getSource() == this.priceButton) {
            this.price.emit();
        } else if (e.getSource() == this.seatButton) {
            this.seat.emit();
        } else if (e.getSource() == this.optionsButton) {
            this.options.emit();
        } else if (e.getSource() == this.priceLevelButton) {
            this.doPriceLevel();
        }
    }

    public void setupWasteMode(boolean showAllComponents) {
        if (this.refundButton != null) {
            this.refundButton.setVisible(showAllComponents);
        }
    }

    public void gotWeightedItem() {
        this.quantityButton.setEnabled(false);
    }

    public void showBasePriceNotification(Price basePrice) {
        this.basePriceLabel.setText(Internationalization.getLiteralFor((String)"BASE_PRICES_ENABLED") + " " + basePrice);
    }

    public void hideBasePriceNotification() {
        this.basePriceLabel.setText("");
    }

    private static class PlusMinusRenderer
    implements Renderer {
        public Component createComponent() {
            return new JPanel();
        }

        public void setupComponent(Component component, Object object, int index) {
            JPanel panel = (JPanel)component;
            Modification mod = (Modification)object;
            String labelString = mod.getLabel();
            if (!mod.getModificationPrice().isZero()) {
                labelString = labelString + " (" + mod.getModificationPrice() + ")";
            }
            panel.setLayout(new BorderLayout());
            if (mod instanceof SalesAdd) {
                panel.setBackground(EditComponent.PLUS_COLOR);
                JLabel label = new JLabel();
                label.setForeground(OrderMateTheme.getDefaultTextColor());
                label.setText("+ " + labelString);
                label.setHorizontalAlignment(0);
                panel.removeAll();
                panel.add(label);
                label.removeAll();
            } else {
                panel.setBackground(EditComponent.MINUS_COLOR);
                JLabel label = new JLabel();
                label.setForeground(OrderMateTheme.getDefaultTextColor());
                label.setText("- " + labelString);
                label.setHorizontalAlignment(0);
                panel.removeAll();
                panel.add(label);
                label.removeAll();
            }
        }
    }
}

