/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.edititem;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.button.CustomButtonLabelGenerator;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.modify.security.SwipeOverSecurityDecorator;
import waitermate.gui.screens.selectaccount.table.CoversHelper;

class EditItemPanel
extends JPanel
implements ActionListener {
    private JButton quantityButton;
    private DefaultScrollPaneModel componentsModel;
    private JLabel description;
    private JLabel basePriceLabel;
    private JButton priceButton;
    private StandardSecurityDecorator priceDecorator;
    private JButton seatButton;
    private JButton priceLevelButton;
    private StandardSecurityDecorator priceLevelSecurity;
    private List buttonsList;
    private JButton refundButton;
    private SwipeOverSecurityDecorator refundSecurity;
    private String refundText;
    public final Signal componentSelected = Signals.createSignal(Displayable.class, (String)"theComponent");
    public final Signal quantity = Signals.createSignal();
    public final Signal price = Signals.createSignal();
    public final Signal seat = Signals.createSignal();
    public final Signal priceLevel = Signals.createSignal();
    public final Signal refund = Signals.createSignal();

    public EditItemPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(40, 40)));
        this.description = new JLabel();
        this.add((Component)this.description, new Rectangle(2, 1, 25, 2));
        this.basePriceLabel = new JLabel();
        this.add((Component)this.basePriceLabel, new Rectangle(2, 3, 30, 2));
        this.componentsModel = new DefaultScrollPaneModel(1, 5);
        CustomScrollPane componentPanel = new CustomScrollPane((CustomScrollPaneModel)this.componentsModel);
        componentPanel.setBorder((Border)new TitledBorder(Internationalization.getLiteralFor((String)"COMPONENTS") + ": "));
        this.add((Component)componentPanel, new Rectangle(14, 6, 25, 34));
        this.quantityButton = new CustomButton();
        this.quantityButton.setName("qtyButton");
        this.quantityButton.setIcon(IconLoader.get((String)"/waitermate/images/calc.png"));
        this.quantityButton.addActionListener(this);
        this.add((Component)this.quantityButton, new Rectangle(2, 6, 10, 6));
        this.priceButton = new JButton();
        this.priceButton.setIcon(IconLoader.get((String)"/waitermate/images/price.png"));
        this.priceDecorator = new StandardSecurityDecorator((JComponent)this.priceButton, AllPermissions.EDIT_PRICE);
        this.add((Component)this.priceDecorator, new Rectangle(2, 13, 10, 6));
        this.priceButton.addActionListener(this);
        this.seatButton = new JButton();
        this.add((Component)this.seatButton, new Rectangle(2, 20, 10, 6));
        this.seatButton.addActionListener(this);
        this.priceLevelButton = new JButton(Internationalization.getLiteralFor((String)"PRICE_LEVEL"));
        this.priceLevelButton.setIcon(IconLoader.get((String)"/waitermate/images/price.png"));
        this.priceLevelButton.addActionListener(this);
        this.priceLevelSecurity = new StandardSecurityDecorator((JComponent)this.priceLevelButton, AllPermissions.MANUALLY_CHANGE_PRICE_LEVEL);
        this.add((Component)this.priceLevelSecurity, new Rectangle(2, 27, 10, 6));
        this.refundButton = new JButton(Internationalization.getLiteralFor((String)"REFUND"));
        this.refundButton.setName("refundButton");
        this.refundButton.setIcon(IconLoader.get((String)"/waitermate/images/redo.png"));
        this.refundButton.addActionListener(this);
        this.refundSecurity = new SwipeOverSecurityDecorator(this.refundButton, AllPermissions.QUICK_REFUND, this.refund, new String[]{"AccountItems", "QuickSale"});
        this.refundSecurity.setTempLoginAuthourisedUser(false);
        this.add((Component)((Object)this.refundSecurity), new Rectangle(2, 34, 10, 6));
    }

    public void setConstituents(SalesQuantity qty, String size, List components, boolean priceLevels) {
        this.reset();
        this.quantityButton.setText(qty + "");
        this.description.setText(size);
        this.buttonsList = DataScrollPaneModel.createButtons((Collection)components, (ActionListener)this, (boolean)false, (CustomButtonLabelGenerator)new ComboSalesItemLabelGenerator());
        this.componentsModel.setItems((Collection)this.buttonsList);
        this.priceLevelSecurity.setVisible(priceLevels);
    }

    private void reset() {
        this.quantityButton.setText("");
        this.description.setText("");
        this.seatButton.setVisible(false);
        this.componentsModel.reset();
    }

    public void setSize(String size) {
        this.description.setText(size);
    }

    public void setQuantity(SalesQuantity qty) {
        this.quantityButton.setText(qty + "");
    }

    public void setQuantityVisible(boolean visible) {
        this.quantityButton.setVisible(visible);
    }

    public void setPriceVisible(boolean visible) {
        this.priceDecorator.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.quantityButton) {
            this.quantity.emit();
        } else if (e.getSource() == this.priceButton) {
            this.price.emit();
        } else if (e.getSource() == this.seatButton) {
            this.seat.emit();
        } else if (e.getSource() == this.priceLevelButton) {
            this.priceLevel.emit();
        } else if (e.getSource() instanceof CustomButton) {
            CustomButton theButton = (CustomButton)e.getSource();
            this.componentSelected.emit((Object)theButton.getData());
        }
    }

    public void setSeatVisible(boolean visible) {
        this.seatButton.setVisible(visible);
    }

    public void setPrice(Price priceAmount) {
        this.priceButton.setText(priceAmount.toString());
    }

    public void setSeat(int seatNum) {
        String text = CoversHelper.getCorrectCoverLiteral();
        this.seatButton.setText(text + " " + String.valueOf(seatNum));
    }

    public void setComponentsButtonsEnabled(boolean enabled) {
        for (JComponent currentButton : this.buttonsList) {
            currentButton.setEnabled(enabled);
        }
    }

    public void setRefundText(String itemState) {
        if ("REFUNDED".equals(itemState)) {
            this.refundText = "Reverse Refund";
        } else if ("REFUNDED_WASTED".equals(itemState)) {
            this.refundText = "Reverse Refund (Wastage)";
        } else if ("ACTIVE".equals(itemState)) {
            this.refundText = "Refund";
        }
        this.refundButton.setText(this.refundText);
    }

    public void setRefundButtonStatus(SalesLineItem item) {
        if (this.refundSecurity.isEnabled() && this.refundButton != null) {
            if (item != null && item.isRefund()) {
                OrderMateTheme.setupToggledButton((AbstractButton)this.refundButton);
            } else {
                OrderMateTheme.setupUntoggledButton((AbstractButton)this.refundButton);
            }
        }
    }

    public void showBasePriceNotification(Price basePrice) {
        this.basePriceLabel.setText(Internationalization.getLiteralFor((String)"BASE_PRICES_ENABLED") + " " + basePrice);
    }

    public void hideBasePriceNotification() {
        this.basePriceLabel.setText("");
    }

    private class ComboSalesItemLabelGenerator
    implements CustomButtonLabelGenerator<Displayable> {
        private ComboSalesItemLabelGenerator() {
        }

        public String getLabelText(Displayable displayable) {
            if (displayable instanceof SalesItem) {
                return ((SalesItem)displayable).getQuantity() + " x " + displayable.getLabel();
            }
            return displayable.getLabel();
        }
    }
}

