/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.modifyitem.removemodification;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.Modification;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.ordering.modifyitem.removemodification.RemoveModificationPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class RemoveModification
extends AbstractScreen {
    private RemoveModificationPanel gui;
    private NavBar navPanel;
    private SalesComponent currentComponent;
    private ModificationSize selectedAddRemoveType;
    private boolean advancedAddRemove;
    private Set pluses;
    private Set<InventoryRemovable> minuses;
    private List<SalesAdd> plussesToRemove;
    private List<AbstractSalesRemove> minusesToAdd;
    public Signal done = Signals.createSignal();

    public RemoveModification() {
        this.gui = new RemoveModificationPanel();
        SystemProperty props = SystemProperty.getInstance();
        this.advancedAddRemove = props.isAdvancedAddRemoveEnabled();
        this.gui.createLayout(this.advancedAddRemove);
        this.navPanel = new NavBar();
        this.navPanel.addRight((Component)this.navPanel.getOkButton());
        this.navPanel.setText(Internationalization.getLiteralFor((String)"SELECT_INGREDIENT_TO_REMOVE"));
        this.gui.minusSelected.connect((Object)this, "gotMinus");
        this.gui.typeSelected.connect((Object)this, "gotType");
        this.navPanel.ok.connect((Object)this, "gotDone");
    }

    public void startAddModification(SalesComponent currentComp) {
        this.currentComponent = currentComp;
        this.minusesToAdd = new ArrayList<AbstractSalesRemove>();
        this.plussesToRemove = new ArrayList<SalesAdd>();
        this.minuses = new LinkedHashSet<InventoryRemovable>(this.currentComponent.getRemovables());
        for (AbstractSalesRemove minus : this.currentComponent.getCurrentMinuses()) {
            Iterator<InventoryRemovable> removableIt = this.minuses.iterator();
            while (removableIt.hasNext()) {
                if (!minus.matches(removableIt.next())) continue;
                removableIt.remove();
            }
        }
        this.pluses = new LinkedHashSet(this.currentComponent.getCurrentPluses());
        this.gui.setMinuses(this.minuses, this.pluses);
        if (this.advancedAddRemove) {
            this.gui.setAddRemoveTypes(ModificationSize.getAllRemoveTypes());
            this.selectedAddRemoveType = ModificationSize.getDefaultSize();
        }
        this.display();
    }

    void gotMinus(Displayable theMinus) {
        if (theMinus instanceof InventoryRemovable) {
            AbstractSalesRemove remove = this.getRightSalesRemoveInstanceFromList(this.minusesToAdd, (InventoryRemovable)theMinus);
            if (this.advancedAddRemove) {
                remove.setModificationSize(this.selectedAddRemoveType);
            }
            this.toggleInList(this.minusesToAdd, remove);
        } else if (theMinus instanceof SalesAdd) {
            SalesAdd add = (SalesAdd)theMinus;
            if (this.advancedAddRemove) {
                add.setModificationSize(this.selectedAddRemoveType);
            }
            this.toggleInList(this.plussesToRemove, add);
        }
        if (Terminal.getLocalHost().getStickyPlusMinus()) {
            this.display();
        } else {
            this.gotDone();
        }
    }

    private <T> void toggleInList(List<T> list, T obj) {
        if (list.contains(obj)) {
            list.remove(obj);
        } else {
            list.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSalesRemove getRightSalesRemoveInstanceFromList(List<AbstractSalesRemove> list, InventoryRemovable removeableItem) {
        boolean freeNewItem = false;
        AbstractSalesRemove removeItem = removeableItem.createSalesRemove(this.currentComponent);
        try {
            for (AbstractSalesRemove item : list) {
                if (!item.getLabel().equals(removeItem.getLabel()) || !item.getComponent().equals((Object)removeItem.getComponent()) || !item.getProperties().equals(removeItem.getProperties())) continue;
                freeNewItem = true;
                AbstractSalesRemove abstractSalesRemove = item;
                return abstractSalesRemove;
            }
            AbstractSalesRemove abstractSalesRemove = removeItem;
            return abstractSalesRemove;
        }
        finally {
            if (freeNewItem) {
                removeItem = null;
            }
        }
    }

    void gotType(ModificationSize theType) {
        this.selectedAddRemoveType = theType;
    }

    void gotDone() {
        for (AbstractSalesRemove abstractSalesRemove : this.minusesToAdd) {
            this.currentComponent.addMinus(abstractSalesRemove);
        }
        for (Modification modification : this.plussesToRemove) {
            this.currentComponent.removePlus((SalesAdd)modification);
        }
        this.done.emit();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }
}

