/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.refunditems;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.signals.Signal;
import org.apache.commons.collections.CollectionUtils;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.transferitems.selectitems.SelectItems;
import waitermate.guikit.dialogs.Dialogs;

public class RefundItems {
    private Signal refundDone;
    private Signal back;
    private Account account;
    private final SelectItems itemSelection;
    private List<Sellable> itemList;
    private Set<Sellable> refundedItems;
    private static String selectedRefundState = null;
    private SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
    private static final RefundItems instance = new RefundItems();

    public static RefundItems getInstance() {
        return instance;
    }

    private RefundItems() {
        this.itemSelection = new SelectItems(true, false);
        this.itemSelection.setPreOkCondition(null);
        this.itemSelection.back.connect((Object)this, "gotBack");
        this.itemSelection.items.connect((Object)this, "gotItemList");
        this.itemSelection.itemsSplit.connect((Object)this, "gotItemsSplit");
    }

    void gotBack() {
        this.back.emit();
    }

    public void startRefund(Account accountToRefundItems, Signal done, Signal backSignal) {
        this.account = accountToRefundItems;
        this.refundDone = done;
        this.back = backSignal;
        this.refundedItems = new HashSet<Sellable>();
        List allAccountSellables = this.sellableFactory.getSellables((ItemGroup)this.account);
        for (Sellable item : allAccountSellables) {
            if (!item.isRefund()) continue;
            this.refundedItems.add(item);
        }
        this.itemSelection.startSelection((List<Sellable>)allAccountSellables, this.refundedItems);
    }

    void gotItemsSplit(Account forAccount) {
        forAccount.save();
    }

    void gotItemList(Set<Sellable> items) {
        this.itemList = new ArrayList<Sellable>(items);
        ArrayList newRefunds = (ArrayList)CollectionUtils.subtract(this.itemList, this.refundedItems);
        ArrayList newActives = (ArrayList)CollectionUtils.subtract(this.refundedItems, this.itemList);
        if (!newRefunds.isEmpty()) {
            String refundStateResult = RefundItems.doRefundQuestionDialog(null);
            if (refundStateResult == null) {
                return;
            }
            for (Sellable sellable : newRefunds) {
                if (!(sellable instanceof SalesLineItemWrapper)) continue;
                ((SalesLineItemWrapper)sellable).getSalesLineItem().setQuantity(sellable.getQuantity().negate(), LoginManager.getEventContext(), refundStateResult);
            }
        }
        for (Sellable sellable : newActives) {
            if (!(sellable instanceof SalesLineItemWrapper)) continue;
            ((SalesLineItemWrapper)sellable).getSalesLineItem().setQuantity(sellable.getQuantity().negate(), LoginManager.getEventContext());
        }
        this.refundDone.emit();
    }

    public static String doRefundQuestionDialog(Displayable displayableItem) {
        selectedRefundState = null;
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.StockControlEnabled)) {
            Dialogs.displayOptionsDialog((String)(displayableItem == null ? "Were the Items Wasted? " : "Was the Item Wasted?"), (String)(displayableItem == null ? "" : "Refunding " + displayableItem), (List)GlazedLists.eventListOf((Object[])new BasicAction[]{new ItemRefunded(), new ItemRefundedWastage()}), (boolean)true);
        } else {
            selectedRefundState = "REFUNDED";
        }
        return selectedRefundState;
    }

    public static class ItemRefundedWastage
    extends BasicAction {
        public ItemRefundedWastage() {
            super("Refund (Waste Stock)", (Icon)IconLoader.get((String)"/waitermate/images/money_small.png"));
        }

        public void actionPerformed(ActionEvent e) {
            selectedRefundState = "REFUNDED_WASTED";
        }
    }

    public static class ItemRefunded
    extends BasicAction {
        public ItemRefunded() {
            super("Refund", (Icon)IconLoader.get((String)"/waitermate/images/money_small.png"));
        }

        public void actionPerformed(ActionEvent e) {
            selectedRefundState = "REFUNDED";
        }
    }
}

