/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlBuilder;
import java.sql.Time;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;

public class AccountDetailsHelper {
    private AccountDetailsHelper() {
    }

    public static Date getRequestedDateTime(Account account) {
        Date requestedDateTime;
        Date requestedTime = account.getTimeDue();
        Date requestedDate = account.getDateDue();
        if (requestedTime == null && requestedDate == null) {
            requestedDate = requestedDateTime = DateTimeUtils.clearMillis((Date)new Date());
        } else {
            if (requestedTime == null) {
                requestedTime = new Time(System.currentTimeMillis());
            }
            if (requestedDate == null) {
                requestedDate = new Date();
            }
            requestedDateTime = DateTimeUtils.combineDateAndTime((Date)requestedDate, (Date)requestedTime);
            requestedDateTime = DateTimeUtils.clearMillis((Date)requestedDateTime);
        }
        return requestedDateTime;
    }

    public static String getCustomerOrderDetails(Account account, Date requestedDateTime) {
        HtmlBuilder html = new HtmlBuilder();
        if (account.getCustomer() != null && !account.getCustomer().getName().equals("INVALID CUSTOMER")) {
            html.append(account.getCustomer().getName());
        } else {
            html.append("Account ").append(account.getID().toString());
        }
        html.append(" has requested ");
        if (account.getTimeDue() != null) {
            if (!DateTimeUtils.dateIsToday((Date)requestedDateTime)) {
                html.appendFont(DateTimeUtils.getDateTimeFormat().format(requestedDateTime), "RED", true, false, 4);
            } else {
                html.appendFont(DateTimeUtils.getSimpleTimeFormat().format(requestedDateTime), "RED", true, false, 4);
            }
        } else {
            html.appendFont("ASAP", "RED", true, false, 4);
        }
        html.append(" ");
        html.append(AccountDetailsHelper.getAccountType(account));
        html.append(". Please confirm time.");
        return html.toString();
    }

    public static String getAccountType(Account account) {
        String accountType = "";
        if (AccountType.onlineDeliveryType.equals((Object)account.getAccountType())) {
            accountType = "Delivery";
        } else if (AccountType.onlinePickupType.equals((Object)account.getAccountType())) {
            accountType = "Pickup";
        } else {
            accountType = account.getAccountType().getLabel();
            OrderMate.LOG.warn("Error Incorrect account given");
        }
        return accountType;
    }
}

