/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.awt.event.ActionEvent;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;
import ordermate.database.sales.PhoneAccount;
import waitermate.gui.screens.ordering.saveaccount.AllowDeliveryAction;
import waitermate.gui.screens.ordering.saveaccount.WaitermateZoneSelectionPanel;

public class AssignZoneToDeliveryAction
extends AllowDeliveryAction {
    private final WaitermateZoneSelectionPanel wzsp;

    public AssignZoneToDeliveryAction(Account account, Customer customer, WaitermateZoneSelectionPanel wzsp) {
        super(account, customer);
        this.wzsp = wzsp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        this.saveAddressToStreetDirectoryRef();
    }

    private void saveAddressToStreetDirectoryRef() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (AssignZoneToDeliveryAction.this.wzsp.isSaveOptionChosen()) {
                    String streetName = AssignZoneToDeliveryAction.this.customer.getStreetName();
                    String streetType = CustomerSearch.convertStreetTypeToAbbreviation((String)AssignZoneToDeliveryAction.this.customer.getStreetType());
                    String suburb = AssignZoneToDeliveryAction.this.customer.getSuburb();
                    String postCode = AssignZoneToDeliveryAction.this.customer.getPostcode();
                    DeliveryZone zone = AssignZoneToDeliveryAction.this.wzsp.getSelectedDeliveryZone();
                    StreetDirectoryReference streetDirectoryReference = null;
                    if (zone != null) {
                        streetDirectoryReference = StreetDirectoryReference.findStreetDirectoryWithZone((String)streetName, (String)streetType, (String)suburb, (String)postCode, (DeliveryZone)zone);
                    }
                    if (streetDirectoryReference == null) {
                        streetDirectoryReference = new StreetDirectoryReference();
                        streetDirectoryReference.setSystemState("ACTIVE");
                        streetDirectoryReference.setStreetName(streetName);
                        streetDirectoryReference.setStreetType(streetType);
                        streetDirectoryReference.setSuburb(suburb);
                        streetDirectoryReference.setPostcode(postCode);
                        streetDirectoryReference.setZone(zone);
                        PersistenceManager.save((PersistentObject)streetDirectoryReference);
                    } else {
                        PersistenceManager.save(streetDirectoryReference);
                    }
                }
                if (AssignZoneToDeliveryAction.this.account instanceof PhoneAccount) {
                    ((PhoneAccount)AssignZoneToDeliveryAction.this.account).setDeliveryZone(AssignZoneToDeliveryAction.this.wzsp.getSelectedDeliveryZone());
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }
}

