/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.ordering.saveaccount.EtaPopupNav;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public class EtaPopup
extends PopupWindow {
    private Map<Integer, AbstractButton> possibleTimes;
    private AbstractButton selectedButton;
    private Integer selectedValue = 10;
    private OnlineIntegrationETA etaConfig;

    public EtaPopup(boolean isDefaults, OnlineIntegrationETA etaConfig) {
        super((NavBar)new EtaPopupNav(isDefaults));
        int i;
        this.etaConfig = etaConfig;
        ((EtaPopupNav)this.getNavBar()).setAndOk.connect((Object)this, "gotSetAndOk");
        ((EtaPopupNav)this.getNavBar()).options.connect((Object)this, "gotOptions");
        this.possibleTimes = new LinkedHashMap<Integer, AbstractButton>();
        for (i = 10; i < 60; i += 5) {
            this.makeTimeButton(i);
        }
        for (i = 60; i <= 150; i += 10) {
            this.makeTimeButton(i);
        }
        DefaultScrollPaneModel model = new DefaultScrollPaneModel(5, 4);
        model.setItems(new ArrayList<AbstractButton>(this.possibleTimes.values()));
        CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)model);
        JLabel header = new JLabel("Please select an estimated time for this order... (Account Type: " + etaConfig.getAccountType().getLabel() + ")");
        header.setFont(OrderMateTheme.getMediumFont());
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)header, "North");
        holder.add((Component)scrolly, "Center");
        this.setComponent(holder);
    }

    public Integer getEta() {
        int currentEta = this.etaConfig.getCurrentETA();
        Integer value = currentEta;
        AbstractButton button = this.possibleTimes.get(value);
        this.setSelection(button, value);
        this.startFillTheFrame();
        return this.getSelectedEta();
    }

    private void setSelection(AbstractButton button, Integer minutes) {
        if (this.selectedButton != null) {
            OrderMateTheme.setupUntoggledButton((AbstractButton)this.selectedButton);
        }
        this.selectedButton = button;
        if (this.selectedButton != null) {
            OrderMateTheme.setupToggledButton((AbstractButton)this.selectedButton);
        }
        this.selectedValue = minutes;
    }

    private void makeTimeButton(final Integer minutes) {
        StringBuilder SB = new StringBuilder();
        int hours = minutes / 60;
        int remMins = minutes % 60;
        if (hours > 0) {
            SB.append(hours).append(" Hr ");
        }
        if (remMins > 0) {
            SB.append(remMins).append(" m");
        }
        final JButton button = new JButton();
        OrderMateTheme.setupTouchScreenButton((AbstractButton)button);
        button.setAction(new AbstractAction(SB.toString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtaPopup.this.setSelection(button, minutes);
            }
        });
        this.possibleTimes.put(minutes, button);
    }

    private Integer getSelectedEta() {
        return this.selectedValue;
    }

    public void gotSetAndOk() {
        this.etaConfig.setCurrentETA(this.getSelectedEta().intValue());
        this.etaConfig.save();
        this.getNavBar().ok.emit();
    }

    public void gotOptions() {
        ArrayList buttons = new ArrayList();
        Collections.addAll(buttons, EtaMode.values());
        ObjectPopupWindow optionsWindow = new ObjectPopupWindow("ETA Options", buttons, 1, buttons.size(), true, (ObjectPopupWindow.ObjectDisplayableLabelStrategy)new ObjectPopupWindow.ObjectDisplayableLabelStrategy<EtaMode>(){

            public String getDisplayableLabel(EtaMode object) {
                return object.getLabel();
            }
        });
        EtaMode newMode = (EtaMode)optionsWindow.start();
        if (newMode != null) {
            this.etaConfig.setETAMode(newMode);
            this.etaConfig.save();
        }
    }
}

