/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.delivery.Policy;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.PreauthTransactionHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.coupon.administration.CouponAdministratorRemote;
import ordermate.database.integration.online.EtaMode;
import ordermate.database.integration.online.OnlineIntegrationETA;
import ordermate.database.integration.online.OnlineIntegrationETAHelper;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.PrintAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.gui.SaveAccount;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.dialogs.UnlockDialog;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.gui.screens.ordering.accountitems.WaitermatePreauth;
import waitermate.gui.screens.ordering.saveaccount.AddSurchargeAction;
import waitermate.gui.screens.ordering.saveaccount.AllowDeliveryAction;
import waitermate.gui.screens.ordering.saveaccount.AllowOrderAction;
import waitermate.gui.screens.ordering.saveaccount.AssignZoneToDeliveryAction;
import waitermate.gui.screens.ordering.saveaccount.ConvertToPickup;
import waitermate.gui.screens.ordering.saveaccount.EtaTimePickerPopup;
import waitermate.gui.screens.ordering.saveaccount.WaiterMateTicketData;
import waitermate.gui.screens.ordering.saveaccount.WaitermatePrintAccount;
import waitermate.gui.screens.ordering.saveaccount.WaitermateZoneSelectionPanel;
import waitermate.gui.screens.ordering.saveaccount.details.PhoneDetails;
import waitermate.gui.screens.selectaccount.phone.drivers.AutoAssignDriverSelector;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class WaitermateSaveAccount
extends SaveAccount {
    private PhoneDetails phoneDetails;
    private UnlockDialog unlockWindow;
    private EtaTimePickerPopup etaTimePickerPopup;
    private static WaitermateSaveAccount instance = new WaitermateSaveAccount();

    private WaitermateSaveAccount() {
        super((GuiHandler)new WaitermateGuiHandler(), (PrintAccount)new WaitermatePrintAccount());
    }

    public static WaitermateSaveAccount getInstance() {
        return instance;
    }

    public boolean ensureValidCustomer(Account currentAccount) {
        if (!currentAccount.getRequiresCustomer()) {
            return true;
        }
        Customer selectedCustomer = null;
        if (!currentAccount.hasCustomer()) {
            selectedCustomer = SelectCustomer.startModal(currentAccount.getCustomerRequirements(), false);
        } else {
            selectedCustomer = currentAccount.getCustomer();
            if (!selectedCustomer.getMeetsRequirements(currentAccount.getCustomerRequirements())) {
                selectedCustomer = SelectCustomer.startModal(currentAccount.getCustomerRequirements(), currentAccount.getCustomer(), true);
            }
        }
        if (selectedCustomer == null || !selectedCustomer.getMeetsRequirements(currentAccount.getCustomerRequirements())) {
            return false;
        }
        boolean inZone = true;
        if (currentAccount.isDeliverable() && SystemProperty.getInstance().isUseDeliveryZones()) {
            String message;
            StreetDirectoryReference dirRef = StreetDirectoryReference.findStreetDir((String)selectedCustomer.getStreetName(), (String)CustomerSearch.convertStreetTypeToAbbreviation((String)selectedCustomer.getStreetType()), (String)selectedCustomer.getSuburb());
            if (currentAccount instanceof PhoneAccount && ((PhoneAccount)currentAccount).getDeliveryZone() == null && dirRef != null) {
                ((PhoneAccount)currentAccount).setDeliveryZone(dirRef.getZone());
            }
            if (((PhoneAccount)currentAccount).isDeliverToWarnZone()) {
                inZone = true;
            } else if (dirRef == null || dirRef.getZone() == null) {
                inZone = false;
                inZone = this.showOptionsToAddAddressToZone(currentAccount, selectedCustomer);
            } else if (dirRef.isWarnPolicy()) {
                inZone = false;
                message = "The address you have entered is in a non-deliverable zone." + this.getZoneName(dirRef);
                inZone = Dialogs.displayOptionsDialog((String)"Out of Area Warning", (String)message, Arrays.asList(new BasicAction[]{new ConvertToPickup(currentAccount), new AllowDeliveryAction(currentAccount, selectedCustomer)}), (String)"Back", (Icon)IconLoader.get((String)"/waitermate/guikit/images/back.png"));
            }
            if (dirRef != null && dirRef.getZone() != null && dirRef.getZone().getPolicy() == Policy.PREVENT) {
                message = "You are not allowed to deliver to this zone." + this.getZoneName(dirRef);
                inZone = Dialogs.displayOptionsDialog((String)"Prevented Area", (String)message, Arrays.asList(new BasicAction[]{new ConvertToPickup(currentAccount)}), (String)"Back", (Icon)IconLoader.get((String)"/waitermate/guikit/images/back.png"));
            } else if (dirRef != null && dirRef.getZone() != null && dirRef.getZone().getPolicy() == Policy.ALLOW) {
                inZone = true;
            }
            if (!inZone && currentAccount.getCustomer() == null) {
                return this.ensureValidCustomer(currentAccount);
            }
        }
        if (!selectedCustomer.equals((Object)currentAccount.getCustomer())) {
            currentAccount.setCustomer(selectedCustomer, LoginManager.getEventContext());
        }
        return inZone && selectedCustomer.getMeetsRequirements(currentAccount.getCustomerRequirements());
    }

    private boolean showOptionsToAddAddressToZone(Account currentAccount, Customer selectedCustomer) {
        WaitermateZoneSelectionPanel wzsp = new WaitermateZoneSelectionPanel();
        wzsp.setAddress(selectedCustomer.getAddress());
        NavBar nav = new NavBar();
        JButton cancelButton = nav.getCancelButton();
        cancelButton.setText("Back");
        cancelButton.setMnemonic(66);
        cancelButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/back.png"));
        nav.addLeft((Component)cancelButton);
        PopupWindow window = new PopupWindow(nav);
        window.setText("Allow Delivery To This Address");
        window.setComponent((JComponent)wzsp);
        this.createActionButton(window, nav, new ConvertToPickup(currentAccount), 67);
        this.createActionButton(window, nav, (BasicAction)new AssignZoneToDeliveryAction(currentAccount, selectedCustomer, wzsp), 65);
        return Dialogs.displayDialog((PopupWindow)window, null, null);
    }

    private void createActionButton(final PopupWindow window, NavBar nav, BasicAction action, int mnemonic) {
        JButton button;
        JButton toAdd = button = nav.constructButton(action);
        button.setMnemonic(mnemonic);
        if (action.getPermission() != null) {
            toAdd = new StandardSecurityDecorator((JComponent)button, action.getPermission());
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.gotOk();
            }
        });
        nav.addRight((Component)toAdd);
    }

    private String getZoneName(StreetDirectoryReference dirRef) {
        String message = "";
        if (dirRef != null && dirRef.getZone() != null) {
            message = message + " (" + dirRef.getZone() + ")";
        }
        return message;
    }

    public boolean addInfo(Account toModify) {
        if (!this.ensureValidCustomer(toModify)) {
            return false;
        }
        boolean success = false;
        while (!success) {
            if (toModify instanceof PhoneAccount && !this.validatePhoneDetails((PhoneAccount)toModify)) {
                return false;
            }
            success = this.ensureValidCustomer(toModify);
            if (!(toModify instanceof OnlineAccount)) continue;
            success = this.handleOnlineAccountAddInfo((OnlineAccount)toModify);
        }
        return success;
    }

    private boolean validatePhoneDetails(PhoneAccount account) {
        if (this.phoneDetails == null) {
            this.phoneDetails = new PhoneDetails();
        }
        if (!account.isPersistent() && !this.phoneDetails.getDetails(account)) {
            return false;
        }
        if (account.requireMinimumOrderPrompt(Terminal.getLocalHost())) {
            List<BasicAction> options = Arrays.asList(new BasicAction[]{new AllowOrderAction((Account)account), new AddSurchargeAction(account)});
            String message = "This order of " + account.getTotalForMinOrderPrompt() + " is less than the minimum delivery amount of " + Terminal.getLocalHost().getMinimumDeliveryOrder();
            return Dialogs.displayOptionsDialog((String)"Check Account Total", (String)message, options, (String)"Revise Order", (Icon)IconLoader.get((String)"/waitermate/guikit/images/back.png"));
        }
        return true;
    }

    private boolean handleOnlineAccountAddInfo(OnlineAccount account) {
        OnlineIntegrationETA eta = OnlineIntegrationETA.getETAForAccountType((AccountType)account.getAccountType());
        EtaMode mode = eta.getETAMode();
        if (EtaMode.USE_CURRENT.equals((Object)mode)) {
            OnlineIntegrationETAHelper.setEtaForAccount((Account)account, (OnlineIntegrationETA)eta);
            account.save();
        } else if (EtaMode.ALWAYS_ASK.equals((Object)mode)) {
            this.ensureHasEta(account);
        } else if (EtaMode.ASK_UNPAID.equals((Object)mode)) {
            if (Price.ZERO_DOLLAR.equals((Object)account.getDue())) {
                OnlineIntegrationETAHelper.setEtaForAccount((Account)account, (OnlineIntegrationETA)eta);
                account.save();
            } else {
                this.ensureHasEta(account);
            }
        } else {
            throw new IllegalStateException("Invalid enumeration value for EtaMode!");
        }
        return true;
    }

    public void transferOnlineAccountToTable(OnlineAccount account) {
        if (account.getLogicalTable() != null) {
            EventContext context = LoginManager.getEventContext();
            LogicalTable table = account.getLogicalTable();
            User user = LoginManager.getInstance().getUser();
            TableAccount target = table.getAccount();
            if (target == null) {
                target = new TableAccount(user, table, 1, Terminal.getLocalHost());
            }
            if (target.isLocked(user) || target.lock(user)) {
                List transferredItems = this.performTransfer((Account)account, (Account)target, account.getItems(), false, context, false);
                target.lock(user);
                for (FinanceTransaction txn : new ArrayList(account.getFinanceTransactions())) {
                    if (!txn.isActive()) continue;
                    account.removeFinanceTransaction(txn);
                    txn.setSystemState("ACTIVE");
                    target.addFinanceTransaction(txn);
                }
                this.saveAccount((Account)target, context);
                this.printPrep((Account)target);
                target.unlock();
                account.close(context);
            } else {
                Dialogs.displayOkDialog((String)"Cannot transfer to table at this time, it is locked by another user.", (String)"Table Locked");
            }
        }
    }

    public boolean lockAccount(Lockable lockable) {
        return this.lockAccount(lockable, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean lockAccount(Lockable lockable, boolean canUnlock) {
        User currentUser = LoginManager.getInstance().getUser();
        if (!lockable.lock(currentUser)) {
            if (canUnlock) {
                if (!this.unlock(lockable)) return false;
                lockable.lock(currentUser);
            } else {
                this.getUnlockWindow().displayLockInfo(lockable, lockable.getLabel());
                return false;
            }
        }
        if (!(lockable instanceof LogicalTable)) return true;
        LogicalTable table = (LogicalTable)lockable;
        TerminalEventLog.logLockTable((LogicalTable)table, (User)currentUser, (Terminal)Terminal.getLocalHost());
        return true;
    }

    public boolean unlock(Lockable lockable) {
        return this.getUnlockWindow().display(lockable, lockable.getLabel());
    }

    public boolean getTicketData(Account currentAccount) {
        WaiterMateTicketData ticketData = new WaiterMateTicketData(currentAccount, Terminal.getLocalHost());
        if (!ticketData.needsTicketData()) {
            return true;
        }
        Collection<String> data = ticketData.start();
        if (data != null && !data.isEmpty()) {
            currentAccount.clearTicketData();
            for (String toAdd : data) {
                currentAccount.addToTicketData(toAdd);
            }
        }
        return data != null;
    }

    private UnlockDialog getUnlockWindow() {
        if (this.unlockWindow == null) {
            this.unlockWindow = new UnlockDialog();
        }
        return this.unlockWindow;
    }

    public void assignAccountsToTraining(List<Account> accounts, Refreshable state) {
        this.assignToTraining(accounts, LoginManager.getEventContext(), null, state);
    }

    private void ensureHasEta(OnlineAccount account) {
        if (account.getEta() == null) {
            if (account.getItems().size() > 0) {
                OnlineIntegrationETA eta = OnlineIntegrationETA.getETAForAccountType((AccountType)account.getAccountType());
                account.setEta(this.getEta(eta, (Account)account));
            } else {
                account.setEta(new Date());
            }
            account.save();
        }
    }

    private Date getEta(OnlineIntegrationETA etaConfig, Account account) {
        if (this.etaTimePickerPopup == null) {
            this.etaTimePickerPopup = new EtaTimePickerPopup(etaConfig);
        } else {
            this.etaTimePickerPopup.setETAConfig(etaConfig);
        }
        return this.etaTimePickerPopup.getEta(account);
    }

    protected User getAutoAssignedDriver(PhoneAccount account) {
        if (!SystemProperty.getInstance().canAssignDriver(account.getDriverAssignmentSettlementTypeForAccount())) {
            OrderMate.LOG.info("Cannot assign drivers, therefore marking account as delivered.");
            account.setDelivered();
            account.save();
            return null;
        }
        return AutoAssignDriverSelector.getInstance().getSelectedDriver();
    }

    public boolean closeAccount(Account toClose, boolean save, boolean allowCloseFree, EventContext context) {
        if (toClose.isOpen() && super.closeAccount(toClose, save, allowCloseFree, context)) {
            this.checkForPreauthOnClose(toClose);
            TriggerActivationContext triggerContext = new TriggerActivationContext(context, (ItemGroup)toClose);
            CouponAdministratorRemote.getInstance().accountClosed(triggerContext);
        }
        return !toClose.isOpen();
    }

    private void checkForPreauthOnClose(Account toClose) {
        PreauthTransaction txn = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)toClose).toString());
        if (txn != null) {
            Dialogs.displayOkDialog((String)("There is a preauth amount of " + PreauthTransactionHelper.getInstance().getTotalPreAuth(txn) + ". This will now be voided."), (String)"Void Preauth");
            new WaitermatePreauth((ItemGroup)toClose).doVoid(txn);
        }
    }
}

