/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.gui.themes.OrderMateTheme;
import org.jdesktop.swingx.JXMonthView;
import waitermate.adminkit.WaiterMateAdminGuiUtils;
import waitermate.guikit.NavBar;

public class CalendarPanel
extends JPanel {
    private JXMonthView monthView;
    private Date selectedDate;
    private JButton backButton;
    private JButton forwardButton;
    private JButton todayButton;
    private DateFormat dateFormat = DateTimeUtils.getLongFormat();
    private final NavBar calNav;

    public CalendarPanel() {
        super(new BorderLayout());
        this.selectedDate = new Date();
        this.monthView = new JXMonthView(this.selectedDate);
        this.monthView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarPanel.this.selectedDate = CalendarPanel.this.monthView.getSelectionDate();
                CalendarPanel.this.updateDateTextField();
            }
        });
        this.backButton = this.constructButton(IconLoader.get((String)"/waitermate/images/leftarrow.png"), null, "backButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(CalendarPanel.this.monthView.getSelectionDate());
                cal.add(2, -1);
                CalendarPanel.this.monthView.setFirstDisplayedDay(cal.getTime());
                CalendarPanel.this.monthView.setSelectionDate(cal.getTime());
            }
        });
        this.forwardButton = this.constructButton(IconLoader.get((String)"/waitermate/images/rightarrow.png"), null, "forwardButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(CalendarPanel.this.monthView.getSelectionDate());
                cal.add(2, 1);
                CalendarPanel.this.monthView.setFirstDisplayedDay(cal.getTime());
                CalendarPanel.this.monthView.setSelectionDate(cal.getTime());
            }
        });
        this.todayButton = this.constructButton(null, "Today", "todayButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar cal = Calendar.getInstance();
                CalendarPanel.this.monthView.setFirstDisplayedDay(cal.getTime());
                CalendarPanel.this.monthView.setSelectionDate(cal.getTime());
                CalendarPanel.this.selectedDate = CalendarPanel.this.monthView.getSelectionDate();
                CalendarPanel.this.updateDateTextField();
            }
        });
        this.calNav = new NavBar();
        this.calNav.addLeft((Component)this.backButton);
        this.calNav.addRight(this.createMaxButton(this.todayButton));
        this.calNav.addRight(Box.createRigidArea(new Dimension(20, 0)));
        this.calNav.addRight((Component)this.forwardButton);
        WaiterMateAdminGuiUtils.getInstance().standardMonthViewSetup(this.monthView);
        this.monthView.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)this.monthView, "Center");
        this.add((Component)this.calNav, "South");
        this.updateDateTextField();
    }

    private Component createMaxButton(JButton button) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)button, "Center");
        return panel;
    }

    private void updateDateTextField() {
        this.calNav.setText(this.dateFormat.format(this.selectedDate));
    }

    public void reset() {
        this.selectedDate = new Date();
        this.setup(this.selectedDate, new Date[0]);
        this.updateDateTextField();
    }

    private void setup(Date startDate, Date[] flaggedDates) {
        this.monthView.setSelectionDate(startDate);
        this.monthView.setFlaggedDates(flaggedDates == null ? new Date[]{} : flaggedDates);
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public boolean isToday() {
        Calendar selCal = Calendar.getInstance();
        selCal.setTime(this.selectedDate);
        Calendar cal = Calendar.getInstance();
        return cal.get(1) == selCal.get(1) && cal.get(6) == selCal.get(6);
    }

    private JButton constructButton(ImageIcon icon, String text, String name, ActionListener listener) {
        JButton button = new JButton();
        button.setIcon(icon);
        button.setText(text);
        button.setName(name);
        button.setMargin(new Insets(5, 5, 5, 5));
        if (listener != null) {
            button.addActionListener(listener);
        }
        return button;
    }

    public JXMonthView getJXMonthView() {
        return this.monthView;
    }
}

