/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.PhoneAccount;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.details.PhoneDetailsPanel;
import waitermate.guikit.ModalScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class PhoneDetails
extends ModalScreen {
    private PhoneAccount currentAccount;
    private PhoneDetailsPanel gui = new PhoneDetailsPanel();
    private NavBar nav;
    private boolean ok = false;
    public static final String TIME_DUE_IN_PAST = "Time due cannot be set in the past";

    public PhoneDetails() {
        this.gui.setName("phoneDetailsPanel");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.setText("Account Details");
        this.nav.ok.connect((Object)this, "complete");
        this.nav.back.connect((Object)this, "exitDisplay");
    }

    public boolean getDetails(PhoneAccount account) {
        this.currentAccount = account;
        this.gui.reset(this.currentAccount.getComment(), Terminal.getLocalHost().hasDeliveryMode(), this.currentAccount.isDeliverable());
        this.ok = false;
        this.display();
        return this.ok;
    }

    public void exitDisplay() {
        this.currentAccount = null;
        this.stopDisplay();
    }

    public void complete() {
        if (this.gui.hasTimeOrDate() || SystemProperty.getInstance().isOnlinePhoneSetTimeDue()) {
            if (this.gui.isTimeIsAfterDue()) {
                Dialogs.displayOkDialog((String)"Invalid Due Time", (String)TIME_DUE_IN_PAST);
                return;
            }
            this.currentAccount.setDateDue(this.gui.getDateDue());
            this.setTimeDue();
        }
        this.currentAccount.setComment(this.gui.getComment());
        this.currentAccount.setDeliverable(this.gui.isDeliverable(), LoginManager.getEventContext());
        this.ok = true;
        this.exitDisplay();
    }

    private void setTimeDue() {
        if (this.gui.getTimeDue() == this.gui.getOriginalTimeDue()) {
            Date dateTimeFromGUI = DateTimeUtils.combineDateAndTime((Date)this.gui.getDateDue(), (Date)this.gui.getTimeDue());
            Date currentDate = new Date();
            if (dateTimeFromGUI.getTime() <= currentDate.getTime()) {
                OrderMate.LOG.info("Setting TimeDue ");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(12, 5);
                this.currentAccount.setTimeDue(calendar.getTime());
            } else {
                this.currentAccount.setTimeDue((Date)this.gui.getTimeDue());
            }
        } else {
            this.currentAccount.setTimeDue((Date)this.gui.getTimeDue());
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

