/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.ordering.saveaccount.details;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.database.users.User;
import ordermate.gui.button.CustomButton;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.details.CalendarPanel;
import waitermate.gui.screens.ordering.saveaccount.details.TimePanel;
import waitermate.gui.screens.selectaccount.phone.drivers.AutoAssignDriverSelector;
import waitermate.guikit.dialogs.Dialogs;

class PhoneDetailsPanel
extends JPanel
implements ActionListener {
    private JButton commentButton = new JButton("Edit Comment");
    private String commentString = "";
    private JLabel commentLabel;
    private TimePanel timePanel;
    private CalendarPanel datePanel;
    private JPanel deliveryPanel;
    private JToggleButton pickupButton;
    private JToggleButton deliveryButton;
    private SelectedDriver selectedDriver;

    public PhoneDetailsPanel() {
        this.commentButton.addActionListener(this);
        this.commentLabel = new JLabel("");
        this.commentLabel.setHorizontalAlignment(0);
        JPanel commentPanel = new JPanel();
        commentPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(12, 5)));
        commentPanel.add((Component)this.commentButton, new Rectangle(4, 4, 4, 1));
        commentPanel.add((Component)this.commentLabel, new Rectangle(0, 0, 12, 4));
        commentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comment:"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.deliveryButton = new JToggleButton("Delivery");
        this.deliveryButton.setIcon(IconLoader.get((String)"/waitermate/images/delivery.png"));
        this.pickupButton = new JToggleButton("Pickup");
        this.pickupButton.setIcon(IconLoader.get((String)"/waitermate/images/phoneOrder.png"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.deliveryButton);
        group.add(this.pickupButton);
        this.pickupButton.addActionListener(this);
        this.deliveryButton.addActionListener(this);
        this.deliveryPanel = new JPanel();
        this.deliveryPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(12, 6)));
        this.deliveryPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Delivered:"), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.timePanel = new TimePanel();
        this.datePanel = new CalendarPanel();
        this.datePanel.setName("datePanel");
        this.datePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Date Due:"), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.selectedDriver = new SelectedDriver();
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(40, 8)));
        topPanel.add((Component)commentPanel, new Rectangle(0, 0, 20, 8));
        topPanel.add((Component)this.deliveryPanel, new Rectangle(20, 0, 20, 8));
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(40, 16)));
        this.add((Component)topPanel, new Rectangle(0, 0, 40, 6));
        this.add((Component)this.datePanel, new Rectangle(0, 6, 20, 10));
        this.add((Component)this.timePanel, new Rectangle(20, 6, 20, 5));
        this.add((Component)this.selectedDriver.driverPanel, new Rectangle(20, 11, 20, 5));
    }

    private void setupForDelivery() {
        this.deliveryPanel.removeAll();
        this.deliveryPanel.add((Component)this.deliveryButton, new Rectangle(0, 2, 5, 2));
        this.deliveryPanel.add((Component)this.pickupButton, new Rectangle(7, 2, 5, 2));
        this.selectedDriver.setEnabled(true);
    }

    private void setupForNoDelivery() {
        this.deliveryPanel.removeAll();
        this.deliveryPanel.add((Component)this.pickupButton, new Rectangle(4, 2, 4, 1));
        this.selectedDriver.setEnabled(true);
    }

    public void reset(String dispComment, boolean deliveryMode, boolean deliverable) {
        String comment = dispComment;
        if (comment == null) {
            comment = "";
        }
        this.timePanel.reset();
        this.datePanel.reset();
        this.commentString = comment;
        this.setCommentText(this.commentString);
        this.selectedDriver.init();
        if (deliveryMode) {
            this.setupForDelivery();
            if (deliverable) {
                this.deliveryButton.setSelected(true);
            } else {
                this.pickupButton.setSelected(true);
            }
        } else {
            this.setupForNoDelivery();
            this.pickupButton.setSelected(true);
        }
        this.selectedDriver.setEnabled(this.deliveryButton.isSelected());
    }

    public boolean hasTimeOrDate() {
        return this.timePanel.hasTime() || !this.datePanel.isToday();
    }

    public boolean hasComment() {
        return !this.getComment().equals("");
    }

    public String getComment() {
        return this.commentString;
    }

    private void setCommentText(String text) {
        this.commentLabel.setText("<html><h2>" + text + "</h2><html>");
    }

    public Time getTimeDue() {
        return this.timePanel.getTimeDue();
    }

    public boolean isTimeIsAfterDue() {
        Date dueDate = DateTimeUtils.combineDateAndTime((Date)this.datePanel.getSelectedDate(), (Date)this.timePanel.getTimeDue());
        return dueDate.before(this.getOriginalTimeDue());
    }

    public Time getOriginalTimeDue() {
        return this.timePanel.getOriginalTime();
    }

    public Date getDateDue() {
        return this.datePanel.getSelectedDate();
    }

    public boolean isDeliverable() {
        return !this.pickupButton.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.commentButton) {
            String str = Dialogs.getString((String)"Comment: ", (String)this.commentString);
            if (str != "\u0000") {
                this.commentString = str;
                this.setCommentText(this.commentString);
            }
        } else if (event.getSource() == this.pickupButton || event.getSource() == this.deliveryButton) {
            this.selectedDriver.setEnabled(this.deliveryButton.isSelected());
        }
    }

    class SelectedDriver {
        private CustomButton driverButton;
        private JLabel notes;
        private JLabel instructions;
        private JPanel driverPanel;

        SelectedDriver() {
            this.setupComponents();
            this.init();
        }

        public void init() {
            AutoAssignDriverSelector.getInstance().reset();
            this.driverButton.setData((Displayable)AutoAssignDriverSelector.getInstance().getSelectedDriver());
        }

        void setEnabled(boolean enabled) {
            this.driverButton.setEnabled(enabled);
            this.instructions.setEnabled(enabled);
            this.notes.setEnabled(enabled);
        }

        private void setupComponents() {
            this.driverPanel = new JPanel(new BorderLayout(5, 10));
            this.driverPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Driver:"), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            this.notes = new JLabel("This order will be assigned to");
            this.notes.setHorizontalTextPosition(0);
            this.driverPanel.add((Component)this.notes, "North");
            User user = AutoAssignDriverSelector.getInstance().getCurrentAutoAssign();
            this.driverButton = new CustomButton((Displayable)(user == null ? LoginManager.getInstance().getUser() : user));
            this.driverButton.setName("driverButton");
            this.driverButton.setAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectedDriver.this.changeDriver();
                }
            });
            this.driverPanel.add((Component)this.driverButton, "Center");
            this.instructions = new JLabel("Click button to change the driver");
            this.instructions.setHorizontalTextPosition(0);
            this.driverPanel.add((Component)this.instructions, "South");
        }

        private void changeDriver() {
            this.driverButton.setData((Displayable)AutoAssignDriverSelector.getInstance().selectUserToAssign());
        }
    }
}

